/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.data;

import java.util.HashSet;
import java.util.Set;
import org.apache.syncope.client.report.ReportletConf;
import org.apache.syncope.client.to.ReportExecTO;
import org.apache.syncope.client.to.ReportTO;
import org.apache.syncope.core.init.ImplementationClassNamesLoader;
import org.apache.syncope.core.init.JobInstanceLoader;
import org.apache.syncope.core.persistence.beans.Report;
import org.apache.syncope.core.persistence.beans.ReportExec;
import org.apache.syncope.core.persistence.dao.ReportExecDAO;
import org.apache.syncope.core.report.Reportlet;
import org.apache.syncope.core.report.ReportletConfClass;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class ReportDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(ReportDataBinder.class);
    private static final String[] IGNORE_REPORT_PROPERTIES = new String[]{"id", "reportlets", "executions", "latestExecStatus"};
    private static final String[] IGNORE_REPORT_EXECUTION_PROPERTIES = new String[]{"id", "report", "execResult"};
    @Autowired
    private ReportExecDAO reportExecDAO;
    @Autowired
    private SchedulerFactoryBean scheduler;
    @Autowired
    private ImplementationClassNamesLoader classNamesLoader;

    public Set<Class<Reportlet>> getAllReportletClasses() {
        HashSet<Class<Reportlet>> reportletClasses = new HashSet<Class<Reportlet>>();
        for (String className : this.classNamesLoader.getClassNames(ImplementationClassNamesLoader.Type.REPORTLET)) {
            try {
                Class reportletClass = ClassUtils.forName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
                reportletClasses.add(reportletClass);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Could not load class {}", (Object)className);
            }
            catch (LinkageError e) {
                LOG.warn("Could not link class {}", (Object)className);
            }
        }
        return reportletClasses;
    }

    public Class<? extends ReportletConf> getReportletConfClass(Class<Reportlet> reportletClass) {
        Class<? extends ReportletConf> result = null;
        ReportletConfClass annotation = reportletClass.getAnnotation(ReportletConfClass.class);
        if (annotation != null) {
            result = annotation.value();
        }
        return result;
    }

    public Class<Reportlet> findReportletClassHavingConfClass(Class<? extends ReportletConf> reportletConfClass) {
        Class<Reportlet> result = null;
        for (Class<Reportlet> reportletClass : this.getAllReportletClasses()) {
            Class<? extends ReportletConf> found = this.getReportletConfClass(reportletClass);
            if (found == null || !found.equals(reportletConfClass)) continue;
            result = reportletClass;
        }
        return result;
    }

    public void getReport(Report report, ReportTO reportTO) {
        BeanUtils.copyProperties((Object)reportTO, (Object)report, (String[])IGNORE_REPORT_PROPERTIES);
        report.setReportletConfs(null);
        for (ReportletConf conf : reportTO.getReportletConfs()) {
            report.addReportletConf(conf);
        }
    }

    public ReportTO getReportTO(Report report) {
        Trigger trigger;
        ReportTO reportTO = new ReportTO();
        reportTO.setId(report.getId().longValue());
        BeanUtils.copyProperties((Object)report, (Object)reportTO, (String[])IGNORE_REPORT_PROPERTIES);
        reportTO.setReportletConfs(report.getReportletConfs());
        ReportExec latestExec = this.reportExecDAO.findLatestStarted(report);
        reportTO.setLatestExecStatus(latestExec == null ? "" : latestExec.getStatus());
        reportTO.setStartDate(latestExec == null ? null : latestExec.getStartDate());
        reportTO.setEndDate(latestExec == null ? null : latestExec.getEndDate());
        for (ReportExec reportExec : report.getExecs()) {
            reportTO.addExecution(this.getReportExecTO(reportExec));
        }
        String triggerName = JobInstanceLoader.getTriggerName(JobInstanceLoader.getJobName(report));
        try {
            trigger = this.scheduler.getScheduler().getTrigger(triggerName, "DEFAULT");
        }
        catch (SchedulerException e) {
            LOG.warn("While trying to get to " + triggerName, (Throwable)e);
            trigger = null;
        }
        if (trigger != null) {
            reportTO.setLastExec(trigger.getPreviousFireTime());
            reportTO.setNextExec(trigger.getNextFireTime());
        }
        return reportTO;
    }

    public ReportExecTO getReportExecTO(ReportExec execution) {
        ReportExecTO executionTO = new ReportExecTO();
        executionTO.setId(execution.getId().longValue());
        BeanUtils.copyProperties((Object)execution, (Object)executionTO, (String[])IGNORE_REPORT_EXECUTION_PROPERTIES);
        if (execution.getId() != null) {
            executionTO.setId(execution.getId().longValue());
        }
        executionTO.setReport(execution.getReport().getId().longValue());
        return executionTO;
    }
}

