/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.data;

import org.apache.syncope.client.to.AccountPolicyTO;
import org.apache.syncope.client.to.PasswordPolicyTO;
import org.apache.syncope.client.to.PolicyTO;
import org.apache.syncope.client.to.SyncPolicyTO;
import org.apache.syncope.core.persistence.beans.AccountPolicy;
import org.apache.syncope.core.persistence.beans.PasswordPolicy;
import org.apache.syncope.core.persistence.beans.Policy;
import org.apache.syncope.core.persistence.beans.SyncPolicy;
import org.apache.syncope.types.AccountPolicySpec;
import org.apache.syncope.types.PasswordPolicySpec;
import org.apache.syncope.types.SyncPolicySpec;
import org.springframework.stereotype.Component;

@Component
public class PolicyDataBinder {
    public <T extends PolicyTO> T getPolicyTO(Policy policy) {
        PasswordPolicyTO policyTO;
        boolean isGlobal = Boolean.FALSE;
        switch (policy.getType()) {
            case GLOBAL_PASSWORD: 
            case GLOBAL_ACCOUNT: 
            case GLOBAL_SYNC: {
                isGlobal = Boolean.TRUE;
            }
        }
        switch (policy.getType()) {
            case GLOBAL_PASSWORD: 
            case PASSWORD: {
                if (!(policy.getSpecification() instanceof PasswordPolicySpec)) {
                    throw new ClassCastException("policy is expected to be typed PasswordPolicySpec: " + policy.getSpecification().getClass().getName());
                }
                policyTO = new PasswordPolicyTO(isGlobal);
                policyTO.setSpecification((PasswordPolicySpec)policy.getSpecification());
                break;
            }
            case GLOBAL_ACCOUNT: 
            case ACCOUNT: {
                if (!(policy.getSpecification() instanceof AccountPolicySpec)) {
                    throw new ClassCastException("policy is expected to be typed AccountPolicySpec: " + policy.getSpecification().getClass().getName());
                }
                policyTO = new AccountPolicyTO(isGlobal);
                ((AccountPolicyTO)policyTO).setSpecification((AccountPolicySpec)policy.getSpecification());
                break;
            }
            default: {
                if (!(policy.getSpecification() instanceof SyncPolicySpec)) {
                    throw new ClassCastException("policy is expected to be typed SyncPolicySpec: " + policy.getSpecification().getClass().getName());
                }
                policyTO = new SyncPolicyTO(isGlobal);
                ((SyncPolicyTO)policyTO).setSpecification((SyncPolicySpec)policy.getSpecification());
            }
        }
        policyTO.setId(policy.getId().longValue());
        policyTO.setDescription(policy.getDescription());
        return (T)policyTO;
    }

    public <T extends Policy> T getPolicy(T policy, PolicyTO policyTO) {
        if (policy != null && ((Policy)policy).getType() != policyTO.getType()) {
            throw new IllegalArgumentException(String.format("Cannot update %s from %s", ((Policy)policy).getType(), policyTO.getType()));
        }
        boolean isGlobal = Boolean.FALSE;
        switch (policyTO.getType()) {
            case GLOBAL_PASSWORD: 
            case GLOBAL_ACCOUNT: 
            case GLOBAL_SYNC: {
                isGlobal = Boolean.TRUE;
            }
        }
        switch (policyTO.getType()) {
            case GLOBAL_PASSWORD: 
            case PASSWORD: {
                if (!(policyTO instanceof PasswordPolicyTO)) {
                    throw new ClassCastException("policyTO is expected to be typed PasswordPolicyTO: " + policyTO.getClass().getName());
                }
                if (policy == null) {
                    policy = new PasswordPolicy(isGlobal);
                }
                ((Policy)policy).setSpecification((PasswordPolicySpec)((PasswordPolicyTO)policyTO).getSpecification());
                break;
            }
            case GLOBAL_ACCOUNT: 
            case ACCOUNT: {
                if (!(policyTO instanceof AccountPolicyTO)) {
                    throw new ClassCastException("policyTO is expected to be typed AccountPolicyTO: " + policyTO.getClass().getName());
                }
                if (policy == null) {
                    policy = new AccountPolicy(isGlobal);
                }
                ((Policy)policy).setSpecification((AccountPolicySpec)((AccountPolicyTO)policyTO).getSpecification());
                break;
            }
            default: {
                if (!(policyTO instanceof SyncPolicyTO)) {
                    throw new ClassCastException("policyTO is expected to be typed SyncPolicyTO: " + policyTO.getClass().getName());
                }
                if (policy == null) {
                    policy = new SyncPolicy(isGlobal);
                }
                ((Policy)policy).setSpecification((SyncPolicySpec)((SyncPolicyTO)policyTO).getSpecification());
            }
        }
        ((Policy)policy).setDescription(policyTO.getDescription());
        return (T)policy;
    }
}

