/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.data;

import org.apache.syncope.client.to.DerivedSchemaTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.client.validation.SyncopeClientException;
import org.apache.syncope.core.persistence.beans.AbstractDerSchema;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.util.JexlUtil;
import org.apache.syncope.types.SyncopeClientExceptionType;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class DerivedSchemaDataBinder {
    private static final String[] ignoreDerivedSchemaProperties = new String[]{"schemas", "derivedAttributes"};
    @Autowired
    private JexlUtil jexlUtil;

    private <T extends AbstractSchema> AbstractDerSchema populate(AbstractDerSchema derivedSchema, DerivedSchemaTO derivedSchemaTO, SyncopeClientCompositeErrorException scce) throws SyncopeClientCompositeErrorException {
        if (derivedSchemaTO.getExpression() == null) {
            SyncopeClientException requiredValuesMissing = new SyncopeClientException(SyncopeClientExceptionType.RequiredValuesMissing);
            requiredValuesMissing.addElement("expression");
            scce.addException(requiredValuesMissing);
        }
        if (!this.jexlUtil.isExpressionValid(derivedSchemaTO.getExpression())) {
            SyncopeClientException invalidMandatoryCondition = new SyncopeClientException(SyncopeClientExceptionType.InvalidValues);
            invalidMandatoryCondition.addElement(derivedSchemaTO.getExpression());
            scce.addException(invalidMandatoryCondition);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        BeanUtils.copyProperties((Object)derivedSchemaTO, (Object)derivedSchema, (String[])ignoreDerivedSchemaProperties);
        return derivedSchema;
    }

    public <T extends AbstractSchema> AbstractDerSchema create(DerivedSchemaTO derivedSchemaTO, AbstractDerSchema derivedSchema) {
        return this.populate(derivedSchema, derivedSchemaTO, new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST));
    }

    public AbstractDerSchema update(DerivedSchemaTO derivedSchemaTO, AbstractDerSchema derivedSchema) {
        return this.populate(derivedSchema, derivedSchemaTO, new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST));
    }

    public <T extends AbstractDerSchema> DerivedSchemaTO getDerivedSchemaTO(T derivedSchema) {
        DerivedSchemaTO derivedSchemaTO = new DerivedSchemaTO();
        BeanUtils.copyProperties(derivedSchema, (Object)derivedSchemaTO, (String[])ignoreDerivedSchemaProperties);
        return derivedSchemaTO;
    }
}

