/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.data;

import java.util.Map;
import javassist.NotFoundException;
import org.apache.syncope.client.to.ConnInstanceTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.client.validation.SyncopeClientException;
import org.apache.syncope.core.persistence.beans.ConnInstance;
import org.apache.syncope.core.persistence.dao.ConnInstanceDAO;
import org.apache.syncope.core.util.ConnBundleManager;
import org.apache.syncope.types.ConnConfPropSchema;
import org.apache.syncope.types.ConnConfProperty;
import org.apache.syncope.types.SyncopeClientExceptionType;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.impl.api.ConfigurationPropertyImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class ConnInstanceDataBinder {
    private static final String[] IGNORE_PROPERTIES = new String[]{"id", "resources"};
    @Autowired
    private ConnInstanceDAO connectorInstanceDAO;
    @Autowired
    private ConnBundleManager connBundleManager;

    public ConnInstance getConnInstance(ConnInstanceTO connInstanceTO) throws SyncopeClientCompositeErrorException {
        SyncopeClientCompositeErrorException compositeErrorException = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
        SyncopeClientException requiredValuesMissing = new SyncopeClientException(SyncopeClientExceptionType.RequiredValuesMissing);
        if (connInstanceTO.getBundleName() == null) {
            requiredValuesMissing.addElement("bundlename");
        }
        if (connInstanceTO.getVersion() == null) {
            requiredValuesMissing.addElement("bundleversion");
        }
        if (connInstanceTO.getConnectorName() == null) {
            requiredValuesMissing.addElement("connectorname");
        }
        if (connInstanceTO.getConfiguration() == null || connInstanceTO.getConfiguration().isEmpty()) {
            requiredValuesMissing.addElement("configuration");
        }
        ConnInstance connectorInstance = new ConnInstance();
        BeanUtils.copyProperties((Object)connInstanceTO, (Object)connectorInstance, (String[])IGNORE_PROPERTIES);
        if (!requiredValuesMissing.isEmpty()) {
            compositeErrorException.addException(requiredValuesMissing);
        }
        if (compositeErrorException.hasExceptions()) {
            throw compositeErrorException;
        }
        return connectorInstance;
    }

    public ConnInstance updateConnInstance(long connInstanceId, ConnInstanceTO connInstanceTO) throws SyncopeClientCompositeErrorException {
        SyncopeClientCompositeErrorException compositeErrorException = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
        SyncopeClientException requiredValuesMissing = new SyncopeClientException(SyncopeClientExceptionType.RequiredValuesMissing);
        if (connInstanceId == 0L) {
            requiredValuesMissing.addElement("connector id");
        }
        ConnInstance connInstance = this.connectorInstanceDAO.find(connInstanceId);
        if (connInstanceTO.getBundleName() != null) {
            connInstance.setBundleName(connInstanceTO.getBundleName());
        }
        if (connInstanceTO.getVersion() != null) {
            connInstance.setVersion(connInstanceTO.getVersion());
        }
        if (connInstanceTO.getConnectorName() != null) {
            connInstance.setConnectorName(connInstanceTO.getConnectorName());
        }
        if (connInstanceTO.getConfiguration() != null && !connInstanceTO.getConfiguration().isEmpty()) {
            connInstance.setConfiguration(connInstanceTO.getConfiguration());
        }
        if (connInstanceTO.getDisplayName() != null) {
            connInstance.setDisplayName(connInstanceTO.getDisplayName());
        }
        connInstance.setCapabilities(connInstanceTO.getCapabilities());
        if (!requiredValuesMissing.isEmpty()) {
            compositeErrorException.addException(requiredValuesMissing);
        }
        if (compositeErrorException.hasExceptions()) {
            throw compositeErrorException;
        }
        return connInstance;
    }

    public ConnInstanceTO getConnInstanceTO(ConnInstance connInstance) throws NotFoundException {
        ConnInstanceTO connInstanceTO = new ConnInstanceTO();
        connInstanceTO.setId(connInstance.getId() != null ? connInstance.getId() : 0L);
        ConfigurationProperties properties = this.connBundleManager.getConfigurationProperties(connInstance.getBundleName(), connInstance.getVersion(), connInstance.getConnectorName());
        BeanUtils.copyProperties((Object)connInstance, (Object)connInstanceTO, (String[])IGNORE_PROPERTIES);
        Map connInstanceToConfMap = connInstanceTO.getConfigurationMap();
        for (String propName : properties.getPropertyNames()) {
            ConfigurationPropertyImpl configurationProperty = (ConfigurationPropertyImpl)properties.getProperty(propName);
            if (!connInstanceToConfMap.containsKey(propName)) {
                ConnConfPropSchema connConfPropSchema = new ConnConfPropSchema();
                connConfPropSchema.setName(configurationProperty.getName());
                connConfPropSchema.setDisplayName(configurationProperty.getDisplayName(propName));
                connConfPropSchema.setHelpMessage(configurationProperty.getHelpMessage(propName));
                connConfPropSchema.setRequired(configurationProperty.isRequired());
                connConfPropSchema.setType(configurationProperty.getType().getName());
                connConfPropSchema.setConfidential(configurationProperty.isConfidential());
                connConfPropSchema.setOrder(configurationProperty.getOrder());
                ConnConfProperty property = new ConnConfProperty();
                property.setSchema(connConfPropSchema);
                connInstanceTO.addConfiguration(property);
                continue;
            }
            ((ConnConfProperty)connInstanceToConfMap.get(propName)).getSchema().setDisplayName(configurationProperty.getDisplayName(propName));
        }
        return connInstanceTO;
    }
}

