/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.ValidationException;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.lang.StringUtils;
import org.apache.syncope.client.mod.AbstractAttributableMod;
import org.apache.syncope.client.mod.AttributeMod;
import org.apache.syncope.client.to.AbstractAttributableTO;
import org.apache.syncope.client.to.AttributeTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.client.validation.SyncopeClientException;
import org.apache.syncope.core.persistence.beans.AbstractAttr;
import org.apache.syncope.core.persistence.beans.AbstractAttrValue;
import org.apache.syncope.core.persistence.beans.AbstractAttributable;
import org.apache.syncope.core.persistence.beans.AbstractDerAttr;
import org.apache.syncope.core.persistence.beans.AbstractDerSchema;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.beans.AbstractVirAttr;
import org.apache.syncope.core.persistence.beans.AbstractVirSchema;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.SchemaMapping;
import org.apache.syncope.core.persistence.dao.AttrDAO;
import org.apache.syncope.core.persistence.dao.AttrValueDAO;
import org.apache.syncope.core.persistence.dao.ConfDAO;
import org.apache.syncope.core.persistence.dao.DerAttrDAO;
import org.apache.syncope.core.persistence.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.dao.MembershipDAO;
import org.apache.syncope.core.persistence.dao.PolicyDAO;
import org.apache.syncope.core.persistence.dao.ResourceDAO;
import org.apache.syncope.core.persistence.dao.RoleDAO;
import org.apache.syncope.core.persistence.dao.SchemaDAO;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.persistence.dao.VirAttrDAO;
import org.apache.syncope.core.persistence.dao.VirSchemaDAO;
import org.apache.syncope.core.propagation.PropagationByResource;
import org.apache.syncope.core.util.AttributableUtil;
import org.apache.syncope.core.util.JexlUtil;
import org.apache.syncope.types.AttributableType;
import org.apache.syncope.types.PropagationOperation;
import org.apache.syncope.types.SyncopeClientExceptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAttributableDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractAttributableDataBinder.class);
    @Autowired
    protected ConfDAO confDAO;
    @Autowired
    protected RoleDAO roleDAO;
    @Autowired
    protected SchemaDAO schemaDAO;
    @Autowired
    protected DerSchemaDAO derivedSchemaDAO;
    @Autowired
    protected VirSchemaDAO virtualSchemaDAO;
    @Autowired
    protected AttrDAO attributeDAO;
    @Autowired
    protected DerAttrDAO derAttrDAO;
    @Autowired
    protected VirAttrDAO virAttrDAO;
    @Autowired
    protected AttrValueDAO attributeValueDAO;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected ResourceDAO resourceDAO;
    @Autowired
    protected MembershipDAO membershipDAO;
    @Autowired
    protected PolicyDAO policyDAO;
    @Autowired
    private JexlUtil jexlUtil;

    private <T extends AbstractSchema> T getSchema(String schemaName, Class<T> reference) {
        AbstractSchema schema = null;
        if (StringUtils.isNotBlank((String)schemaName)) {
            schema = (AbstractSchema)this.schemaDAO.find(schemaName, reference);
            if (schema == null) {
                LOG.debug("Ignoring invalid schema {}", (Object)schemaName);
            } else if (schema.isReadonly()) {
                schema = null;
                LOG.debug("Ignoring virtual or readonly schema {}", (Object)schemaName);
            }
        }
        return (T)schema;
    }

    private <T extends AbstractDerSchema> T getDerivedSchema(String derSchemaName, Class<T> reference) {
        T derivedSchema = null;
        if (StringUtils.isNotBlank((String)derSchemaName) && (derivedSchema = (T)this.derivedSchemaDAO.find(derSchemaName, reference)) == null) {
            LOG.debug("Ignoring invalid derived schema {}", (Object)derSchemaName);
        }
        return derivedSchema;
    }

    private <T extends AbstractVirSchema> T getVirtualSchema(String virSchemaName, Class<T> reference) {
        T virtualSchema = null;
        if (StringUtils.isNotBlank((String)virSchemaName) && (virtualSchema = (T)this.virtualSchemaDAO.find(virSchemaName, reference)) == null) {
            LOG.debug("Ignoring invalid virtual schema {}", (Object)virSchemaName);
        }
        return virtualSchema;
    }

    private ExternalResource getResource(String resourceName) {
        ExternalResource resource = this.resourceDAO.find(resourceName);
        if (resource == null) {
            LOG.debug("Ignoring invalid resource {} ", (Object)resourceName);
        }
        return resource;
    }

    protected void fillAttribute(List<String> values, AttributableUtil attributableUtil, AbstractSchema schema, AbstractAttr attribute, SyncopeClientException invalidValues) {
        List<String> valuesProvided = schema.isMultivalue() ? values : (values.isEmpty() ? Collections.EMPTY_LIST : Collections.singletonList(values.iterator().next()));
        for (String value : valuesProvided) {
            if (value == null || value.isEmpty()) {
                LOG.debug("Null value for {}, ignoring", (Object)schema.getName());
                continue;
            }
            try {
                attribute.addValue(value, attributableUtil);
            }
            catch (ValidationException e) {
                LOG.error("Invalid value for attribute " + schema.getName() + ": " + value, (Throwable)e);
                invalidValues.addElement(schema.getName() + ": " + value);
            }
        }
    }

    private boolean evaluateMandatoryCondition(String mandatoryCondition, List<? extends AbstractAttr> attributes) {
        MapContext jexlContext = new MapContext();
        this.jexlUtil.addAttrsToContext(attributes, (JexlContext)jexlContext);
        return Boolean.parseBoolean(this.jexlUtil.evaluate(mandatoryCondition, (JexlContext)jexlContext));
    }

    private boolean evaluateMandatoryCondition(ExternalResource resource, List<? extends AbstractAttr> attributes, String intAttrName, AttributableUtil attributableUtil) {
        boolean result;
        SchemaMapping mapping;
        Iterator<SchemaMapping> itor = resource.getMappings(intAttrName, attributableUtil.intMappingType()).iterator();
        for (result = false; itor.hasNext() && !result; result |= this.evaluateMandatoryCondition(mapping.getMandatoryCondition(), attributes)) {
            mapping = itor.next();
        }
        return result;
    }

    private boolean evaluateMandatoryCondition(Collection<ExternalResource> resources, List<? extends AbstractAttr> attributes, String intAttrName, AttributableUtil attributableUtil) {
        boolean result = false;
        Iterator<ExternalResource> itor = resources.iterator();
        while (itor.hasNext() && !result) {
            ExternalResource resource = itor.next();
            if (!resource.isForceMandatoryConstraint()) continue;
            result |= this.evaluateMandatoryCondition(resource, attributes, intAttrName, attributableUtil);
        }
        return result;
    }

    private SyncopeClientException checkMandatory(AttributableUtil attributableUtil, AbstractAttributable attributable) {
        SyncopeClientException requiredValuesMissing = new SyncopeClientException(SyncopeClientExceptionType.RequiredValuesMissing);
        LOG.debug("Check mandatory constraint among resources {}", attributable.getResources());
        List allSchemas = this.schemaDAO.findAll(attributableUtil.schemaClass());
        for (AbstractSchema schema : allSchemas) {
            if (attributable.getAttribute(schema.getName()) != null || schema.isReadonly() || !this.evaluateMandatoryCondition(schema.getMandatoryCondition(), attributable.getAttributes()) && !this.evaluateMandatoryCondition(attributable.getResources(), attributable.getAttributes(), schema.getName(), attributableUtil)) continue;
            LOG.error("Mandatory schema " + schema.getName() + " not provided with values");
            requiredValuesMissing.addElement(schema.getName());
        }
        return requiredValuesMissing;
    }

    public PropagationByResource fillVirtual(AbstractAttributable attributable, Set<String> vAttrsToBeRemoved, Set<AttributeMod> vAttrsToBeUpdated, AttributableUtil attributableUtil) {
        Object virtualAttribute;
        Object virtualSchema;
        PropagationByResource propByRes = new PropagationByResource();
        for (String vAttrToBeRemoved : vAttrsToBeRemoved) {
            virtualSchema = this.getVirtualSchema(vAttrToBeRemoved, attributableUtil.virtualSchemaClass());
            if (virtualSchema == null) continue;
            virtualAttribute = attributable.getVirtualAttribute(((AbstractVirSchema)virtualSchema).getName());
            if (virtualAttribute == null) {
                LOG.debug("No virtual attribute found for schema {}", (Object)((AbstractVirSchema)virtualSchema).getName());
            } else {
                attributable.removeVirtualAttribute(virtualAttribute);
                this.virAttrDAO.delete(virtualAttribute);
            }
            for (SchemaMapping mapping : this.resourceDAO.findAllMappings()) {
                if (!((AbstractVirSchema)virtualSchema).getName().equals(mapping.getIntAttrName()) || mapping.getIntMappingType() != attributableUtil.virtualIntMappingType() || mapping.getResource() == null || !attributable.getResources().contains(mapping.getResource())) continue;
                propByRes.add(PropagationOperation.UPDATE, mapping.getResource().getName());
                if (!mapping.isAccountid() || virtualAttribute == null || ((AbstractVirAttr)virtualAttribute).getValues().isEmpty()) continue;
                propByRes.addOldAccountId(mapping.getResource().getName(), ((AbstractVirAttr)virtualAttribute).getValues().get(0));
            }
        }
        LOG.debug("Virtual attributes to be removed:\n{}", (Object)propByRes);
        for (AttributeMod vAttrToBeUpdated : vAttrsToBeUpdated) {
            virtualSchema = this.getVirtualSchema(vAttrToBeUpdated.getSchema(), attributableUtil.virtualSchemaClass());
            if (virtualSchema == null) continue;
            for (SchemaMapping mapping : this.resourceDAO.findAllMappings()) {
                if (!((AbstractVirSchema)virtualSchema).getName().equals(mapping.getIntAttrName()) || mapping.getIntMappingType() != attributableUtil.virtualIntMappingType() || mapping.getResource() == null || !attributable.getResources().contains(mapping.getResource())) continue;
                propByRes.add(PropagationOperation.UPDATE, mapping.getResource().getName());
            }
            virtualAttribute = attributable.getVirtualAttribute(((AbstractVirSchema)virtualSchema).getName());
            if (virtualAttribute == null) {
                virtualAttribute = attributableUtil.newVirtualAttribute();
                ((AbstractVirAttr)virtualAttribute).setVirtualSchema(virtualSchema);
                attributable.addVirtualAttribute(virtualAttribute);
            }
            ArrayList<String> values = new ArrayList<String>(((AbstractVirAttr)virtualAttribute).getValues());
            values.removeAll(vAttrToBeUpdated.getValuesToBeRemoved());
            values.addAll(vAttrToBeUpdated.getValuesToBeAdded());
            ((AbstractVirAttr)virtualAttribute).setValues(values);
            ((AbstractVirAttr)virtualAttribute).setOwner((AbstractAttributable)attributable);
        }
        LOG.debug("Virtual attributes to be added:\n{}", (Object)propByRes);
        return propByRes;
    }

    protected PropagationByResource fill(AbstractAttributable attributable, AbstractAttributableMod attributableMod, AttributableUtil attributableUtil, SyncopeClientCompositeErrorException compositeErrorException) throws SyncopeClientCompositeErrorException {
        SyncopeClientException requiredValuesMissing;
        Object derivedAttribute;
        Object derivedSchema;
        Object attribute;
        Object schema;
        ExternalResource resource;
        PropagationByResource propByRes = new PropagationByResource();
        SyncopeClientException invalidValues = new SyncopeClientException(SyncopeClientExceptionType.InvalidValues);
        for (String resourceToBeRemoved : attributableMod.getResourcesToBeRemoved()) {
            resource = this.getResource(resourceToBeRemoved);
            if (resource == null) continue;
            propByRes.add(PropagationOperation.DELETE, resource.getName());
            attributable.removeResource(resource);
        }
        LOG.debug("Resources to be removed:\n{}", (Object)propByRes);
        for (String resourceToBeAdded : attributableMod.getResourcesToBeAdded()) {
            resource = this.getResource(resourceToBeAdded);
            if (resource == null) continue;
            propByRes.add(PropagationOperation.CREATE, resource.getName());
            attributable.addResource(resource);
        }
        LOG.debug("Resources to be added:\n{}", (Object)propByRes);
        for (String attributeToBeRemoved : attributableMod.getAttributesToBeRemoved()) {
            schema = this.getSchema(attributeToBeRemoved, attributableUtil.schemaClass());
            if (schema == null) continue;
            attribute = attributable.getAttribute(((AbstractSchema)schema).getName());
            if (attribute == null) {
                LOG.debug("No attribute found for schema {}", schema);
            } else {
                String newValue = null;
                for (AttributeMod mod : attributableMod.getAttributesToBeUpdated()) {
                    if (!((AbstractSchema)schema).getName().equals(mod.getSchema())) continue;
                    newValue = (String)mod.getValuesToBeAdded().get(0);
                }
                if (!((AbstractSchema)schema).isUniqueConstraint() || !((AbstractAttrValue)((AbstractAttr)attribute).getUniqueValue()).getStringValue().equals(newValue)) {
                    attributable.removeAttribute(attribute);
                    this.attributeDAO.delete(((AbstractAttr)attribute).getId(), attributableUtil.attributeClass());
                }
            }
            for (SchemaMapping mapping : this.resourceDAO.findAllMappings()) {
                if (!((AbstractSchema)schema).getName().equals(mapping.getIntAttrName()) || mapping.getIntMappingType() != attributableUtil.intMappingType() || mapping.getResource() == null || !attributable.getResources().contains(mapping.getResource())) continue;
                propByRes.add(PropagationOperation.UPDATE, mapping.getResource().getName());
                if (!mapping.isAccountid() || attribute == null || ((AbstractAttr)attribute).getValuesAsStrings().isEmpty()) continue;
                propByRes.addOldAccountId(mapping.getResource().getName(), ((AbstractAttr)attribute).getValuesAsStrings().iterator().next());
            }
        }
        LOG.debug("Attributes to be removed:\n{}", (Object)propByRes);
        for (AttributeMod attributeMod : attributableMod.getAttributesToBeUpdated()) {
            schema = this.getSchema(attributeMod.getSchema(), attributableUtil.schemaClass());
            if (schema == null) continue;
            for (SchemaMapping mapping : this.resourceDAO.findAllMappings()) {
                if (!((AbstractSchema)schema).getName().equals(mapping.getIntAttrName()) || mapping.getIntMappingType() != attributableUtil.intMappingType() || mapping.getResource() == null || !attributable.getResources().contains(mapping.getResource())) continue;
                propByRes.add(PropagationOperation.UPDATE, mapping.getResource().getName());
            }
            attribute = attributable.getAttribute(((AbstractSchema)schema).getName());
            if (attribute == null) {
                attribute = attributableUtil.newAttribute();
                ((AbstractAttr)attribute).setSchema(schema);
                ((AbstractAttr)attribute).setOwner((AbstractAttributable)attributable);
                attributable.addAttribute(attribute);
            }
            HashSet<Long> valuesToBeRemoved = new HashSet<Long>();
            for (String valueToBeRemoved : attributeMod.getValuesToBeRemoved()) {
                if (((AbstractSchema)((AbstractAttr)attribute).getSchema()).isUniqueConstraint()) {
                    if (((AbstractAttr)attribute).getUniqueValue() == null || !valueToBeRemoved.equals(((AbstractAttrValue)((AbstractAttr)attribute).getUniqueValue()).getValueAsString())) continue;
                    valuesToBeRemoved.add(((AbstractAttrValue)((AbstractAttr)attribute).getUniqueValue()).getId());
                    continue;
                }
                for (AbstractAttrValue mav : ((AbstractAttr)attribute).getValues()) {
                    if (!valueToBeRemoved.equals(mav.getValueAsString())) continue;
                    valuesToBeRemoved.add(mav.getId());
                }
            }
            for (Long attributeValueId : valuesToBeRemoved) {
                this.attributeValueDAO.delete(attributeValueId, attributableUtil.attributeValueClass());
            }
            List valuesToBeAdded = attributeMod.getValuesToBeAdded();
            if (!(valuesToBeAdded == null || valuesToBeAdded.isEmpty() || ((AbstractSchema)schema).isUniqueConstraint() && ((AbstractAttr)attribute).getUniqueValue() != null && ((String)valuesToBeAdded.iterator().next()).equals(((AbstractAttrValue)((AbstractAttr)attribute).getUniqueValue()).getValueAsString()))) {
                this.fillAttribute(attributeMod.getValuesToBeAdded(), attributableUtil, (AbstractSchema)schema, (AbstractAttr)attribute, invalidValues);
            }
            if (!((AbstractAttr)attribute).getValuesAsStrings().isEmpty()) continue;
            this.attributeDAO.delete(attribute);
        }
        if (!invalidValues.isEmpty()) {
            compositeErrorException.addException(invalidValues);
        }
        LOG.debug("Attributes to be updated:\n{}", (Object)propByRes);
        for (String derivedAttributeToBeRemoved : attributableMod.getDerivedAttributesToBeRemoved()) {
            derivedSchema = this.getDerivedSchema(derivedAttributeToBeRemoved, attributableUtil.derivedSchemaClass());
            if (derivedSchema == null) continue;
            derivedAttribute = attributable.getDerivedAttribute(((AbstractDerSchema)derivedSchema).getName());
            if (derivedAttribute == null) {
                LOG.debug("No derived attribute found for schema {}", (Object)((AbstractDerSchema)derivedSchema).getName());
            } else {
                this.derAttrDAO.delete(derivedAttribute);
            }
            for (SchemaMapping mapping : this.resourceDAO.findAllMappings()) {
                if (!((AbstractDerSchema)derivedSchema).getName().equals(mapping.getIntAttrName()) || mapping.getIntMappingType() != attributableUtil.derivedIntMappingType() || mapping.getResource() == null || !attributable.getResources().contains(mapping.getResource())) continue;
                propByRes.add(PropagationOperation.UPDATE, mapping.getResource().getName());
                if (!mapping.isAccountid() || derivedAttribute == null || ((AbstractDerAttr)derivedAttribute).getValue(attributable.getAttributes()).isEmpty()) continue;
                propByRes.addOldAccountId(mapping.getResource().getName(), ((AbstractDerAttr)derivedAttribute).getValue(attributable.getAttributes()));
            }
        }
        LOG.debug("Derived attributes to be removed:\n{}", (Object)propByRes);
        for (String derivedAttributeToBeAdded : attributableMod.getDerivedAttributesToBeAdded()) {
            derivedSchema = this.getDerivedSchema(derivedAttributeToBeAdded, attributableUtil.derivedSchemaClass());
            if (derivedSchema == null) continue;
            for (SchemaMapping mapping : this.resourceDAO.findAllMappings()) {
                if (!((AbstractDerSchema)derivedSchema).getName().equals(mapping.getIntAttrName()) || mapping.getIntMappingType() != attributableUtil.derivedIntMappingType() || mapping.getResource() == null || !attributable.getResources().contains(mapping.getResource())) continue;
                propByRes.add(PropagationOperation.UPDATE, mapping.getResource().getName());
            }
            derivedAttribute = attributableUtil.newDerivedAttribute();
            ((AbstractDerAttr)derivedAttribute).setDerivedSchema(derivedSchema);
            ((AbstractDerAttr)derivedAttribute).setOwner((AbstractAttributable)attributable);
            attributable.addDerivedAttribute(derivedAttribute);
        }
        LOG.debug("Derived attributes to be added:\n{}", (Object)propByRes);
        if (AttributableType.USER != attributableUtil.getType()) {
            this.fillVirtual(attributable, attributableMod.getVirtualAttributesToBeRemoved(), attributableMod.getVirtualAttributesToBeUpdated(), attributableUtil);
        }
        if (!(requiredValuesMissing = this.checkMandatory(attributableUtil, attributable)).isEmpty()) {
            compositeErrorException.addException(requiredValuesMissing);
        }
        if (compositeErrorException.hasExceptions()) {
            throw compositeErrorException;
        }
        return propByRes;
    }

    public void fillVirtual(AbstractAttributable attributable, List<AttributeTO> vAttrs, AttributableUtil attributableUtil) {
        for (AttributeTO attributeTO : vAttrs) {
            Object virtualAttribute = attributable.getVirtualAttribute(attributeTO.getSchema());
            if (virtualAttribute == null) {
                Object virtualSchema = this.getVirtualSchema(attributeTO.getSchema(), attributableUtil.virtualSchemaClass());
                if (virtualSchema == null) continue;
                virtualAttribute = attributableUtil.newVirtualAttribute();
                ((AbstractVirAttr)virtualAttribute).setVirtualSchema(virtualSchema);
                ((AbstractVirAttr)virtualAttribute).setOwner((AbstractAttributable)attributable);
                attributable.addVirtualAttribute(virtualAttribute);
                ((AbstractVirAttr)virtualAttribute).setValues(attributeTO.getValues());
                continue;
            }
            ((AbstractVirAttr)virtualAttribute).setValues(attributeTO.getValues());
        }
    }

    protected void fill(AbstractAttributable attributable, AbstractAttributableTO attributableTO, AttributableUtil attributableUtil, SyncopeClientCompositeErrorException compositeErrorException) throws SyncopeClientCompositeErrorException {
        SyncopeClientException invalidValues = new SyncopeClientException(SyncopeClientExceptionType.InvalidValues);
        for (AttributeTO attributeTO : attributableTO.getAttributes()) {
            Object schema;
            if (attributeTO.getValues() == null || attributeTO.getValues().isEmpty() || (schema = this.getSchema(attributeTO.getSchema(), attributableUtil.schemaClass())) == null) continue;
            Object attribute = attributable.getAttribute(((AbstractSchema)schema).getName());
            if (attribute == null) {
                attribute = attributableUtil.newAttribute();
                ((AbstractAttr)attribute).setSchema(schema);
            }
            this.fillAttribute(attributeTO.getValues(), attributableUtil, (AbstractSchema)schema, (AbstractAttr)attribute, invalidValues);
            if (((AbstractAttr)attribute).getValuesAsStrings().isEmpty()) continue;
            attributable.addAttribute(attribute);
            ((AbstractAttr)attribute).setOwner((AbstractAttributable)attributable);
        }
        if (!invalidValues.isEmpty()) {
            compositeErrorException.addException(invalidValues);
        }
        for (AttributeTO attributeTO : attributableTO.getDerivedAttributes()) {
            Object derivedSchema = this.getDerivedSchema(attributeTO.getSchema(), attributableUtil.derivedSchemaClass());
            if (derivedSchema == null) continue;
            Object derivedAttribute = attributableUtil.newDerivedAttribute();
            ((AbstractDerAttr)derivedAttribute).setDerivedSchema(derivedSchema);
            ((AbstractDerAttr)derivedAttribute).setOwner((AbstractAttributable)attributable);
            attributable.addDerivedAttribute(derivedAttribute);
        }
        if (AttributableType.USER == attributableUtil.getType()) {
            for (AttributeTO vattrTO : attributableTO.getVirtualAttributes()) {
                Object uVirSchema = this.getVirtualSchema(vattrTO.getSchema(), attributableUtil.virtualSchemaClass());
                if (uVirSchema == null) continue;
                Object vattr = attributableUtil.newVirtualAttribute();
                ((AbstractVirAttr)vattr).setVirtualSchema(uVirSchema);
                ((AbstractVirAttr)vattr).setOwner((AbstractAttributable)attributable);
                attributable.addVirtualAttribute(vattr);
            }
        }
        this.fillVirtual(attributable, attributableTO.getVirtualAttributes(), attributableUtil);
        for (String resourceName : attributableTO.getResources()) {
            ExternalResource resource = this.getResource(resourceName);
            if (resource == null) continue;
            attributable.addResource(resource);
        }
        SyncopeClientException requiredValuesMissing = this.checkMandatory(attributableUtil, attributable);
        if (!requiredValuesMissing.isEmpty()) {
            compositeErrorException.addException(requiredValuesMissing);
        }
        if (compositeErrorException.hasExceptions()) {
            throw compositeErrorException;
        }
    }

    protected void fillTO(AbstractAttributableTO abstractAttributableTO, Collection<? extends AbstractAttr> attributes, Collection<? extends AbstractDerAttr> derivedAttributes, Collection<? extends AbstractVirAttr> virtualAttributes, Collection<ExternalResource> resources) {
        AttributeTO attributeTO;
        for (AbstractAttr abstractAttr : attributes) {
            attributeTO = new AttributeTO();
            attributeTO.setSchema(((AbstractSchema)abstractAttr.getSchema()).getName());
            attributeTO.setValues(abstractAttr.getValuesAsStrings());
            attributeTO.setReadonly(((AbstractSchema)abstractAttr.getSchema()).isReadonly());
            abstractAttributableTO.addAttribute(attributeTO);
        }
        for (AbstractDerAttr abstractDerAttr : derivedAttributes) {
            attributeTO = new AttributeTO();
            attributeTO.setSchema(((AbstractDerSchema)abstractDerAttr.getDerivedSchema()).getName());
            attributeTO.addValue(abstractDerAttr.getValue(attributes));
            attributeTO.setReadonly(true);
            abstractAttributableTO.addDerivedAttribute(attributeTO);
        }
        for (AbstractVirAttr abstractVirAttr : virtualAttributes) {
            attributeTO = new AttributeTO();
            attributeTO.setSchema(((AbstractVirSchema)abstractVirAttr.getVirtualSchema()).getName());
            attributeTO.setValues(abstractVirAttr.getValues());
            attributeTO.setReadonly(false);
            abstractAttributableTO.addVirtualAttribute(attributeTO);
        }
        for (ExternalResource externalResource : resources) {
            abstractAttributableTO.addResource(externalResource.getName());
        }
    }
}

