/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.util.List;
import javassist.NotFoundException;
import org.apache.syncope.client.to.WorkflowDefinitionTO;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.rest.controller.AbstractController;
import org.apache.syncope.core.workflow.UserWorkflowAdapter;
import org.apache.syncope.core.workflow.WorkflowException;
import org.apache.syncope.types.AuditElements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/workflow"})
public class WorkflowController
extends AbstractController {
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private UserWorkflowAdapter wfAdapter;

    @PreAuthorize(value="hasRole('WORKFLOW_DEF_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/definition"})
    @Transactional(readOnly=true)
    public WorkflowDefinitionTO getDefinition() throws WorkflowException {
        WorkflowDefinitionTO result = this.wfAdapter.getDefinition();
        this.auditManager.audit(AuditElements.Category.workflow, (Enum<?>)AuditElements.WorkflowSubCategory.getDefinition, AuditElements.Result.success, "Successfully got workflow definition");
        return result;
    }

    @PreAuthorize(value="hasRole('WORKFLOW_DEF_UPDATE')")
    @RequestMapping(method={RequestMethod.PUT}, value={"/definition"})
    public void updateDefinition(@RequestBody WorkflowDefinitionTO definition) throws NotFoundException, WorkflowException {
        this.wfAdapter.updateDefinition(definition);
        this.auditManager.audit(AuditElements.Category.workflow, (Enum<?>)AuditElements.WorkflowSubCategory.updateDefinition, AuditElements.Result.success, "Successfully updated workflow definition");
    }

    @PreAuthorize(value="hasRole('WORKFLOW_TASK_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/tasks"})
    public ModelAndView getDefinedTasks() throws WorkflowException {
        List<String> definedTasks = this.wfAdapter.getDefinedTasks();
        this.auditManager.audit(AuditElements.Category.workflow, (Enum<?>)AuditElements.WorkflowSubCategory.getDefinedTasks, AuditElements.Result.success, "Successfully got the list of defined workflow tasks: " + definedTasks.size());
        return new ModelAndView().addObject(definedTasks);
    }
}

