/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.util.ArrayList;
import java.util.List;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletResponse;
import org.apache.syncope.client.to.VirtualSchemaTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.persistence.beans.AbstractVirSchema;
import org.apache.syncope.core.persistence.dao.VirSchemaDAO;
import org.apache.syncope.core.rest.controller.AbstractController;
import org.apache.syncope.core.rest.data.VirtualSchemaDataBinder;
import org.apache.syncope.types.AuditElements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/virtualSchema"})
public class VirtualSchemaController
extends AbstractController {
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private VirSchemaDAO virtualSchemaDAO;
    @Autowired
    private VirtualSchemaDataBinder virtualSchemaDataBinder;

    @PreAuthorize(value="hasRole('SCHEMA_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/{kind}/create"})
    public VirtualSchemaTO create(HttpServletResponse response, @RequestBody VirtualSchemaTO virtualSchemaTO, @PathVariable(value="kind") String kind) throws SyncopeClientCompositeErrorException {
        AbstractVirSchema virtualSchema = this.virtualSchemaDAO.save(this.virtualSchemaDataBinder.create(virtualSchemaTO, (AbstractVirSchema)this.getAttributableUtil(kind).newVirtualSchema(), this.getAttributableUtil(kind).schemaClass()));
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.createVirtual, AuditElements.Result.success, "Successfully created virtual schema: " + kind + "/" + virtualSchema.getName());
        response.setStatus(201);
        return this.virtualSchemaDataBinder.getVirtualSchemaTO(virtualSchema);
    }

    @PreAuthorize(value="hasRole('SCHEMA_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/{kind}/delete/{schema}"})
    public VirtualSchemaTO delete(@PathVariable(value="kind") String kind, @PathVariable(value="schema") String virtualSchemaName) throws NotFoundException {
        Class reference = this.getAttributableUtil(kind).virtualSchemaClass();
        Object virtualSchema = this.virtualSchemaDAO.find(virtualSchemaName, reference);
        if (virtualSchema == null) {
            throw new NotFoundException("Virtual schema '" + virtualSchemaName + "'");
        }
        VirtualSchemaTO schemaToDelete = this.virtualSchemaDataBinder.getVirtualSchemaTO(virtualSchema);
        this.virtualSchemaDAO.delete(virtualSchemaName, this.getAttributableUtil(kind));
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.deleteVirtual, AuditElements.Result.success, "Successfully deleted virtual schema: " + kind + "/" + ((AbstractVirSchema)virtualSchema).getName());
        return schemaToDelete;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{kind}/list"})
    public List<VirtualSchemaTO> list(@PathVariable(value="kind") String kind) {
        Class reference = this.getAttributableUtil(kind).virtualSchemaClass();
        List virtualAttributeSchemas = this.virtualSchemaDAO.findAll(reference);
        ArrayList<VirtualSchemaTO> virtualSchemaTOs = new ArrayList<VirtualSchemaTO>(virtualAttributeSchemas.size());
        for (AbstractVirSchema virtualSchema : virtualAttributeSchemas) {
            virtualSchemaTOs.add(this.virtualSchemaDataBinder.getVirtualSchemaTO(virtualSchema));
        }
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.listVirtual, AuditElements.Result.success, "Successfully listed all virtual schemas: " + kind + "/" + virtualSchemaTOs.size());
        return virtualSchemaTOs;
    }

    @PreAuthorize(value="hasRole('SCHEMA_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/{kind}/read/{virtualSchema}"})
    public VirtualSchemaTO read(@PathVariable(value="kind") String kind, @PathVariable(value="virtualSchema") String virtualSchemaName) throws NotFoundException {
        Class reference = this.getAttributableUtil(kind).virtualSchemaClass();
        Object virtualSchema = this.virtualSchemaDAO.find(virtualSchemaName, reference);
        if (virtualSchema == null) {
            throw new NotFoundException("Virtual schema '" + virtualSchemaName + "'");
        }
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.readVirtual, AuditElements.Result.success, "Successfully read virtual schema: " + kind + "/" + ((AbstractVirSchema)virtualSchema).getName());
        return this.virtualSchemaDataBinder.getVirtualSchemaTO(virtualSchema);
    }

    @PreAuthorize(value="hasRole('SCHEMA_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/{kind}/update"})
    public VirtualSchemaTO update(@RequestBody VirtualSchemaTO virtualSchemaTO, @PathVariable(value="kind") String kind) throws SyncopeClientCompositeErrorException, NotFoundException {
        Class reference = this.getAttributableUtil(kind).virtualSchemaClass();
        Object virtualSchema = this.virtualSchemaDAO.find(virtualSchemaTO.getName(), reference);
        if (virtualSchema == null) {
            throw new NotFoundException("Virtual schema is null");
        }
        virtualSchema = this.virtualSchemaDataBinder.update(virtualSchemaTO, (AbstractVirSchema)virtualSchema, this.getAttributableUtil(kind).schemaClass());
        virtualSchema = this.virtualSchemaDAO.save(virtualSchema);
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.updateVirtual, AuditElements.Result.success, "Successfully updated virtual schema: " + kind + "/" + ((AbstractVirSchema)virtualSchema).getName());
        return this.virtualSchemaDataBinder.getVirtualSchemaTO(virtualSchema);
    }
}

