/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.util.ArrayList;
import java.util.List;
import javassist.NotFoundException;
import javax.persistence.RollbackException;
import org.apache.syncope.client.mod.UserMod;
import org.apache.syncope.client.to.UserRequestTO;
import org.apache.syncope.client.to.UserTO;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.persistence.beans.SyncopeConf;
import org.apache.syncope.core.persistence.beans.UserRequest;
import org.apache.syncope.core.persistence.dao.ConfDAO;
import org.apache.syncope.core.persistence.dao.UserRequestDAO;
import org.apache.syncope.core.rest.controller.UnauthorizedRoleException;
import org.apache.syncope.core.rest.data.UserRequestDataBinder;
import org.apache.syncope.types.AuditElements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/user/request"})
public class UserRequestController {
    private static final Logger LOG = LoggerFactory.getLogger(UserRequestController.class);
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private UserRequestDAO userRequestDAO;
    @Autowired
    private UserRequestDataBinder dataBinder;

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/read/self"})
    @Transactional(readOnly=true)
    public UserTO read() throws NotFoundException {
        UserTO userTO = this.dataBinder.getAuthUserTO();
        this.auditManager.audit(AuditElements.Category.userRequest, (Enum<?>)AuditElements.UserRequestSubCategory.read, AuditElements.Result.success, "Successfully read self data");
        return userTO;
    }

    private Boolean isCreateAllowedByConf() {
        SyncopeConf createRequestAllowed = this.confDAO.find("createRequest.allowed", "false");
        return Boolean.valueOf(createRequestAllowed.getValue());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/create/allowed"})
    @Transactional(readOnly=true)
    public ModelAndView isCreateAllowed() {
        this.auditManager.audit(AuditElements.Category.userRequest, (Enum<?>)AuditElements.UserRequestSubCategory.isCreateAllowed, AuditElements.Result.success, "Successfully checked whether self create is allowed");
        return new ModelAndView().addObject((Object)this.isCreateAllowedByConf());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/create"})
    public UserRequestTO create(@RequestBody UserTO userTO) throws UnauthorizedRoleException {
        if (!this.isCreateAllowedByConf().booleanValue()) {
            LOG.error("Create requests are not allowed");
            throw new UnauthorizedRoleException(-1L);
        }
        LOG.debug("Request user create called with {}", (Object)userTO);
        try {
            this.dataBinder.testCreate(userTO);
        }
        catch (RollbackException e) {
            LOG.debug("Testing create - ignore exception");
        }
        UserRequest request = new UserRequest();
        request.setUserTO(userTO);
        request = this.userRequestDAO.save(request);
        this.auditManager.audit(AuditElements.Category.userRequest, (Enum<?>)AuditElements.UserRequestSubCategory.create, AuditElements.Result.success, "Successfully created user request for " + request.getUserTO().getUsername());
        return this.dataBinder.getUserRequestTO(request);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.POST}, value={"/update"})
    public UserRequestTO update(@RequestBody UserMod userMod) throws NotFoundException, UnauthorizedRoleException {
        LOG.debug("Request user update called with {}", (Object)userMod);
        try {
            this.dataBinder.testUpdate(userMod);
        }
        catch (RollbackException e) {
            LOG.debug("Testing update - ignore exception");
        }
        UserRequest request = new UserRequest();
        request.setUserMod(userMod);
        request = this.userRequestDAO.save(request);
        this.auditManager.audit(AuditElements.Category.userRequest, (Enum<?>)AuditElements.UserRequestSubCategory.update, AuditElements.Result.success, "Successfully updated user request for " + request.getUserMod().getUsername());
        return this.dataBinder.getUserRequestTO(request);
    }

    @PreAuthorize(value="hasRole('USER_REQUEST_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/list"})
    @Transactional(readOnly=true)
    public List<UserRequestTO> list() {
        ArrayList<UserRequestTO> result = new ArrayList<UserRequestTO>();
        for (UserRequest request : this.userRequestDAO.findAll()) {
            result.add(this.dataBinder.getUserRequestTO(request));
        }
        this.auditManager.audit(AuditElements.Category.userRequest, (Enum<?>)AuditElements.UserRequestSubCategory.list, AuditElements.Result.success, "Successfully listed all user requests: " + result.size());
        return result;
    }

    @PreAuthorize(value="hasRole('USER_REQUEST_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/read/{requestId}"})
    @Transactional(readOnly=true)
    public UserRequestTO read(@PathVariable(value="requestId") Long requestId) throws NotFoundException {
        UserRequest request = this.userRequestDAO.find(requestId);
        if (request == null) {
            throw new NotFoundException("User request " + requestId);
        }
        this.auditManager.audit(AuditElements.Category.userRequest, (Enum<?>)AuditElements.UserRequestSubCategory.read, AuditElements.Result.success, "Successfully read user request for " + request.getUserTO().getUsername());
        return this.dataBinder.getUserRequestTO(request);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/delete/{requestId}"})
    public UserRequestTO delete(@PathVariable(value="requestId") Long userId) throws NotFoundException, UnauthorizedRoleException {
        LOG.debug("Request user delete called with {}", (Object)userId);
        try {
            this.dataBinder.testDelete(userId);
        }
        catch (RollbackException e) {
            LOG.debug("Testing delete - ignore exception");
        }
        UserRequest request = new UserRequest();
        request.setUserId(userId);
        request = this.userRequestDAO.save(request);
        this.auditManager.audit(AuditElements.Category.userRequest, (Enum<?>)AuditElements.UserRequestSubCategory.delete, AuditElements.Result.success, "Successfully deleted user request for user" + userId);
        return this.dataBinder.getUserRequestTO(request);
    }

    @PreAuthorize(value="hasRole('USER_REQUEST_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/deleteRequest/{requestId}"})
    public UserRequestTO deleteRequest(@PathVariable(value="requestId") Long requestId) throws NotFoundException {
        UserRequest request = this.userRequestDAO.find(requestId);
        if (request == null) {
            throw new NotFoundException("User request " + requestId);
        }
        UserRequestTO requestToDelete = this.dataBinder.getUserRequestTO(request);
        this.auditManager.audit(AuditElements.Category.userRequest, (Enum<?>)AuditElements.UserRequestSubCategory.delete, AuditElements.Result.success, "Successfully deleted user request for user" + request.getUserId());
        this.userRequestDAO.delete(requestId);
        return requestToDelete;
    }
}

