/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.apache.syncope.client.mod.UserMod;
import org.apache.syncope.client.search.NodeCond;
import org.apache.syncope.client.to.MembershipTO;
import org.apache.syncope.client.to.PropagationTO;
import org.apache.syncope.client.to.UserTO;
import org.apache.syncope.client.to.WorkflowFormTO;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.notification.NotificationManager;
import org.apache.syncope.core.persistence.beans.PropagationTask;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.persistence.dao.UserSearchDAO;
import org.apache.syncope.core.propagation.PropagationException;
import org.apache.syncope.core.propagation.PropagationHandler;
import org.apache.syncope.core.propagation.PropagationManager;
import org.apache.syncope.core.rest.controller.InvalidSearchConditionException;
import org.apache.syncope.core.rest.controller.UnauthorizedRoleException;
import org.apache.syncope.core.rest.data.UserDataBinder;
import org.apache.syncope.core.util.ConnObjectUtil;
import org.apache.syncope.core.util.EntitlementUtil;
import org.apache.syncope.core.workflow.UserWorkflowAdapter;
import org.apache.syncope.core.workflow.WorkflowException;
import org.apache.syncope.core.workflow.WorkflowResult;
import org.apache.syncope.types.AuditElements;
import org.apache.syncope.types.PropagationTaskExecStatus;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/user"})
public class UserController {
    private static final Logger LOG = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private UserSearchDAO searchDAO;
    @Autowired
    private UserDataBinder userDataBinder;
    @Autowired
    private UserWorkflowAdapter wfAdapter;
    @Autowired
    private PropagationManager propagationManager;
    @Autowired
    private NotificationManager notificationManager;
    @Autowired
    private ConnObjectUtil connObjectUtil;

    @PreAuthorize(value="hasRole('USER_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/verifyPassword/{username}"})
    @Transactional(readOnly=true)
    public ModelAndView verifyPassword(@PathVariable(value="username") String username, @RequestParam(value="password") String password) throws NotFoundException, UnauthorizedRoleException {
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.create, AuditElements.Result.success, "Verified password for: " + username);
        return new ModelAndView().addObject((Object)this.userDataBinder.verifyPassword(username, password));
    }

    @PreAuthorize(value="hasRole('USER_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/count"})
    @Transactional(readOnly=true, rollbackFor={Throwable.class})
    public ModelAndView count() {
        Set<Long> adminRoleIds = EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames());
        return new ModelAndView().addObject((Object)this.userDAO.count(adminRoleIds));
    }

    @PreAuthorize(value="hasRole('USER_READ')")
    @RequestMapping(method={RequestMethod.POST}, value={"/search/count"})
    @Transactional(readOnly=true, rollbackFor={Throwable.class})
    public ModelAndView searchCount(@RequestBody NodeCond searchCondition) throws InvalidSearchConditionException {
        if (!searchCondition.checkValidity()) {
            LOG.error("Invalid search condition: {}", (Object)searchCondition);
            throw new InvalidSearchConditionException();
        }
        Set<Long> adminRoleIds = EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames());
        return new ModelAndView().addObject((Object)this.searchDAO.count(adminRoleIds, searchCondition));
    }

    @PreAuthorize(value="hasRole('USER_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/list"})
    @Transactional(readOnly=true, rollbackFor={Throwable.class})
    public List<UserTO> list() {
        List<SyncopeUser> users = this.userDAO.findAll(EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames()));
        ArrayList<UserTO> userTOs = new ArrayList<UserTO>(users.size());
        for (SyncopeUser user : users) {
            userTOs.add(this.userDataBinder.getUserTO(user));
        }
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.list, AuditElements.Result.success, "Successfully listed all users: " + userTOs.size());
        return userTOs;
    }

    @PreAuthorize(value="hasRole('USER_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/list/{page}/{size}"})
    @Transactional(readOnly=true, rollbackFor={Throwable.class})
    public List<UserTO> list(@PathVariable(value="page") int page, @PathVariable(value="size") int size) {
        Set<Long> adminRoleIds = EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames());
        List<SyncopeUser> users = this.userDAO.findAll(adminRoleIds, page, size);
        ArrayList<UserTO> userTOs = new ArrayList<UserTO>(users.size());
        for (SyncopeUser user : users) {
            userTOs.add(this.userDataBinder.getUserTO(user));
        }
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.list, AuditElements.Result.success, "Successfully listed all users (page=" + page + ", size=" + size + "): " + userTOs.size());
        return userTOs;
    }

    @PreAuthorize(value="hasRole('USER_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/read/{userId}"})
    @Transactional(readOnly=true, rollbackFor={Throwable.class})
    public UserTO read(@PathVariable(value="userId") Long userId) throws NotFoundException, UnauthorizedRoleException {
        UserTO result = this.userDataBinder.getUserTO(userId);
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.read, AuditElements.Result.success, "Successfully read user: " + userId);
        return result;
    }

    @PreAuthorize(value="hasRole('USER_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/readByUsername/{username}"})
    @Transactional(readOnly=true, rollbackFor={Throwable.class})
    public UserTO read(@PathVariable String username) throws NotFoundException, UnauthorizedRoleException {
        UserTO result = this.userDataBinder.getUserTO(username);
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.read, AuditElements.Result.success, "Successfully read user: " + username);
        return result;
    }

    @PreAuthorize(value="hasRole('USER_READ')")
    @RequestMapping(method={RequestMethod.POST}, value={"/search"})
    @Transactional(readOnly=true, rollbackFor={Throwable.class})
    public List<UserTO> search(@RequestBody NodeCond searchCondition) throws InvalidSearchConditionException {
        LOG.debug("User search called with condition {}", (Object)searchCondition);
        if (!searchCondition.checkValidity()) {
            LOG.error("Invalid search condition: {}", (Object)searchCondition);
            throw new InvalidSearchConditionException();
        }
        List<SyncopeUser> matchingUsers = this.searchDAO.search(EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames()), searchCondition);
        ArrayList<UserTO> result = new ArrayList<UserTO>(matchingUsers.size());
        for (SyncopeUser user : matchingUsers) {
            result.add(this.userDataBinder.getUserTO(user));
        }
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.read, AuditElements.Result.success, "Successfully searched for users: " + result.size());
        return result;
    }

    @PreAuthorize(value="hasRole('USER_READ')")
    @RequestMapping(method={RequestMethod.POST}, value={"/search/{page}/{size}"})
    @Transactional(readOnly=true, rollbackFor={Throwable.class})
    public List<UserTO> search(@RequestBody NodeCond searchCondition, @PathVariable(value="page") int page, @PathVariable(value="size") int size) throws InvalidSearchConditionException {
        LOG.debug("User search called with condition {}", (Object)searchCondition);
        if (!searchCondition.checkValidity()) {
            LOG.error("Invalid search condition: {}", (Object)searchCondition);
            throw new InvalidSearchConditionException();
        }
        List<SyncopeUser> matchingUsers = this.searchDAO.search(EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames()), searchCondition, page, size);
        ArrayList<UserTO> result = new ArrayList<UserTO>(matchingUsers.size());
        for (SyncopeUser user : matchingUsers) {
            result.add(this.userDataBinder.getUserTO(user));
        }
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.read, AuditElements.Result.success, "Successfully searched for users (page=" + page + ", size=" + size + "): " + result.size());
        return result;
    }

    @PreAuthorize(value="hasRole('USER_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/create"})
    public UserTO create(HttpServletResponse response, @RequestBody UserTO userTO) throws PropagationException, UnauthorizedRoleException, WorkflowException, NotFoundException {
        LOG.debug("User create called with {}", (Object)userTO);
        HashSet<Long> requestRoleIds = new HashSet<Long>(userTO.getMemberships().size());
        for (MembershipTO membership : userTO.getMemberships()) {
            requestRoleIds.add(membership.getRoleId());
        }
        Set<Long> adminRoleIds = EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames());
        requestRoleIds.removeAll(adminRoleIds);
        if (!requestRoleIds.isEmpty()) {
            throw new UnauthorizedRoleException(requestRoleIds);
        }
        WorkflowResult<Map.Entry<Long, Boolean>> created = this.wfAdapter.create(userTO);
        List<PropagationTask> tasks = this.propagationManager.getCreateTaskIds(created, userTO.getPassword(), userTO.getVirtualAttributes());
        final ArrayList propagations = new ArrayList();
        this.propagationManager.execute(tasks, new PropagationHandler(){

            @Override
            public void handle(String resourceName, PropagationTaskExecStatus executionStatus, ConnectorObject before, ConnectorObject after) {
                PropagationTO propagation = new PropagationTO();
                propagation.setResourceName(resourceName);
                propagation.setStatus(executionStatus);
                if (before != null) {
                    propagation.setBefore(UserController.this.connObjectUtil.getConnObjectTO(before));
                }
                if (after != null) {
                    propagation.setAfter(UserController.this.connObjectUtil.getConnObjectTO(after));
                }
                propagations.add(propagation);
            }
        });
        this.notificationManager.createTasks(new WorkflowResult<Long>(created.getResult().getKey(), created.getPropByRes(), created.getPerformedTasks()));
        UserTO savedTO = this.userDataBinder.getUserTO(created.getResult().getKey());
        savedTO.setPropagationTOs(propagations);
        LOG.debug("About to return created user\n{}", (Object)savedTO);
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.create, AuditElements.Result.success, "Successfully created user: " + savedTO.getUsername());
        response.setStatus(201);
        return savedTO;
    }

    @PreAuthorize(value="hasRole('USER_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/update"})
    public UserTO update(@RequestBody UserMod userMod) throws NotFoundException, PropagationException, UnauthorizedRoleException, WorkflowException {
        LOG.debug("User update called with {}", (Object)userMod);
        WorkflowResult<Map.Entry<Long, Boolean>> updated = this.wfAdapter.update(userMod);
        List<PropagationTask> tasks = this.propagationManager.getUpdateTaskIds(updated, userMod.getPassword(), userMod.getVirtualAttributesToBeRemoved(), userMod.getVirtualAttributesToBeUpdated(), null);
        final ArrayList propagations = new ArrayList();
        this.propagationManager.execute(tasks, new PropagationHandler(){

            @Override
            public void handle(String resourceName, PropagationTaskExecStatus executionStatus, ConnectorObject before, ConnectorObject after) {
                PropagationTO propagation = new PropagationTO();
                propagation.setResourceName(resourceName);
                propagation.setStatus(executionStatus);
                if (before != null) {
                    propagation.setBefore(UserController.this.connObjectUtil.getConnObjectTO(before));
                }
                if (after != null) {
                    propagation.setAfter(UserController.this.connObjectUtil.getConnObjectTO(after));
                }
                propagations.add(propagation);
            }
        });
        this.notificationManager.createTasks(new WorkflowResult<Long>(updated.getResult().getKey(), updated.getPropByRes(), updated.getPerformedTasks()));
        UserTO updatedTO = this.userDataBinder.getUserTO(updated.getResult().getKey());
        updatedTO.setPropagationTOs(propagations);
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.update, AuditElements.Result.success, "Successfully updated user: " + updatedTO.getUsername());
        LOG.debug("About to return updated user\n{}", (Object)updatedTO);
        return updatedTO;
    }

    @PreAuthorize(value="hasRole('USER_UPDATE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/activate/{userId}"})
    @Transactional(rollbackFor={Throwable.class})
    public UserTO activate(@PathVariable(value="userId") Long userId, @RequestParam(required=true) String token, @RequestParam(required=false) Set<String> resourceNames, @RequestParam(required=false, defaultValue="true") Boolean performLocally, @RequestParam(required=false, defaultValue="true") Boolean performRemotely) throws WorkflowException, NotFoundException, UnauthorizedRoleException, PropagationException {
        LOG.debug("About to activate " + userId);
        SyncopeUser user = this.userDAO.find(userId);
        if (user == null) {
            throw new NotFoundException("User " + userId);
        }
        return this.setStatus(user, token, resourceNames, performLocally, performRemotely, true, "activate");
    }

    @PreAuthorize(value="hasRole('USER_UPDATE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/activateByUsername/{username}"})
    @Transactional(rollbackFor={Throwable.class})
    public UserTO activate(@PathVariable(value="username") String username, @RequestParam(required=true) String token, @RequestParam(required=false) Set<String> resourceNames, @RequestParam(required=false, defaultValue="true") Boolean performLocally, @RequestParam(required=false, defaultValue="true") Boolean performRemotely) throws WorkflowException, NotFoundException, UnauthorizedRoleException, PropagationException {
        LOG.debug("About to activate " + username);
        SyncopeUser user = this.userDAO.find(username);
        if (user == null) {
            throw new NotFoundException("User " + username);
        }
        return this.setStatus(user, token, resourceNames, performLocally, performRemotely, true, "activate");
    }

    @PreAuthorize(value="hasRole('USER_UPDATE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/suspendByUsername/{username}"})
    @Transactional(rollbackFor={Throwable.class})
    public UserTO suspend(@PathVariable(value="username") String username, @RequestParam(required=false) Set<String> resourceNames, @RequestParam(required=false, defaultValue="true") Boolean performLocally, @RequestParam(required=false, defaultValue="true") Boolean performRemotely) throws NotFoundException, WorkflowException, UnauthorizedRoleException, PropagationException {
        LOG.debug("About to suspend " + username);
        SyncopeUser user = this.userDAO.find(username);
        if (user == null) {
            throw new NotFoundException("User " + username);
        }
        return this.setStatus(user, null, resourceNames, performLocally, performRemotely, false, "suspend");
    }

    @PreAuthorize(value="hasRole('USER_UPDATE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/suspend/{userId}"})
    @Transactional(rollbackFor={Throwable.class})
    public UserTO suspend(@PathVariable(value="userId") Long userId, @RequestParam(required=false) Set<String> resourceNames, @RequestParam(required=false, defaultValue="true") Boolean performLocally, @RequestParam(required=false, defaultValue="true") Boolean performRemotely) throws NotFoundException, WorkflowException, UnauthorizedRoleException, PropagationException {
        LOG.debug("About to suspend " + userId);
        SyncopeUser user = this.userDAO.find(userId);
        if (user == null) {
            throw new NotFoundException("User " + userId);
        }
        return this.setStatus(user, null, resourceNames, performLocally, performRemotely, false, "suspend");
    }

    @PreAuthorize(value="hasRole('USER_UPDATE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/reactivate/{userId}"})
    @Transactional(rollbackFor={Throwable.class})
    public UserTO reactivate(@PathVariable(value="userId") Long userId, @RequestParam(required=false) Set<String> resourceNames, @RequestParam(required=false, defaultValue="true") Boolean performLocally, @RequestParam(required=false, defaultValue="true") Boolean performRemotely) throws NotFoundException, WorkflowException, UnauthorizedRoleException, PropagationException {
        LOG.debug("About to reactivate " + userId);
        SyncopeUser user = this.userDAO.find(userId);
        if (user == null) {
            throw new NotFoundException("User " + userId);
        }
        return this.setStatus(user, null, resourceNames, performLocally, performRemotely, true, "reactivate");
    }

    @PreAuthorize(value="hasRole('USER_UPDATE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/reactivateByUsername/{username}"})
    @Transactional(rollbackFor={Throwable.class})
    public UserTO reactivate(@PathVariable(value="username") String username, @RequestParam(required=false) Set<String> resourceNames, @RequestParam(required=false, defaultValue="true") Boolean performLocally, @RequestParam(required=false, defaultValue="true") Boolean performRemotely) throws NotFoundException, WorkflowException, UnauthorizedRoleException, PropagationException {
        LOG.debug("About to reactivate " + username);
        SyncopeUser user = this.userDAO.find(username);
        if (user == null) {
            throw new NotFoundException("User " + username);
        }
        return this.setStatus(user, null, resourceNames, performLocally, performRemotely, true, "reactivate");
    }

    @PreAuthorize(value="hasRole('USER_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/delete/{userId}"})
    public UserTO delete(@PathVariable(value="userId") Long userId) throws NotFoundException, WorkflowException, PropagationException, UnauthorizedRoleException {
        LOG.debug("User delete called with {}", (Object)userId);
        return this.deleteByUserId(userId);
    }

    @PreAuthorize(value="hasRole('USER_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/deleteByUsername/{username}"})
    public UserTO delete(@PathVariable String username) throws NotFoundException, WorkflowException, PropagationException, UnauthorizedRoleException {
        LOG.debug("User delete called with {}", (Object)username);
        UserTO result = this.userDataBinder.getUserTO(username);
        long userId = result.getId();
        return this.deleteByUserId(userId);
    }

    @PreAuthorize(value="hasRole('USER_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/execute/workflow/{taskId}"})
    public UserTO executeWorkflow(@RequestBody UserTO userTO, @PathVariable(value="taskId") String taskId) throws WorkflowException, NotFoundException, UnauthorizedRoleException, PropagationException {
        LOG.debug("About to execute {} on {}", (Object)taskId, (Object)userTO.getId());
        WorkflowResult<Long> updated = this.wfAdapter.execute(userTO, taskId);
        List<PropagationTask> tasks = this.propagationManager.getUpdateTaskIds(new WorkflowResult<DefaultMapEntry>(new DefaultMapEntry((Object)updated.getResult(), null), updated.getPropByRes(), updated.getPerformedTasks()));
        this.propagationManager.execute(tasks);
        this.notificationManager.createTasks(updated);
        UserTO savedTO = this.userDataBinder.getUserTO(updated.getResult());
        LOG.debug("About to return updated user\n{}", (Object)savedTO);
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.executeWorkflow, AuditElements.Result.success, "Successfully executed workflow action " + taskId + " on user: " + userTO.getUsername());
        return savedTO;
    }

    @PreAuthorize(value="hasRole('WORKFLOW_FORM_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/workflow/form/list"})
    @Transactional(readOnly=true, rollbackFor={Throwable.class})
    public List<WorkflowFormTO> getForms() {
        List<WorkflowFormTO> forms = this.wfAdapter.getForms();
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.getForms, AuditElements.Result.success, "Successfully list workflow forms: " + forms.size());
        return forms;
    }

    @PreAuthorize(value="hasRole('WORKFLOW_FORM_READ') and hasRole('USER_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/workflow/form/{userId}"})
    @Transactional(rollbackFor={Throwable.class})
    public WorkflowFormTO getFormForUser(@PathVariable(value="userId") Long userId) throws UnauthorizedRoleException, NotFoundException, WorkflowException {
        SyncopeUser user = this.userDataBinder.getUserFromId(userId);
        WorkflowFormTO result = this.wfAdapter.getForm(user.getWorkflowId());
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.getFormForUser, AuditElements.Result.success, "Successfully read workflow form for user: " + user.getUsername());
        return result;
    }

    @PreAuthorize(value="hasRole('WORKFLOW_FORM_CLAIM')")
    @RequestMapping(method={RequestMethod.GET}, value={"/workflow/form/claim/{taskId}"})
    @Transactional(rollbackFor={Throwable.class})
    public WorkflowFormTO claimForm(@PathVariable(value="taskId") String taskId) throws NotFoundException, WorkflowException {
        WorkflowFormTO result = this.wfAdapter.claimForm(taskId, SecurityContextHolder.getContext().getAuthentication().getName());
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.claimForm, AuditElements.Result.success, "Successfully claimed workflow form: " + taskId);
        return result;
    }

    @PreAuthorize(value="hasRole('WORKFLOW_FORM_SUBMIT')")
    @RequestMapping(method={RequestMethod.POST}, value={"/workflow/form/submit"})
    @Transactional(rollbackFor={Throwable.class})
    public UserTO submitForm(@RequestBody WorkflowFormTO form) throws NotFoundException, WorkflowException, PropagationException, UnauthorizedRoleException {
        LOG.debug("About to process form {}", (Object)form);
        WorkflowResult<Map.Entry<Long, String>> updated = this.wfAdapter.submitForm(form, SecurityContextHolder.getContext().getAuthentication().getName());
        List<PropagationTask> tasks = this.propagationManager.getUpdateTaskIds(new WorkflowResult<DefaultMapEntry>(new DefaultMapEntry((Object)updated.getResult().getKey(), (Object)Boolean.TRUE), updated.getPropByRes(), updated.getPerformedTasks()), updated.getResult().getValue(), null, null);
        this.propagationManager.execute(tasks);
        UserTO savedTO = this.userDataBinder.getUserTO(updated.getResult().getKey());
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.submitForm, AuditElements.Result.success, "Successfully submitted workflow form for user: " + savedTO.getUsername());
        LOG.debug("About to return user after form processing\n{}", (Object)savedTO);
        return savedTO;
    }

    private UserTO setStatus(SyncopeUser user, String token, Set<String> resourceNames, boolean performLocally, boolean performRemotely, boolean status, String task) throws NotFoundException, WorkflowException, UnauthorizedRoleException, PropagationException {
        LOG.debug("About to set status of {}" + user);
        WorkflowResult<Long> updated = performLocally ? ("suspend".equals(task) ? this.wfAdapter.suspend(user.getId()) : ("reactivate".equals(task) ? this.wfAdapter.reactivate(user.getId()) : this.wfAdapter.activate(user.getId(), token))) : new WorkflowResult<Long>(user.getId(), null, task);
        HashSet<String> resources = new HashSet<String>();
        if (performRemotely) {
            if (resourceNames != null) {
                resources.addAll(user.getResourceNames());
                resources.removeAll(resourceNames);
            }
        } else {
            resources.addAll(user.getResourceNames());
        }
        List<PropagationTask> tasks = this.propagationManager.getUpdateTaskIds(user, status, resources);
        this.propagationManager.execute(tasks);
        this.notificationManager.createTasks(updated);
        UserTO savedTO = this.userDataBinder.getUserTO(updated.getResult());
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.setStatus, AuditElements.Result.success, "Successfully changed status to " + savedTO.getStatus() + " for user: " + savedTO.getUsername());
        LOG.debug("About to return updated user\n{}", (Object)savedTO);
        return savedTO;
    }

    private UserTO deleteByUserId(Long userId) throws NotFoundException, WorkflowException, PropagationException, UnauthorizedRoleException {
        this.notificationManager.createTasks(new WorkflowResult<Long>(userId, null, "delete"));
        List<PropagationTask> tasks = this.propagationManager.getDeleteTaskIds(userId);
        final UserTO userTO = new UserTO();
        userTO.setId(userId.longValue());
        this.propagationManager.execute(tasks, new PropagationHandler(){

            @Override
            public void handle(String resourceName, PropagationTaskExecStatus executionStatus, ConnectorObject before, ConnectorObject after) {
                PropagationTO propagation = new PropagationTO();
                propagation.setResourceName(resourceName);
                propagation.setStatus(executionStatus);
                if (before != null) {
                    propagation.setBefore(UserController.this.connObjectUtil.getConnObjectTO(before));
                }
                if (after != null) {
                    propagation.setAfter(UserController.this.connObjectUtil.getConnObjectTO(after));
                }
                userTO.addPropagationTO(propagation);
            }
        });
        this.wfAdapter.delete(userId);
        this.auditManager.audit(AuditElements.Category.user, (Enum<?>)AuditElements.UserSubCategory.delete, AuditElements.Result.success, "Successfully deleted user: " + userTO.getUsername());
        LOG.debug("User successfully deleted: {}", (Object)userId);
        return userTO;
    }
}

