/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletResponse;
import org.apache.syncope.client.to.SchedTaskTO;
import org.apache.syncope.client.to.SyncTaskTO;
import org.apache.syncope.client.to.TaskExecTO;
import org.apache.syncope.client.to.TaskTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.client.validation.SyncopeClientException;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.init.ImplementationClassNamesLoader;
import org.apache.syncope.core.init.JobInstanceLoader;
import org.apache.syncope.core.notification.NotificationManager;
import org.apache.syncope.core.persistence.beans.NotificationTask;
import org.apache.syncope.core.persistence.beans.PropagationTask;
import org.apache.syncope.core.persistence.beans.SchedTask;
import org.apache.syncope.core.persistence.beans.Task;
import org.apache.syncope.core.persistence.beans.TaskExec;
import org.apache.syncope.core.persistence.dao.TaskDAO;
import org.apache.syncope.core.persistence.dao.TaskExecDAO;
import org.apache.syncope.core.propagation.PropagationManager;
import org.apache.syncope.core.rest.controller.AbstractController;
import org.apache.syncope.core.rest.data.TaskDataBinder;
import org.apache.syncope.core.util.TaskUtil;
import org.apache.syncope.types.AuditElements;
import org.apache.syncope.types.PropagationMode;
import org.apache.syncope.types.PropagationTaskExecStatus;
import org.apache.syncope.types.SyncopeClientExceptionType;
import org.quartz.JobDataMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/task"})
public class TaskController
extends AbstractController {
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private TaskExecDAO taskExecDAO;
    @Autowired
    private TaskDataBinder binder;
    @Autowired
    private PropagationManager propagationManager;
    @Autowired
    private NotificationManager notificationManager;
    @Autowired
    private JobInstanceLoader jobInstanceLoader;
    @Autowired
    private SchedulerFactoryBean scheduler;
    @Autowired
    private ImplementationClassNamesLoader classNamesLoader;

    @PreAuthorize(value="hasRole('TASK_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/create/sync"})
    public TaskTO createSyncTask(HttpServletResponse response, @RequestBody SyncTaskTO taskTO) throws NotFoundException {
        return this.createSchedTask(response, (SchedTaskTO)taskTO);
    }

    @PreAuthorize(value="hasRole('TASK_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/create/sched"})
    public TaskTO createSchedTask(HttpServletResponse response, @RequestBody SchedTaskTO taskTO) throws NotFoundException {
        LOG.debug("Creating task " + taskTO);
        TaskUtil taskUtil = this.getTaskUtil((TaskTO)taskTO);
        SchedTask task = this.binder.createSchedTask(taskTO, taskUtil);
        task = this.taskDAO.save(task);
        try {
            this.jobInstanceLoader.registerJob(task, task.getJobClassName(), task.getCronExpression());
        }
        catch (Exception e) {
            LOG.error("While registering quartz job for task " + task.getId(), (Throwable)e);
            SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
            SyncopeClientException sce = new SyncopeClientException(SyncopeClientExceptionType.Scheduling);
            sce.addElement(e.getMessage());
            scce.addException(sce);
            throw scce;
        }
        this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.create, AuditElements.Result.success, "Successfully created task: " + task.getId() + "/" + (Object)((Object)taskUtil));
        response.setStatus(201);
        return this.binder.getTaskTO(task, taskUtil);
    }

    @PreAuthorize(value="hasRole('TASK_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/update/sync"})
    public TaskTO updateSync(@RequestBody SyncTaskTO taskTO) throws NotFoundException {
        return this.updateSched((SchedTaskTO)taskTO);
    }

    @PreAuthorize(value="hasRole('TASK_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/update/sched"})
    public TaskTO updateSched(@RequestBody SchedTaskTO taskTO) throws NotFoundException {
        LOG.debug("Task update called with parameter {}", (Object)taskTO);
        SchedTask task = (SchedTask)this.taskDAO.find(taskTO.getId());
        if (task == null) {
            throw new NotFoundException("Task " + String.valueOf(taskTO.getId()));
        }
        TaskUtil taskUtil = this.getTaskUtil(task);
        SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
        this.binder.updateSchedTask(task, taskTO, taskUtil);
        task = this.taskDAO.save(task);
        try {
            this.jobInstanceLoader.registerJob(task, task.getJobClassName(), task.getCronExpression());
        }
        catch (Exception e) {
            LOG.error("While registering quartz job for task " + task.getId(), (Throwable)e);
            SyncopeClientException sce = new SyncopeClientException(SyncopeClientExceptionType.Scheduling);
            sce.addElement(e.getMessage());
            scce.addException(sce);
            throw scce;
        }
        this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.update, AuditElements.Result.success, "Successfully udpated task: " + task.getId() + "/" + (Object)((Object)taskUtil));
        return this.binder.getTaskTO(task, taskUtil);
    }

    @PreAuthorize(value="hasRole('TASK_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/{kind}/count"})
    public ModelAndView count(@PathVariable(value="kind") String kind) {
        return new ModelAndView().addObject((Object)this.taskDAO.count(this.getTaskUtil(kind).taskClass()));
    }

    @PreAuthorize(value="hasRole('TASK_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/{kind}/list"})
    public List<TaskTO> list(@PathVariable(value="kind") String kind) {
        TaskUtil taskUtil = this.getTaskUtil(kind);
        List tasks = this.taskDAO.findAll(taskUtil.taskClass());
        ArrayList<TaskTO> taskTOs = new ArrayList<TaskTO>(tasks.size());
        for (Task task : tasks) {
            taskTOs.add(this.binder.getTaskTO(task, taskUtil));
        }
        this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.list, AuditElements.Result.success, "Successfully listed all tasks: " + taskTOs.size() + "/" + (Object)((Object)taskUtil));
        return taskTOs;
    }

    @PreAuthorize(value="hasRole('TASK_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/{kind}/list/{page}/{size}"})
    public List<TaskTO> list(@PathVariable(value="kind") String kind, @PathVariable(value="page") int page, @PathVariable(value="size") int size) {
        TaskUtil taskUtil = this.getTaskUtil(kind);
        List tasks = this.taskDAO.findAll(page, size, taskUtil.taskClass());
        ArrayList<TaskTO> taskTOs = new ArrayList<TaskTO>(tasks.size());
        for (Task task : tasks) {
            taskTOs.add(this.binder.getTaskTO(task, taskUtil));
        }
        this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.list, AuditElements.Result.success, "Successfully listed all tasks (page=" + page + ", size=" + size + "): " + taskTOs.size() + "/" + (Object)((Object)taskUtil));
        return taskTOs;
    }

    @PreAuthorize(value="hasRole('TASK_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/{kind}/execution/list"})
    public List<TaskExecTO> listExecutions(@PathVariable(value="kind") String kind) {
        List<TaskExec> executions = this.taskExecDAO.findAll(this.getTaskUtil(kind).taskClass());
        ArrayList<TaskExecTO> executionTOs = new ArrayList<TaskExecTO>(executions.size());
        for (TaskExec execution : executions) {
            executionTOs.add(this.binder.getTaskExecTO(execution));
        }
        this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.listExecutions, AuditElements.Result.success, "Successfully listed all task executions: " + executionTOs.size() + "/" + kind);
        return executionTOs;
    }

    @PreAuthorize(value="hasRole('TASK_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/jobClasses"})
    public ModelAndView getJobClasses() {
        Set<String> jobClasses = this.classNamesLoader.getClassNames(ImplementationClassNamesLoader.Type.JOB);
        this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.getJobClasses, AuditElements.Result.success, "Successfully listed all Job classes: " + jobClasses.size());
        return new ModelAndView().addObject(jobClasses);
    }

    @PreAuthorize(value="hasRole('TASK_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/jobActionsClasses"})
    public ModelAndView getJobActionClasses() {
        Set<String> jobActionsClasses = this.classNamesLoader.getClassNames(ImplementationClassNamesLoader.Type.JOB_ACTIONS);
        this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.getJobActionClasses, AuditElements.Result.success, "Successfully listed all SyncJobActions classes: " + jobActionsClasses.size());
        return new ModelAndView().addObject(jobActionsClasses);
    }

    @PreAuthorize(value="hasRole('TASK_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/read/{taskId}"})
    public TaskTO read(@PathVariable(value="taskId") Long taskId) throws NotFoundException {
        Object task = this.taskDAO.find(taskId);
        if (task == null) {
            throw new NotFoundException("Task " + taskId);
        }
        TaskUtil taskUtil = this.getTaskUtil((Task)task);
        this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.read, AuditElements.Result.success, "Successfully read task: " + ((Task)task).getId() + "/" + (Object)((Object)taskUtil));
        return this.binder.getTaskTO((Task)task, taskUtil);
    }

    @PreAuthorize(value="hasRole('TASK_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/execution/read/{executionId}"})
    public TaskExecTO readExecution(@PathVariable(value="executionId") Long executionId) throws NotFoundException {
        TaskExec taskExec = this.taskExecDAO.find(executionId);
        if (taskExec == null) {
            throw new NotFoundException("Task execution " + executionId);
        }
        this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.readExecution, AuditElements.Result.success, "Successfully read task execution: " + taskExec.getId());
        return this.binder.getTaskExecTO(taskExec);
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/execute/{taskId}"})
    public TaskExecTO execute(@PathVariable(value="taskId") Long taskId, @RequestParam(value="dryRun", defaultValue="false") boolean dryRun) throws NotFoundException {
        Object task = this.taskDAO.find(taskId);
        if (task == null) {
            throw new NotFoundException("Task " + taskId);
        }
        TaskUtil taskUtil = this.getTaskUtil((Task)task);
        TaskExecTO result = null;
        LOG.debug("Execution started for {}", task);
        switch (taskUtil) {
            case PROPAGATION: {
                TaskExec propExec = this.propagationManager.execute((PropagationTask)task);
                result = this.binder.getTaskExecTO(propExec);
                break;
            }
            case NOTIFICATION: {
                TaskExec notExec = this.notificationManager.execute((NotificationTask)task);
                result = this.binder.getTaskExecTO(notExec);
                break;
            }
            case SCHED: 
            case SYNC: {
                try {
                    this.jobInstanceLoader.registerJob((Task)task, ((SchedTask)task).getJobClassName(), ((SchedTask)task).getCronExpression());
                    JobDataMap map = new JobDataMap();
                    map.put("dryRun", dryRun);
                    this.scheduler.getScheduler().triggerJob(JobInstanceLoader.getJobName(task), "DEFAULT", map);
                }
                catch (Exception e) {
                    LOG.error("While executing task {}", task, (Object)e);
                    this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.execute, AuditElements.Result.failure, "Could not start execution for task: " + ((Task)task).getId() + "/" + (Object)((Object)taskUtil), e);
                    SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
                    SyncopeClientException sce = new SyncopeClientException(SyncopeClientExceptionType.Scheduling);
                    sce.addElement(e.getMessage());
                    scce.addException(sce);
                    throw scce;
                }
                result = new TaskExecTO();
                result.setTask(taskId.longValue());
                result.setStartDate(new Date());
                result.setStatus("JOB_FIRED");
                result.setMessage("Job fired; waiting for results...");
                break;
            }
        }
        LOG.debug("Execution finished for {}, {}", task, result);
        this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.execute, AuditElements.Result.success, "Successfully started execution for task: " + ((Task)task).getId() + "/" + (Object)((Object)taskUtil));
        return result;
    }

    @PreAuthorize(value="hasRole('TASK_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/execution/report/{executionId}"})
    public TaskExecTO report(@PathVariable(value="executionId") Long executionId, @RequestParam(value="executionStatus") PropagationTaskExecStatus status, @RequestParam(value="message") String message) throws NotFoundException, SyncopeClientCompositeErrorException {
        TaskExec exec = this.taskExecDAO.find(executionId);
        if (exec == null) {
            throw new NotFoundException("Task execution " + executionId);
        }
        SyncopeClientException sce = new SyncopeClientException(SyncopeClientExceptionType.InvalidPropagationTaskExecReport);
        TaskUtil taskUtil = this.getTaskUtil(exec.getTask());
        if (TaskUtil.PROPAGATION == taskUtil) {
            PropagationTask task = (PropagationTask)exec.getTask();
            if (task.getPropagationMode() != PropagationMode.TWO_PHASES) {
                sce.addElement("Propagation mode: " + task.getPropagationMode());
            }
        } else {
            sce.addElement("Task type: " + (Object)((Object)taskUtil));
        }
        switch (status) {
            case SUCCESS: 
            case FAILURE: {
                break;
            }
            case CREATED: 
            case SUBMITTED: 
            case UNSUBMITTED: {
                sce.addElement("Execution status to be set: " + status);
                break;
            }
        }
        if (!sce.isEmpty()) {
            SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
            scce.addException(sce);
            this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.report, AuditElements.Result.failure, "Could not reported execution status: " + exec.getId() + "/" + (Object)((Object)taskUtil), (Throwable)scce);
            throw scce;
        }
        exec.setStatus(status.toString());
        exec.setMessage(message);
        exec = this.taskExecDAO.save(exec);
        this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.report, AuditElements.Result.success, "Successfully reported execution status: " + exec.getId() + "/" + (Object)((Object)taskUtil));
        return this.binder.getTaskExecTO(exec);
    }

    @PreAuthorize(value="hasRole('TASK_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/delete/{taskId}"})
    public TaskTO delete(@PathVariable(value="taskId") Long taskId) throws NotFoundException, SyncopeClientCompositeErrorException {
        Object task = this.taskDAO.find(taskId);
        if (task == null) {
            throw new NotFoundException("Task " + taskId);
        }
        TaskUtil taskUtil = this.getTaskUtil((Task)task);
        TaskTO taskToDelete = this.binder.getTaskTO((Task)task, taskUtil);
        if (TaskUtil.SCHED == taskUtil || TaskUtil.SYNC == taskUtil) {
            this.jobInstanceLoader.unregisterJob((Task)task);
        }
        this.taskDAO.delete(task);
        this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.delete, AuditElements.Result.success, "Successfully deleted task: " + ((Task)task).getId() + "/" + (Object)((Object)taskUtil));
        return taskToDelete;
    }

    @PreAuthorize(value="hasRole('TASK_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/execution/delete/{executionId}"})
    public TaskExecTO deleteExecution(@PathVariable(value="executionId") Long executionId) throws NotFoundException, SyncopeClientCompositeErrorException {
        TaskExec taskExec = this.taskExecDAO.find(executionId);
        if (taskExec == null) {
            throw new NotFoundException("Task execution " + executionId);
        }
        TaskExecTO taskExecutionToDelete = this.binder.getTaskExecTO(taskExec);
        this.taskExecDAO.delete(taskExec);
        this.auditManager.audit(AuditElements.Category.task, (Enum<?>)AuditElements.TaskSubCategory.deleteExecution, AuditElements.Result.success, "Successfully deleted task execution: " + taskExec.getId());
        return taskExecutionToDelete;
    }
}

