/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.util.ArrayList;
import java.util.List;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletResponse;
import org.apache.syncope.client.to.SchemaTO;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.dao.SchemaDAO;
import org.apache.syncope.core.rest.controller.AbstractController;
import org.apache.syncope.core.rest.data.SchemaDataBinder;
import org.apache.syncope.core.util.AttributableUtil;
import org.apache.syncope.types.AuditElements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/schema"})
public class SchemaController
extends AbstractController {
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private SchemaDAO schemaDAO;
    @Autowired
    private SchemaDataBinder schemaDataBinder;

    @PreAuthorize(value="hasRole('SCHEMA_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/{kind}/create"})
    public SchemaTO create(HttpServletResponse response, @RequestBody SchemaTO schemaTO, @PathVariable(value="kind") String kind) {
        Object schema = this.getAttributableUtil(kind).newSchema();
        this.schemaDataBinder.create(schemaTO, (AbstractSchema)schema);
        schema = this.schemaDAO.save(schema);
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.create, AuditElements.Result.success, "Successfully created schema: " + kind + "/" + ((AbstractSchema)schema).getName());
        response.setStatus(201);
        return this.schemaDataBinder.getSchemaTO(schema, this.getAttributableUtil(kind));
    }

    @PreAuthorize(value="hasRole('SCHEMA_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/{kind}/delete/{schema}"})
    public SchemaTO delete(@PathVariable(value="kind") String kind, @PathVariable(value="schema") String schemaName) throws NotFoundException {
        Class reference = this.getAttributableUtil(kind).schemaClass();
        Object schema = this.schemaDAO.find(schemaName, reference);
        if (schema == null) {
            throw new NotFoundException("Schema '" + schemaName + "'");
        }
        SchemaTO schemaToDelete = this.schemaDataBinder.getSchemaTO(schema, this.getAttributableUtil(kind));
        this.schemaDAO.delete(schemaName, this.getAttributableUtil(kind));
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.delete, AuditElements.Result.success, "Successfully deleted schema: " + kind + "/" + ((AbstractSchema)schema).getName());
        return schemaToDelete;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{kind}/list"})
    public List<SchemaTO> list(@PathVariable(value="kind") String kind) {
        AttributableUtil attributableUtil = this.getAttributableUtil(kind);
        List schemas = this.schemaDAO.findAll(attributableUtil.schemaClass());
        ArrayList<SchemaTO> schemaTOs = new ArrayList<SchemaTO>(schemas.size());
        for (AbstractSchema schema : schemas) {
            schemaTOs.add(this.schemaDataBinder.getSchemaTO(schema, attributableUtil));
        }
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.list, AuditElements.Result.success, "Successfully listed all schemas: " + kind + "/" + schemaTOs.size());
        return schemaTOs;
    }

    @PreAuthorize(value="hasRole('SCHEMA_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/{kind}/read/{schema}"})
    public SchemaTO read(@PathVariable(value="kind") String kind, @PathVariable(value="schema") String schemaName) throws NotFoundException {
        AttributableUtil attributableUtil = this.getAttributableUtil(kind);
        Object schema = this.schemaDAO.find(schemaName, attributableUtil.schemaClass());
        if (schema == null) {
            throw new NotFoundException("Schema '" + schemaName + "'");
        }
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.read, AuditElements.Result.success, "Successfully read schema: " + kind + "/" + ((AbstractSchema)schema).getName());
        return this.schemaDataBinder.getSchemaTO(schema, attributableUtil);
    }

    @PreAuthorize(value="hasRole('SCHEMA_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/{kind}/update"})
    public SchemaTO update(@RequestBody SchemaTO schemaTO, @PathVariable(value="kind") String kind) throws NotFoundException {
        AttributableUtil attributableUtil = this.getAttributableUtil(kind);
        Object schema = this.schemaDAO.find(schemaTO.getName(), attributableUtil.schemaClass());
        if (schema == null) {
            throw new NotFoundException("Schema '" + schemaTO.getName() + "'");
        }
        this.schemaDataBinder.update(schemaTO, (AbstractSchema)schema, attributableUtil);
        schema = this.schemaDAO.save(schema);
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.update, AuditElements.Result.success, "Successfully updated schema: " + kind + "/" + ((AbstractSchema)schema).getName());
        return this.schemaDataBinder.getSchemaTO(schema, attributableUtil);
    }
}

