/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletResponse;
import org.apache.syncope.client.mod.RoleMod;
import org.apache.syncope.client.to.RoleTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.persistence.beans.role.SyncopeRole;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.dao.RoleDAO;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.rest.controller.AbstractController;
import org.apache.syncope.core.rest.controller.UnauthorizedRoleException;
import org.apache.syncope.core.rest.data.RoleDataBinder;
import org.apache.syncope.core.util.EntitlementUtil;
import org.apache.syncope.types.AuditElements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/role"})
public class RoleController
extends AbstractController {
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private RoleDataBinder roleDataBinder;

    @PreAuthorize(value="hasRole('ROLE_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/create"})
    public RoleTO create(HttpServletResponse response, @RequestBody RoleTO roleTO) throws SyncopeClientCompositeErrorException, UnauthorizedRoleException {
        LOG.debug("Role create called with parameters {}", (Object)roleTO);
        Set<Long> allowedRoleIds = EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames());
        if (roleTO.getParent() != 0L && !allowedRoleIds.contains(roleTO.getParent())) {
            throw new UnauthorizedRoleException(roleTO.getParent());
        }
        SyncopeRole role = this.roleDAO.save(this.roleDataBinder.create(roleTO));
        this.auditManager.audit(AuditElements.Category.role, (Enum<?>)AuditElements.RoleSubCategory.create, AuditElements.Result.success, "Successfully created role: " + role.getId());
        response.setStatus(201);
        return this.roleDataBinder.getRoleTO(role);
    }

    @PreAuthorize(value="hasRole('ROLE_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/delete/{roleId}"})
    public RoleTO delete(@PathVariable(value="roleId") Long roleId) throws NotFoundException, UnauthorizedRoleException {
        SyncopeRole role = this.roleDAO.find(roleId);
        if (role == null) {
            throw new NotFoundException("Role " + roleId);
        }
        RoleTO roleToDelete = this.roleDataBinder.getRoleTO(role);
        Set<Long> allowedRoleIds = EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames());
        if (!allowedRoleIds.contains(role.getId())) {
            throw new UnauthorizedRoleException(role.getId());
        }
        this.auditManager.audit(AuditElements.Category.role, (Enum<?>)AuditElements.RoleSubCategory.delete, AuditElements.Result.success, "Successfully deleted role: " + role.getId());
        this.roleDAO.delete(roleId);
        return roleToDelete;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/list"})
    @Transactional(readOnly=true)
    public List<RoleTO> list() {
        List<SyncopeRole> roles = this.roleDAO.findAll();
        ArrayList<RoleTO> roleTOs = new ArrayList<RoleTO>();
        for (SyncopeRole role : roles) {
            roleTOs.add(this.roleDataBinder.getRoleTO(role));
        }
        this.auditManager.audit(AuditElements.Category.role, (Enum<?>)AuditElements.RoleSubCategory.list, AuditElements.Result.success, "Successfully listed all roles: " + roleTOs.size());
        return roleTOs;
    }

    @PreAuthorize(value="hasRole('ROLE_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/parent/{roleId}"})
    @Transactional(readOnly=true)
    public RoleTO parent(@PathVariable(value="roleId") Long roleId) throws NotFoundException, UnauthorizedRoleException {
        SyncopeRole role = this.roleDAO.find(roleId);
        if (role == null) {
            throw new NotFoundException("Role " + roleId);
        }
        Set<Long> allowedRoleIds = EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames());
        if (role.getParent() != null && !allowedRoleIds.contains(role.getParent().getId())) {
            throw new UnauthorizedRoleException(role.getParent().getId());
        }
        RoleTO result = role.getParent() == null ? null : this.roleDataBinder.getRoleTO(role.getParent());
        this.auditManager.audit(AuditElements.Category.role, (Enum<?>)AuditElements.RoleSubCategory.parent, AuditElements.Result.success, result == null ? "Role " + role.getId() + " is a root role" : "Found parent for role " + role.getId() + ": " + result.getId());
        return result;
    }

    @PreAuthorize(value="hasRole('ROLE_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/children/{roleId}"})
    @Transactional(readOnly=true)
    public List<RoleTO> children(@PathVariable(value="roleId") Long roleId) {
        Set<Long> allowedRoleIds = EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames());
        List<SyncopeRole> roles = this.roleDAO.findChildren(roleId);
        ArrayList<RoleTO> roleTOs = new ArrayList<RoleTO>(roles.size());
        for (SyncopeRole role : roles) {
            if (!allowedRoleIds.contains(role.getId())) continue;
            roleTOs.add(this.roleDataBinder.getRoleTO(role));
        }
        this.auditManager.audit(AuditElements.Category.role, (Enum<?>)AuditElements.RoleSubCategory.children, AuditElements.Result.success, "Found " + roleTOs.size() + " children of role " + roleId);
        return roleTOs;
    }

    @PreAuthorize(value="hasRole('ROLE_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/read/{roleId}"})
    @Transactional(readOnly=true)
    public RoleTO read(@PathVariable(value="roleId") Long roleId) throws NotFoundException, UnauthorizedRoleException {
        SyncopeRole role = this.roleDAO.find(roleId);
        if (role == null) {
            throw new NotFoundException("Role " + roleId);
        }
        Set<Long> allowedRoleIds = EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames());
        if (!allowedRoleIds.contains(role.getId())) {
            throw new UnauthorizedRoleException(role.getId());
        }
        this.auditManager.audit(AuditElements.Category.role, (Enum<?>)AuditElements.RoleSubCategory.read, AuditElements.Result.success, "Successfully read role: " + role.getId());
        return this.roleDataBinder.getRoleTO(role);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(method={RequestMethod.GET}, value={"/selfRead/{roleId}"})
    @Transactional(readOnly=true)
    public RoleTO selfRead(@PathVariable(value="roleId") Long roleId) throws NotFoundException, UnauthorizedRoleException {
        SyncopeRole role = this.roleDAO.find(roleId);
        if (role == null) {
            throw new NotFoundException("Role " + roleId);
        }
        SyncopeUser authUser = this.userDAO.find(SecurityContextHolder.getContext().getAuthentication().getName());
        if (authUser == null) {
            throw new NotFoundException("Authenticated user " + SecurityContextHolder.getContext().getAuthentication().getName());
        }
        Set<Long> allowedRoleIds = EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames());
        allowedRoleIds.addAll(authUser.getRoleIds());
        if (!allowedRoleIds.contains(role.getId())) {
            throw new UnauthorizedRoleException(role.getId());
        }
        this.auditManager.audit(AuditElements.Category.role, (Enum<?>)AuditElements.RoleSubCategory.selfRead, AuditElements.Result.success, "Successfully read own role: " + role.getId());
        return this.roleDataBinder.getRoleTO(role);
    }

    @PreAuthorize(value="hasRole('ROLE_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/update"})
    public RoleTO update(@RequestBody RoleMod roleMod) throws NotFoundException, UnauthorizedRoleException {
        LOG.debug("Role update called with parameter {}", (Object)roleMod);
        SyncopeRole role = this.roleDAO.find(roleMod.getId());
        if (role == null) {
            throw new NotFoundException("Role " + String.valueOf(roleMod.getId()));
        }
        Set<Long> allowedRoleIds = EntitlementUtil.getRoleIds(EntitlementUtil.getOwnedEntitlementNames());
        if (!allowedRoleIds.contains(role.getId())) {
            throw new UnauthorizedRoleException(role.getId());
        }
        this.roleDataBinder.update(role, roleMod);
        role = this.roleDAO.save(role);
        this.auditManager.audit(AuditElements.Category.role, (Enum<?>)AuditElements.RoleSubCategory.update, AuditElements.Result.success, "Successfully updated role: " + role.getId());
        return this.roleDataBinder.getRoleTO(role);
    }
}

