/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletResponse;
import org.apache.syncope.client.to.ConnObjectTO;
import org.apache.syncope.client.to.ResourceTO;
import org.apache.syncope.client.to.SchemaMappingTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.init.ConnInstanceLoader;
import org.apache.syncope.core.persistence.beans.ConnInstance;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.role.SyncopeRole;
import org.apache.syncope.core.persistence.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.dao.ResourceDAO;
import org.apache.syncope.core.persistence.dao.RoleDAO;
import org.apache.syncope.core.propagation.ConnectorFacadeProxy;
import org.apache.syncope.core.rest.controller.AbstractController;
import org.apache.syncope.core.rest.data.ConnInstanceDataBinder;
import org.apache.syncope.core.rest.data.ResourceDataBinder;
import org.apache.syncope.core.util.ConnBundleManager;
import org.apache.syncope.core.util.ConnObjectUtil;
import org.apache.syncope.types.AuditElements;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/resource"})
public class ResourceController
extends AbstractController {
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private ResourceDAO resourceDAO;
    @Autowired
    private ConnInstanceDAO connInstanceDAO;
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private ResourceDataBinder binder;
    @Autowired
    private ConnInstanceDataBinder connInstancebinder;
    @Autowired
    private ConnObjectUtil connObjectUtil;
    @Autowired
    private ConnInstanceLoader connLoader;
    @Autowired
    private ConnBundleManager bundleManager;

    @PreAuthorize(value="hasRole('RESOURCE_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/create"})
    public ResourceTO create(HttpServletResponse response, @RequestBody ResourceTO resourceTO) throws SyncopeClientCompositeErrorException, NotFoundException {
        LOG.debug("Resource creation: {}", (Object)resourceTO);
        ExternalResource resource = this.resourceDAO.save(this.binder.create(resourceTO));
        this.auditManager.audit(AuditElements.Category.resource, (Enum<?>)AuditElements.ResourceSubCategory.create, AuditElements.Result.success, "Successfully created resource: " + resource.getName());
        response.setStatus(201);
        return this.binder.getResourceTO(resource);
    }

    @PreAuthorize(value="hasRole('RESOURCE_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/update"})
    public ResourceTO update(@RequestBody ResourceTO resourceTO) throws SyncopeClientCompositeErrorException, NotFoundException {
        LOG.debug("Role update request: {}", (Object)resourceTO);
        ExternalResource resource = this.resourceDAO.find(resourceTO.getName());
        if (resource == null) {
            throw new NotFoundException("Resource '" + resourceTO.getName() + "'");
        }
        resource = this.binder.update(resource, resourceTO);
        resource = this.resourceDAO.save(resource);
        this.auditManager.audit(AuditElements.Category.resource, (Enum<?>)AuditElements.ResourceSubCategory.update, AuditElements.Result.success, "Successfully updated resource: " + resource.getName());
        return this.binder.getResourceTO(resource);
    }

    @PreAuthorize(value="hasRole('RESOURCE_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/delete/{resourceName}"})
    public ResourceTO delete(@PathVariable(value="resourceName") String resourceName) throws NotFoundException {
        ExternalResource resource = this.resourceDAO.find(resourceName);
        if (resource == null) {
            throw new NotFoundException("Resource '" + resourceName + "'");
        }
        ResourceTO resourceToDelete = this.binder.getResourceTO(resource);
        this.auditManager.audit(AuditElements.Category.resource, (Enum<?>)AuditElements.ResourceSubCategory.delete, AuditElements.Result.success, "Successfully deleted resource: " + resource.getName());
        this.resourceDAO.delete(resourceName);
        return resourceToDelete;
    }

    @PreAuthorize(value="hasRole('RESOURCE_READ')")
    @Transactional(readOnly=true)
    @RequestMapping(method={RequestMethod.GET}, value={"/read/{resourceName}"})
    public ResourceTO read(@PathVariable(value="resourceName") String resourceName) throws NotFoundException {
        ExternalResource resource = this.resourceDAO.find(resourceName);
        if (resource == null) {
            throw new NotFoundException("Resource '" + resourceName + "'");
        }
        this.auditManager.audit(AuditElements.Category.resource, (Enum<?>)AuditElements.ResourceSubCategory.read, AuditElements.Result.success, "Successfully read resource: " + resource.getName());
        return this.binder.getResourceTO(resource);
    }

    @Transactional(readOnly=true)
    @RequestMapping(method={RequestMethod.GET}, value={"/list"})
    public List<ResourceTO> list(@RequestParam(required=false, value="connInstanceId") Long connInstanceId) throws NotFoundException {
        List<ExternalResource> resources;
        if (connInstanceId == null) {
            resources = this.resourceDAO.findAll();
        } else {
            ConnInstance connInstance = this.connInstanceDAO.find(connInstanceId);
            resources = connInstance.getResources();
        }
        List<ResourceTO> result = this.binder.getResourceTOs(resources);
        this.auditManager.audit(AuditElements.Category.resource, (Enum<?>)AuditElements.ResourceSubCategory.list, AuditElements.Result.success, connInstanceId == null ? "Successfully listed all resources: " + result.size() : "Successfully listed resources for connector " + connInstanceId + ": " + result.size());
        return result;
    }

    @PreAuthorize(value="hasRole('RESOURCE_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/{roleId}/mappings"})
    public List<SchemaMappingTO> getRoleResourcesMapping(@PathVariable(value="roleId") Long roleId) throws NotFoundException {
        SyncopeRole role = this.roleDAO.find(roleId);
        if (role == null) {
            throw new NotFoundException("Role '" + roleId + "'");
        }
        ArrayList<SchemaMappingTO> roleMappings = new ArrayList<SchemaMappingTO>();
        for (ExternalResource resource : role.getResources()) {
            roleMappings.addAll(this.binder.getSchemaMappingTOs(resource.getMappings()));
        }
        this.auditManager.audit(AuditElements.Category.resource, (Enum<?>)AuditElements.ResourceSubCategory.getRoleResourcesMapping, AuditElements.Result.success, "Found " + roleMappings.size() + " mappings for role " + roleId);
        return roleMappings;
    }

    @PreAuthorize(value="hasRole('RESOURCE_GETOBJECT')")
    @Transactional(readOnly=true)
    @RequestMapping(method={RequestMethod.GET}, value={"/{resourceName}/read/{objectId}"})
    public ConnObjectTO getObject(@PathVariable(value="resourceName") String resourceName, @PathVariable(value="objectId") String objectId) throws NotFoundException {
        ExternalResource resource = this.resourceDAO.find(resourceName);
        if (resource == null) {
            throw new NotFoundException("Resource '" + resourceName + "'");
        }
        ConnectorFacadeProxy connector = this.connLoader.getConnector(resource);
        ConnectorObject connectorObject = connector.getObject(ObjectClass.ACCOUNT, new Uid(objectId), connector.getOperationOptions(resource));
        if (connectorObject == null) {
            throw new NotFoundException("Object " + objectId + " not found on resource " + resourceName);
        }
        Set attributes = connectorObject.getAttributes();
        if (AttributeUtil.find((String)Uid.NAME, (Set)attributes) == null) {
            attributes.add(connectorObject.getUid());
        }
        if (AttributeUtil.find((String)Name.NAME, (Set)attributes) == null) {
            attributes.add(connectorObject.getName());
        }
        this.auditManager.audit(AuditElements.Category.resource, (Enum<?>)AuditElements.ResourceSubCategory.getObject, AuditElements.Result.success, "Successfully read object " + objectId + " from resource " + resourceName);
        return this.connObjectUtil.getConnObjectTO(connectorObject);
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    @RequestMapping(method={RequestMethod.POST}, value={"/check"})
    @Transactional(readOnly=true)
    public ModelAndView check(HttpServletResponse response, @RequestBody ResourceTO resourceTO) throws SyncopeClientCompositeErrorException, NotFoundException {
        boolean result;
        ConnInstance connInstance = this.binder.getConnInstance(resourceTO);
        ConnectorFacadeProxy connector = new ConnectorFacadeProxy(connInstance, this.bundleManager);
        try {
            connector.test();
            result = true;
            this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.check, AuditElements.Result.success, "Successfully checked connector: " + resourceTO);
        }
        catch (Exception ex) {
            this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.check, AuditElements.Result.failure, "Unsuccessful check for connector: " + resourceTO, ex);
            LOG.error("Test connection failure {}", (Throwable)ex);
            result = false;
        }
        return new ModelAndView().addObject((Object)result);
    }
}

