/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipInputStream;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.optional.pipeline.components.sax.fop.FopSerializer;
import org.apache.cocoon.pipeline.NonCachingPipeline;
import org.apache.cocoon.pipeline.component.PipelineComponent;
import org.apache.cocoon.sax.component.XMLGenerator;
import org.apache.cocoon.sax.component.XMLSerializer;
import org.apache.cocoon.sax.component.XSLTTransformer;
import org.apache.syncope.client.report.ReportletConf;
import org.apache.syncope.client.to.ReportExecTO;
import org.apache.syncope.client.to.ReportTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.client.validation.SyncopeClientException;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.init.JobInstanceLoader;
import org.apache.syncope.core.persistence.beans.Report;
import org.apache.syncope.core.persistence.beans.ReportExec;
import org.apache.syncope.core.persistence.dao.ReportDAO;
import org.apache.syncope.core.persistence.dao.ReportExecDAO;
import org.apache.syncope.core.report.Reportlet;
import org.apache.syncope.core.rest.controller.AbstractController;
import org.apache.syncope.core.rest.data.ReportDataBinder;
import org.apache.syncope.types.AuditElements;
import org.apache.syncope.types.ReportExecExportFormat;
import org.apache.syncope.types.ReportExecStatus;
import org.apache.syncope.types.SyncopeClientExceptionType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/report"})
public class ReportController
extends AbstractController {
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private ReportDAO reportDAO;
    @Autowired
    private ReportExecDAO reportExecDAO;
    @Autowired
    private JobInstanceLoader jobInstanceLoader;
    @Autowired
    private SchedulerFactoryBean scheduler;
    @Autowired
    private ReportDataBinder binder;

    @PreAuthorize(value="hasRole('REPORT_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/create"})
    public ReportTO create(HttpServletResponse response, @RequestBody ReportTO reportTO) {
        LOG.debug("Creating report " + reportTO);
        Report report = new Report();
        this.binder.getReport(report, reportTO);
        report = this.reportDAO.save(report);
        try {
            this.jobInstanceLoader.registerJob(report);
        }
        catch (Exception e) {
            LOG.error("While registering quartz job for report " + report.getId(), (Throwable)e);
            SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
            SyncopeClientException sce = new SyncopeClientException(SyncopeClientExceptionType.Scheduling);
            sce.addElement(e.getMessage());
            scce.addException(sce);
            throw scce;
        }
        this.auditManager.audit(AuditElements.Category.report, (Enum<?>)AuditElements.ReportSubCategory.create, AuditElements.Result.success, "Successfully created report: " + report.getId());
        response.setStatus(201);
        return this.binder.getReportTO(report);
    }

    @PreAuthorize(value="hasRole('REPORT_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/update"})
    public ReportTO update(@RequestBody ReportTO reportTO) throws NotFoundException {
        LOG.debug("Report update called with parameter {}", (Object)reportTO);
        Report report = this.reportDAO.find(reportTO.getId());
        if (report == null) {
            throw new NotFoundException("Report " + reportTO.getId());
        }
        this.binder.getReport(report, reportTO);
        report = this.reportDAO.save(report);
        try {
            this.jobInstanceLoader.registerJob(report);
        }
        catch (Exception e) {
            LOG.error("While registering quartz job for report " + report.getId(), (Throwable)e);
            SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
            SyncopeClientException sce = new SyncopeClientException(SyncopeClientExceptionType.Scheduling);
            sce.addElement(e.getMessage());
            scce.addException(sce);
            throw scce;
        }
        this.auditManager.audit(AuditElements.Category.report, (Enum<?>)AuditElements.ReportSubCategory.update, AuditElements.Result.success, "Successfully updated report: " + report.getId());
        return this.binder.getReportTO(report);
    }

    @PreAuthorize(value="hasRole('REPORT_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/count"})
    public ModelAndView count() {
        return new ModelAndView().addObject((Object)this.reportDAO.count());
    }

    @PreAuthorize(value="hasRole('REPORT_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/list"})
    public List<ReportTO> list() {
        List<Report> reports = this.reportDAO.findAll();
        ArrayList<ReportTO> result = new ArrayList<ReportTO>(reports.size());
        for (Report report : reports) {
            result.add(this.binder.getReportTO(report));
        }
        this.auditManager.audit(AuditElements.Category.report, (Enum<?>)AuditElements.ReportSubCategory.list, AuditElements.Result.success, "Successfully listed all reports: " + result.size());
        return result;
    }

    @PreAuthorize(value="hasRole('REPORT_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/list/{page}/{size}"})
    public List<ReportTO> list(@PathVariable(value="page") int page, @PathVariable(value="size") int size) {
        List<Report> reports = this.reportDAO.findAll(page, size);
        ArrayList<ReportTO> result = new ArrayList<ReportTO>(reports.size());
        for (Report report : reports) {
            result.add(this.binder.getReportTO(report));
        }
        this.auditManager.audit(AuditElements.Category.report, (Enum<?>)AuditElements.ReportSubCategory.list, AuditElements.Result.success, "Successfully listed reports (page=" + page + ", size=" + size + "): " + result.size());
        return result;
    }

    @PreAuthorize(value="hasRole('REPORT_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/execution/list"})
    public List<ReportExecTO> listExecutions() {
        List<ReportExec> executions = this.reportExecDAO.findAll();
        ArrayList<ReportExecTO> executionTOs = new ArrayList<ReportExecTO>(executions.size());
        for (ReportExec execution : executions) {
            executionTOs.add(this.binder.getReportExecTO(execution));
        }
        this.auditManager.audit(AuditElements.Category.report, (Enum<?>)AuditElements.ReportSubCategory.listExecutions, AuditElements.Result.success, "Successfully listed all report executions: " + executionTOs.size());
        return executionTOs;
    }

    @PreAuthorize(value="hasRole('REPORT_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/reportletConfClasses"})
    public ModelAndView getReportletConfClasses() {
        HashSet<String> reportletConfClasses = new HashSet<String>();
        for (Class<Reportlet> reportletClass : this.binder.getAllReportletClasses()) {
            Class<? extends ReportletConf> reportletConfClass = this.binder.getReportletConfClass(reportletClass);
            if (reportletConfClass == null) continue;
            reportletConfClasses.add(reportletConfClass.getName());
        }
        this.auditManager.audit(AuditElements.Category.report, (Enum<?>)AuditElements.ReportSubCategory.getReportletConfClasses, AuditElements.Result.success, "Successfully listed all ReportletConf classes: " + reportletConfClasses.size());
        return new ModelAndView().addObject(reportletConfClasses);
    }

    @PreAuthorize(value="hasRole('REPORT_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/read/{reportId}"})
    public ReportTO read(@PathVariable(value="reportId") Long reportId) throws NotFoundException {
        Report report = this.reportDAO.find(reportId);
        if (report == null) {
            throw new NotFoundException("Report " + reportId);
        }
        this.auditManager.audit(AuditElements.Category.report, (Enum<?>)AuditElements.ReportSubCategory.read, AuditElements.Result.success, "Successfully read report: " + report.getId());
        return this.binder.getReportTO(report);
    }

    @PreAuthorize(value="hasRole('REPORT_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/execution/read/{executionId}"})
    @Transactional(readOnly=true)
    public ReportExecTO readExecution(@PathVariable(value="executionId") Long executionId) throws NotFoundException {
        ReportExec reportExec = this.reportExecDAO.find(executionId);
        if (reportExec == null) {
            throw new NotFoundException("Report execution " + executionId);
        }
        this.auditManager.audit(AuditElements.Category.report, (Enum<?>)AuditElements.ReportSubCategory.readExecution, AuditElements.Result.success, "Successfully read report execution: " + reportExec.getId());
        return this.binder.getReportExecTO(reportExec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="hasRole('REPORT_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/execution/export/{executionId}"})
    @Transactional(readOnly=true)
    public void exportExecutionResult(HttpServletResponse response, @PathVariable(value="executionId") Long executionId, @RequestParam(value="fmt", required=false) ReportExecExportFormat fmt) throws NotFoundException {
        ReportExec reportExec = this.reportExecDAO.find(executionId);
        if (reportExec == null) {
            throw new NotFoundException("Report execution " + executionId);
        }
        if (!ReportExecStatus.SUCCESS.name().equals(reportExec.getStatus()) || reportExec.getExecResult() == null) {
            SyncopeClientCompositeErrorException sccee = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
            SyncopeClientException sce = new SyncopeClientException(SyncopeClientExceptionType.InvalidReportExec);
            sce.addElement(reportExec.getExecResult() == null ? "No report data produced" : "Report did not run successfully");
            sccee.addException(sce);
            throw sccee;
        }
        ReportExecExportFormat format = fmt == null ? ReportExecExportFormat.XML : fmt;
        LOG.debug("Exporting result of {} as {}", (Object)reportExec, (Object)format);
        response.setContentType("application/octet-stream");
        response.addHeader("Content-Disposition", "attachment; filename=" + reportExec.getReport().getName() + "." + format.name().toLowerCase());
        ByteArrayInputStream bais = new ByteArrayInputStream(reportExec.getExecResult());
        ZipInputStream zis = new ZipInputStream(bais);
        try {
            zis.getNextEntry();
            NonCachingPipeline pipeline = new NonCachingPipeline();
            pipeline.addComponent((PipelineComponent)new XMLGenerator((InputStream)zis));
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("status", reportExec.getStatus());
            parameters.put("message", reportExec.getMessage());
            parameters.put("startDate", reportExec.getStartDate());
            parameters.put("endDate", reportExec.getEndDate());
            switch (format) {
                case HTML: {
                    XSLTTransformer xsl2html = new XSLTTransformer(this.getClass().getResource("/report/report2html.xsl"));
                    xsl2html.setParameters(parameters);
                    pipeline.addComponent((PipelineComponent)xsl2html);
                    pipeline.addComponent((PipelineComponent)XMLSerializer.createXHTMLSerializer());
                    break;
                }
                case PDF: {
                    XSLTTransformer xsl2pdf = new XSLTTransformer(this.getClass().getResource("/report/report2fo.xsl"));
                    xsl2pdf.setParameters(parameters);
                    pipeline.addComponent((PipelineComponent)xsl2pdf);
                    pipeline.addComponent((PipelineComponent)new FopSerializer("application/pdf"));
                    break;
                }
                case RTF: {
                    XSLTTransformer xsl2rtf = new XSLTTransformer(this.getClass().getResource("/report/report2fo.xsl"));
                    xsl2rtf.setParameters(parameters);
                    pipeline.addComponent((PipelineComponent)xsl2rtf);
                    pipeline.addComponent((PipelineComponent)new FopSerializer("application/rtf"));
                    break;
                }
                default: {
                    pipeline.addComponent((PipelineComponent)XMLSerializer.createXMLSerializer());
                }
            }
            pipeline.setup((OutputStream)response.getOutputStream());
            pipeline.execute();
            LOG.debug("Result of {} successfully exported as {}", (Object)reportExec, (Object)format);
        }
        catch (Exception e) {
            LOG.error("While exporting content", (Throwable)e);
        }
        finally {
            try {
                zis.close();
                bais.close();
            }
            catch (IOException e) {
                LOG.error("While closing stream for execution result", (Throwable)e);
            }
        }
        this.auditManager.audit(AuditElements.Category.report, (Enum<?>)AuditElements.ReportSubCategory.exportExecutionResult, AuditElements.Result.success, "Successfully exported report execution: " + reportExec.getId());
    }

    @PreAuthorize(value="hasRole('REPORT_EXECUTE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/execute/{reportId}"})
    public ReportExecTO execute(@PathVariable(value="reportId") Long reportId) throws NotFoundException {
        Report report = this.reportDAO.find(reportId);
        if (report == null) {
            throw new NotFoundException("Report " + reportId);
        }
        LOG.debug("Triggering new execution of report {}", (Object)report);
        try {
            this.jobInstanceLoader.registerJob(report);
            this.scheduler.getScheduler().triggerJob(JobInstanceLoader.getJobName(report), "DEFAULT");
            this.auditManager.audit(AuditElements.Category.report, (Enum<?>)AuditElements.ReportSubCategory.execute, AuditElements.Result.success, "Successfully started execution for report: " + report.getId());
        }
        catch (Exception e) {
            LOG.error("While executing report {}", (Object)report, (Object)e);
            this.auditManager.audit(AuditElements.Category.report, (Enum<?>)AuditElements.ReportSubCategory.execute, AuditElements.Result.failure, "Could not start execution for report: " + report.getId(), e);
            SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
            SyncopeClientException sce = new SyncopeClientException(SyncopeClientExceptionType.Scheduling);
            sce.addElement(e.getMessage());
            scce.addException(sce);
            throw scce;
        }
        ReportExecTO result = new ReportExecTO();
        result.setReport(reportId.longValue());
        result.setStartDate(new Date());
        result.setStatus(ReportExecStatus.STARTED);
        result.setMessage("Job fired; waiting for results...");
        return result;
    }

    @PreAuthorize(value="hasRole('REPORT_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/delete/{reportId}"})
    public ReportTO delete(@PathVariable(value="reportId") Long reportId) throws NotFoundException, SyncopeClientCompositeErrorException {
        Report report = this.reportDAO.find(reportId);
        if (report == null) {
            throw new NotFoundException("Report " + reportId);
        }
        ReportTO deletedReport = this.binder.getReportTO(report);
        this.jobInstanceLoader.unregisterJob(report);
        this.reportDAO.delete(report);
        this.auditManager.audit(AuditElements.Category.report, (Enum<?>)AuditElements.ReportSubCategory.delete, AuditElements.Result.success, "Successfully deleted report: " + report.getId());
        return deletedReport;
    }

    @PreAuthorize(value="hasRole('REPORT_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/execution/delete/{executionId}"})
    public ReportExecTO deleteExecution(@PathVariable(value="executionId") Long executionId) throws NotFoundException, SyncopeClientCompositeErrorException {
        ReportExec reportExec = this.reportExecDAO.find(executionId);
        if (reportExec == null) {
            throw new NotFoundException("Report execution " + executionId);
        }
        ReportExecTO reportExecToDelete = this.binder.getReportExecTO(reportExec);
        this.reportExecDAO.delete(reportExec);
        this.auditManager.audit(AuditElements.Category.report, (Enum<?>)AuditElements.ReportSubCategory.deleteExecution, AuditElements.Result.success, "Successfully deleted report execution: " + reportExec.getId());
        return reportExecToDelete;
    }
}

