/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletResponse;
import org.apache.syncope.client.to.AccountPolicyTO;
import org.apache.syncope.client.to.PasswordPolicyTO;
import org.apache.syncope.client.to.PolicyTO;
import org.apache.syncope.client.to.SyncPolicyTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.persistence.beans.AccountPolicy;
import org.apache.syncope.core.persistence.beans.PasswordPolicy;
import org.apache.syncope.core.persistence.beans.Policy;
import org.apache.syncope.core.persistence.beans.SyncPolicy;
import org.apache.syncope.core.persistence.dao.PolicyDAO;
import org.apache.syncope.core.rest.controller.AbstractController;
import org.apache.syncope.core.rest.data.PolicyDataBinder;
import org.apache.syncope.types.AuditElements;
import org.apache.syncope.types.PolicyType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/policy"})
public class PolicyController
extends AbstractController {
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private PolicyDAO policyDAO;
    @Autowired
    private PolicyDataBinder binder;

    @PreAuthorize(value="hasRole('POLICY_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/password/create"})
    public PasswordPolicyTO create(HttpServletResponse response, @RequestBody PasswordPolicyTO policyTO) throws SyncopeClientCompositeErrorException {
        LOG.debug("Creating policy " + policyTO);
        PasswordPolicy policy = this.binder.getPolicy(null, (PolicyTO)policyTO);
        this.auditManager.audit(AuditElements.Category.policy, (Enum<?>)AuditElements.PolicySubCategory.create, AuditElements.Result.success, "Successfully created password policy: " + policy.getId());
        return (PasswordPolicyTO)this.binder.getPolicyTO(this.policyDAO.save(policy));
    }

    @PreAuthorize(value="hasRole('POLICY_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/account/create"})
    public AccountPolicyTO create(HttpServletResponse response, @RequestBody AccountPolicyTO policyTO) throws SyncopeClientCompositeErrorException {
        LOG.debug("Creating policy " + policyTO);
        AccountPolicy policy = this.binder.getPolicy(null, (PolicyTO)policyTO);
        this.auditManager.audit(AuditElements.Category.policy, (Enum<?>)AuditElements.PolicySubCategory.create, AuditElements.Result.success, "Successfully created account policy: " + policy.getId());
        return (AccountPolicyTO)this.binder.getPolicyTO(this.policyDAO.save(policy));
    }

    @PreAuthorize(value="hasRole('POLICY_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/sync/create"})
    public SyncPolicyTO create(HttpServletResponse response, @RequestBody SyncPolicyTO policyTO) throws SyncopeClientCompositeErrorException {
        LOG.debug("Creating policy " + policyTO);
        SyncPolicy policy = this.binder.getPolicy(null, (PolicyTO)policyTO);
        this.auditManager.audit(AuditElements.Category.policy, (Enum<?>)AuditElements.PolicySubCategory.create, AuditElements.Result.success, "Successfully created sync policy: " + policy.getId());
        return (SyncPolicyTO)this.binder.getPolicyTO(this.policyDAO.save(policy));
    }

    private <T extends PolicyTO, K extends Policy> T update(T policyTO, K policy) {
        LOG.debug("Updating policy " + policyTO);
        this.binder.getPolicy(policy, policyTO);
        K savedPolicy = this.policyDAO.save(policy);
        this.auditManager.audit(AuditElements.Category.policy, (Enum<?>)AuditElements.PolicySubCategory.update, AuditElements.Result.success, "Successfully updated policy (" + savedPolicy.getType() + "): " + savedPolicy.getId());
        return this.binder.getPolicyTO(savedPolicy);
    }

    @PreAuthorize(value="hasRole('POLICY_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/password/update"})
    public PasswordPolicyTO update(@RequestBody PasswordPolicyTO policyTO) throws NotFoundException {
        Policy policy = this.policyDAO.find(policyTO.getId());
        if (!(policy instanceof PasswordPolicy)) {
            throw new NotFoundException("PasswordPolicy with id " + policyTO.getId());
        }
        return this.update(policyTO, policy);
    }

    @PreAuthorize(value="hasRole('POLICY_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/account/update"})
    public AccountPolicyTO update(@RequestBody AccountPolicyTO policyTO) throws NotFoundException, SyncopeClientCompositeErrorException {
        Policy policy = this.policyDAO.find(policyTO.getId());
        if (!(policy instanceof AccountPolicy)) {
            throw new NotFoundException("AccountPolicy with id " + policyTO.getId());
        }
        return this.update(policyTO, policy);
    }

    @PreAuthorize(value="hasRole('POLICY_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/sync/update"})
    public SyncPolicyTO update(@RequestBody SyncPolicyTO policyTO) throws NotFoundException, SyncopeClientCompositeErrorException {
        Policy policy = this.policyDAO.find(policyTO.getId());
        if (!(policy instanceof SyncPolicy)) {
            throw new NotFoundException("SyncPolicy with id " + policyTO.getId());
        }
        return this.update(policyTO, policy);
    }

    @PreAuthorize(value="hasRole('POLICY_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/{kind}/list"})
    public List<PolicyTO> listByType(@PathVariable(value="kind") String kind) {
        LOG.debug("Listing policies");
        List<? extends Policy> policies = this.policyDAO.find(PolicyType.valueOf((String)kind.toUpperCase(Locale.ENGLISH)));
        ArrayList<PolicyTO> policyTOs = new ArrayList<PolicyTO>();
        for (Policy policy : policies) {
            policyTOs.add((PolicyTO)this.binder.getPolicyTO(policy));
        }
        this.auditManager.audit(AuditElements.Category.policy, (Enum<?>)AuditElements.PolicySubCategory.list, AuditElements.Result.success, "Successfully listed all policies (" + kind + "): " + policyTOs.size());
        return policyTOs;
    }

    @PreAuthorize(value="hasRole('POLICY_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/password/global/read"})
    public PasswordPolicyTO getGlobalPasswordPolicy() throws NotFoundException {
        LOG.debug("Reading global password policy");
        PasswordPolicy policy = this.policyDAO.getGlobalPasswordPolicy();
        if (policy == null) {
            throw new NotFoundException("No password policy found");
        }
        this.auditManager.audit(AuditElements.Category.policy, (Enum<?>)AuditElements.PolicySubCategory.read, AuditElements.Result.success, "Successfully read global password policy: " + policy.getId());
        return (PasswordPolicyTO)this.binder.getPolicyTO(policy);
    }

    @PreAuthorize(value="hasRole('POLICY_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/account/global/read"})
    public AccountPolicyTO getGlobalAccountPolicy() throws NotFoundException {
        LOG.debug("Reading global account policy");
        AccountPolicy policy = this.policyDAO.getGlobalAccountPolicy();
        if (policy == null) {
            throw new NotFoundException("No account policy found");
        }
        this.auditManager.audit(AuditElements.Category.policy, (Enum<?>)AuditElements.PolicySubCategory.read, AuditElements.Result.success, "Successfully read global account policy: " + policy.getId());
        return (AccountPolicyTO)this.binder.getPolicyTO(policy);
    }

    @PreAuthorize(value="hasRole('POLICY_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/sync/global/read"})
    public SyncPolicyTO getGlobalSyncPolicy() throws NotFoundException {
        LOG.debug("Reading global sync policy");
        SyncPolicy policy = this.policyDAO.getGlobalSyncPolicy();
        if (policy == null) {
            throw new NotFoundException("No sync policy found");
        }
        this.auditManager.audit(AuditElements.Category.policy, (Enum<?>)AuditElements.PolicySubCategory.read, AuditElements.Result.success, "Successfully read global sync policy: " + policy.getId());
        return (SyncPolicyTO)this.binder.getPolicyTO(policy);
    }

    @PreAuthorize(value="hasRole('POLICY_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/read/{id}"})
    public PolicyTO read(@PathVariable(value="id") Long id) throws NotFoundException {
        LOG.debug("Reading policy with id {}", (Object)id);
        Policy policy = this.policyDAO.find(id);
        if (policy == null) {
            throw new NotFoundException("Policy " + id + " not found");
        }
        this.auditManager.audit(AuditElements.Category.policy, (Enum<?>)AuditElements.PolicySubCategory.read, AuditElements.Result.success, "Successfully read policy (" + policy.getType() + "): " + policy.getId());
        return this.binder.getPolicyTO(policy);
    }

    @PreAuthorize(value="hasRole('POLICY_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/delete/{id}"})
    public PolicyTO delete(@PathVariable(value="id") Long id) throws NotFoundException {
        LOG.debug("Delete policy");
        Policy policy = this.policyDAO.find(id);
        if (policy == null) {
            throw new NotFoundException("Policy " + id + " not found");
        }
        Object policyToDelete = this.binder.getPolicyTO(policy);
        this.policyDAO.delete(id);
        this.auditManager.audit(AuditElements.Category.policy, (Enum<?>)AuditElements.PolicySubCategory.delete, AuditElements.Result.success, "Successfully deleted policy: " + id);
        return policyToDelete;
    }
}

