/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.util.ArrayList;
import java.util.List;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletResponse;
import org.apache.syncope.client.to.NotificationTO;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.persistence.beans.Notification;
import org.apache.syncope.core.persistence.dao.NotificationDAO;
import org.apache.syncope.core.rest.controller.AbstractController;
import org.apache.syncope.core.rest.data.NotificationDataBinder;
import org.apache.syncope.types.AuditElements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/notification"})
public class NotificationController
extends AbstractController {
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private NotificationDAO notificationDAO;
    @Autowired
    private NotificationDataBinder binder;

    @PreAuthorize(value="hasRole('NOTIFICATION_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/read/{notificationId}"})
    public NotificationTO read(@PathVariable(value="notificationId") Long notificationId) throws NotFoundException {
        Notification notification = this.notificationDAO.find(notificationId);
        if (notification == null) {
            LOG.error("Could not find notification '" + notificationId + "'");
            throw new NotFoundException(String.valueOf(notificationId));
        }
        return this.binder.getNotificationTO(notification);
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/list"})
    public List<NotificationTO> list() throws NotFoundException {
        List<Notification> notifications = this.notificationDAO.findAll();
        ArrayList<NotificationTO> notificationTOs = new ArrayList<NotificationTO>();
        for (Notification notification : notifications) {
            notificationTOs.add(this.binder.getNotificationTO(notification));
        }
        this.auditManager.audit(AuditElements.Category.notification, (Enum<?>)AuditElements.NotificationSubCategory.list, AuditElements.Result.success, "Successfully listed all notifications: " + notificationTOs.size());
        return notificationTOs;
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/create"})
    public NotificationTO create(HttpServletResponse response, @RequestBody NotificationTO notificationTO) throws NotFoundException {
        LOG.debug("Notification create called with parameter {}", (Object)notificationTO);
        Notification notification = this.notificationDAO.save(this.binder.createNotification(notificationTO));
        this.auditManager.audit(AuditElements.Category.notification, (Enum<?>)AuditElements.NotificationSubCategory.create, AuditElements.Result.success, "Successfully created notification: " + notification.getId());
        response.setStatus(201);
        return this.binder.getNotificationTO(notification);
    }

    @PreAuthorize(value="hasRole('NOTIFICATION_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/update"})
    public NotificationTO update(@RequestBody NotificationTO notificationTO) throws NotFoundException {
        LOG.debug("ConnNotificationtor update called with parameter {}", (Object)notificationTO);
        Notification notification = this.notificationDAO.find(notificationTO.getId());
        if (notification == null) {
            LOG.error("Could not find notification '" + notificationTO.getId() + "'");
            throw new NotFoundException(String.valueOf(notificationTO.getId()));
        }
        this.binder.updateNotification(notification, notificationTO);
        notification = this.notificationDAO.save(notification);
        this.auditManager.audit(AuditElements.Category.notification, (Enum<?>)AuditElements.NotificationSubCategory.update, AuditElements.Result.success, "Successfully updated notification: " + notification.getId());
        return this.binder.getNotificationTO(notification);
    }

    @PreAuthorize(value="hasRole('CONNECTOR_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/delete/{notificationId}"})
    public NotificationTO delete(@PathVariable(value="notificationId") Long notificationId) throws NotFoundException {
        Notification notification = this.notificationDAO.find(notificationId);
        if (notification == null) {
            LOG.error("Could not find notificatin '" + notificationId + "'");
            throw new NotFoundException(String.valueOf(notificationId));
        }
        NotificationTO notificationToDelete = this.binder.getNotificationTO(notification);
        this.auditManager.audit(AuditElements.Category.notification, (Enum<?>)AuditElements.NotificationSubCategory.delete, AuditElements.Result.success, "Successfully deleted notification: " + notification.getId());
        this.notificationDAO.delete(notificationId);
        return notificationToDelete;
    }
}

