/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.util.ArrayList;
import java.util.List;
import javassist.NotFoundException;
import org.apache.syncope.client.to.LoggerTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.client.validation.SyncopeClientException;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.persistence.beans.SyncopeLogger;
import org.apache.syncope.core.persistence.dao.LoggerDAO;
import org.apache.syncope.core.rest.controller.AbstractController;
import org.apache.syncope.types.AuditElements;
import org.apache.syncope.types.AuditLoggerName;
import org.apache.syncope.types.SyncopeClientExceptionType;
import org.apache.syncope.types.SyncopeLoggerLevel;
import org.apache.syncope.types.SyncopeLoggerType;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/logger"})
public class LoggerController
extends AbstractController {
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private LoggerDAO loggerDAO;

    private List<LoggerTO> list(SyncopeLoggerType type) {
        ArrayList<LoggerTO> result = new ArrayList<LoggerTO>();
        for (SyncopeLogger syncopeLogger : this.loggerDAO.findAll(type)) {
            LoggerTO loggerTO = new LoggerTO();
            BeanUtils.copyProperties((Object)syncopeLogger, (Object)loggerTO);
            result.add(loggerTO);
        }
        this.auditManager.audit(AuditElements.Category.logger, (Enum<?>)AuditElements.LoggerSubCategory.list, AuditElements.Result.success, "Successfully listed all loggers (" + type + "): " + result.size());
        return result;
    }

    @PreAuthorize(value="hasRole('LOG_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/log/list"})
    @Transactional(readOnly=true)
    public List<LoggerTO> listLogs() {
        return this.list(SyncopeLoggerType.LOG);
    }

    @PreAuthorize(value="hasRole('AUDIT_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/audit/list"})
    @Transactional(readOnly=true)
    public List<AuditLoggerName> listAudits() {
        ArrayList<AuditLoggerName> result = new ArrayList<AuditLoggerName>();
        for (LoggerTO logger : this.list(SyncopeLoggerType.AUDIT)) {
            try {
                result.add(AuditLoggerName.fromLoggerName((String)logger.getName()));
            }
            catch (Exception e) {
                LOG.error("Unexpected audit logger name: {}", (Object)logger.getName(), (Object)e);
            }
        }
        return result;
    }

    private void throwInvalidLogger(SyncopeLoggerType type) {
        SyncopeClientCompositeErrorException sccee = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
        SyncopeClientException sce = new SyncopeClientException(SyncopeClientExceptionType.InvalidLogger);
        sce.addElement("Expected " + type.name());
        throw sccee;
    }

    private LoggerTO setLevel(String name, Level level, SyncopeLoggerType expectedType) {
        SyncopeLogger syncopeLogger = this.loggerDAO.find(name);
        if (syncopeLogger == null) {
            LOG.debug("Logger {} not found: creating new...", (Object)name);
            syncopeLogger = new SyncopeLogger();
            syncopeLogger.setName(name);
            syncopeLogger.setType(name.startsWith(SyncopeLoggerType.AUDIT.getPrefix()) ? SyncopeLoggerType.AUDIT : SyncopeLoggerType.LOG);
        }
        if (expectedType != syncopeLogger.getType()) {
            this.throwInvalidLogger(expectedType);
        }
        syncopeLogger.setLevel(SyncopeLoggerLevel.fromLevel((Level)level));
        syncopeLogger = this.loggerDAO.save(syncopeLogger);
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = lc.getLogger(name);
        logger.setLevel(level);
        LoggerTO result = new LoggerTO();
        BeanUtils.copyProperties((Object)syncopeLogger, (Object)result);
        this.auditManager.audit(AuditElements.Category.logger, (Enum<?>)AuditElements.LoggerSubCategory.setLevel, AuditElements.Result.success, String.format("Successfully set level %s to logger %s (%s)", level, name, expectedType));
        return result;
    }

    @PreAuthorize(value="hasRole('LOG_SET_LEVEL')")
    @RequestMapping(method={RequestMethod.POST}, value={"/log/{name}/{level}"})
    public LoggerTO setLogLevel(@PathVariable(value="name") String name, @PathVariable(value="level") Level level) {
        return this.setLevel(name, level, SyncopeLoggerType.LOG);
    }

    @PreAuthorize(value="hasRole('AUDIT_ENABLE')")
    @RequestMapping(method={RequestMethod.PUT}, value={"/audit/enable"})
    public void enableAudit(@RequestBody AuditLoggerName auditLoggerName) {
        try {
            this.setLevel(auditLoggerName.toLoggerName(), Level.DEBUG, SyncopeLoggerType.AUDIT);
        }
        catch (IllegalArgumentException e) {
            SyncopeClientCompositeErrorException sccee = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
            SyncopeClientException sce = new SyncopeClientException(SyncopeClientExceptionType.InvalidLogger);
            sce.addElement(e.getMessage());
            sccee.addException(sce);
            throw sccee;
        }
    }

    private LoggerTO delete(String name, SyncopeLoggerType expectedType) throws NotFoundException {
        SyncopeLogger syncopeLogger = this.loggerDAO.find(name);
        if (syncopeLogger == null) {
            throw new NotFoundException("Logger " + name);
        }
        if (expectedType != syncopeLogger.getType()) {
            this.throwInvalidLogger(expectedType);
        }
        LoggerTO loggerToDelete = new LoggerTO();
        BeanUtils.copyProperties((Object)syncopeLogger, (Object)loggerToDelete);
        this.loggerDAO.delete(syncopeLogger);
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = lc.getLogger(name);
        logger.setLevel(Level.OFF);
        this.auditManager.audit(AuditElements.Category.logger, (Enum<?>)AuditElements.LoggerSubCategory.setLevel, AuditElements.Result.success, String.format("Successfully deleted logger %s (%s)", name, expectedType));
        return loggerToDelete;
    }

    @PreAuthorize(value="hasRole('LOG_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/log/delete/{name}"})
    public LoggerTO deleteLog(@PathVariable(value="name") String name) throws NotFoundException {
        return this.delete(name, SyncopeLoggerType.LOG);
    }

    @PreAuthorize(value="hasRole('AUDIT_DISABLE')")
    @RequestMapping(method={RequestMethod.PUT}, value={"/audit/disable"})
    public void disableAudit(@RequestBody AuditLoggerName auditLoggerName) {
        try {
            this.delete(auditLoggerName.toLoggerName(), SyncopeLoggerType.AUDIT);
        }
        catch (NotFoundException e) {
            LOG.debug("Ignoring disable of non existing logger {}", (Object)auditLoggerName.toLoggerName());
        }
        catch (IllegalArgumentException e) {
            SyncopeClientCompositeErrorException sccee = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
            SyncopeClientException sce = new SyncopeClientException(SyncopeClientExceptionType.InvalidLogger);
            sce.addElement(e.getMessage());
            sccee.addException(sce);
            throw sccee;
        }
    }
}

