/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.util.ArrayList;
import java.util.List;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletResponse;
import org.apache.syncope.client.to.DerivedSchemaTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.persistence.beans.AbstractDerSchema;
import org.apache.syncope.core.persistence.dao.DerSchemaDAO;
import org.apache.syncope.core.rest.controller.AbstractController;
import org.apache.syncope.core.rest.data.DerivedSchemaDataBinder;
import org.apache.syncope.types.AuditElements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/derivedSchema"})
public class DerivedSchemaController
extends AbstractController {
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private DerSchemaDAO derivedSchemaDAO;
    @Autowired
    private DerivedSchemaDataBinder derivedSchemaDataBinder;

    @PreAuthorize(value="hasRole('SCHEMA_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/{kind}/create"})
    public DerivedSchemaTO create(HttpServletResponse response, @RequestBody DerivedSchemaTO derivedSchemaTO, @PathVariable(value="kind") String kind) throws SyncopeClientCompositeErrorException {
        AbstractDerSchema derivedSchema = this.derivedSchemaDAO.save(this.derivedSchemaDataBinder.create(derivedSchemaTO, (AbstractDerSchema)this.getAttributableUtil(kind).newDerivedSchema()));
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.createDerived, AuditElements.Result.success, "Successfully created derived schema: " + kind + "/" + derivedSchema.getName());
        response.setStatus(201);
        return this.derivedSchemaDataBinder.getDerivedSchemaTO(derivedSchema);
    }

    @PreAuthorize(value="hasRole('SCHEMA_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/{kind}/delete/{schema}"})
    public DerivedSchemaTO delete(@PathVariable(value="kind") String kind, @PathVariable(value="schema") String derivedSchemaName) throws NotFoundException {
        Class reference = this.getAttributableUtil(kind).derivedSchemaClass();
        Object derivedSchema = this.derivedSchemaDAO.find(derivedSchemaName, reference);
        if (derivedSchema == null) {
            throw new NotFoundException("Derived schema '" + derivedSchemaName + "'");
        }
        DerivedSchemaTO schemaToDelete = this.derivedSchemaDataBinder.getDerivedSchemaTO(derivedSchema);
        this.derivedSchemaDAO.delete(derivedSchemaName, this.getAttributableUtil(kind));
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.deleteDerived, AuditElements.Result.success, "Successfully deleted derived schema: " + kind + "/" + ((AbstractDerSchema)derivedSchema).getName());
        return schemaToDelete;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{kind}/list"})
    public List<DerivedSchemaTO> list(@PathVariable(value="kind") String kind) {
        Class reference = this.getAttributableUtil(kind).derivedSchemaClass();
        List derivedAttributeSchemas = this.derivedSchemaDAO.findAll(reference);
        ArrayList<DerivedSchemaTO> derivedSchemaTOs = new ArrayList<DerivedSchemaTO>(derivedAttributeSchemas.size());
        for (AbstractDerSchema derivedSchema : derivedAttributeSchemas) {
            derivedSchemaTOs.add(this.derivedSchemaDataBinder.getDerivedSchemaTO(derivedSchema));
        }
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.listDerived, AuditElements.Result.success, "Successfully listed all derived schemas: " + kind + "/" + derivedSchemaTOs.size());
        return derivedSchemaTOs;
    }

    @PreAuthorize(value="hasRole('SCHEMA_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/{kind}/read/{derivedSchema}"})
    public DerivedSchemaTO read(@PathVariable(value="kind") String kind, @PathVariable(value="derivedSchema") String derivedSchemaName) throws NotFoundException {
        Class reference = this.getAttributableUtil(kind).derivedSchemaClass();
        Object derivedSchema = this.derivedSchemaDAO.find(derivedSchemaName, reference);
        if (derivedSchema == null) {
            throw new NotFoundException("Derived schema '" + derivedSchemaName + "'");
        }
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.readDerived, AuditElements.Result.success, "Successfully read derived schema: " + kind + "/" + ((AbstractDerSchema)derivedSchema).getName());
        return this.derivedSchemaDataBinder.getDerivedSchemaTO(derivedSchema);
    }

    @PreAuthorize(value="hasRole('SCHEMA_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/{kind}/update"})
    public DerivedSchemaTO update(@RequestBody DerivedSchemaTO derivedSchemaTO, @PathVariable(value="kind") String kind) throws NotFoundException {
        Class reference = this.getAttributableUtil(kind).derivedSchemaClass();
        Object derivedSchema = this.derivedSchemaDAO.find(derivedSchemaTO.getName(), reference);
        if (derivedSchema == null) {
            throw new NotFoundException("Derived schema '" + derivedSchemaTO.getName() + "'");
        }
        derivedSchema = this.derivedSchemaDataBinder.update(derivedSchemaTO, (AbstractDerSchema)derivedSchema);
        derivedSchema = this.derivedSchemaDAO.save(derivedSchema);
        this.auditManager.audit(AuditElements.Category.schema, (Enum<?>)AuditElements.SchemaSubCategory.updateDerived, AuditElements.Result.success, "Successfully updated derived schema: " + kind + "/" + ((AbstractDerSchema)derivedSchema).getName());
        return this.derivedSchemaDataBinder.getDerivedSchemaTO(derivedSchema);
    }
}

