/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javassist.NotFoundException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.syncope.client.to.ConnBundleTO;
import org.apache.syncope.client.to.ConnInstanceTO;
import org.apache.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.apache.syncope.client.validation.SyncopeClientException;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.init.ConnInstanceLoader;
import org.apache.syncope.core.persistence.beans.ConnInstance;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.dao.MissingConfKeyException;
import org.apache.syncope.core.persistence.dao.ResourceDAO;
import org.apache.syncope.core.propagation.ConnectorFacadeProxy;
import org.apache.syncope.core.rest.controller.AbstractController;
import org.apache.syncope.core.rest.data.ConnInstanceDataBinder;
import org.apache.syncope.core.util.ConnBundleManager;
import org.apache.syncope.types.AuditElements;
import org.apache.syncope.types.ConnConfPropSchema;
import org.apache.syncope.types.ConnConfProperty;
import org.apache.syncope.types.SyncopeClientExceptionType;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.api.ConnectorInfoManager;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.impl.api.ConfigurationPropertyImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/connector"})
public class ConnInstanceController
extends AbstractController {
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private ResourceDAO resourceDAO;
    @Autowired
    private ConnInstanceDAO connInstanceDAO;
    @Autowired
    private ConnInstanceDataBinder binder;
    @Autowired
    private ConnBundleManager bundleManager;
    @Autowired
    private ConnInstanceLoader connLoader;

    @PreAuthorize(value="hasRole('CONNECTOR_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/create"})
    public ConnInstanceTO create(HttpServletResponse response, @RequestBody ConnInstanceTO connectorTO) throws SyncopeClientCompositeErrorException, NotFoundException {
        LOG.debug("ConnInstance create called with configuration {}", (Object)connectorTO);
        ConnInstance connInstance = this.binder.getConnInstance(connectorTO);
        try {
            connInstance = this.connInstanceDAO.save(connInstance);
            this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.create, AuditElements.Result.success, "Successfully created connector instance: " + connInstance.getDisplayName());
        }
        catch (Exception e) {
            this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.create, AuditElements.Result.failure, "Could not create connector instance: " + connectorTO.getDisplayName(), e);
            SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
            SyncopeClientException invalidConnInstance = new SyncopeClientException(SyncopeClientExceptionType.InvalidConnInstance);
            invalidConnInstance.addElement(e.getMessage());
            scce.addException(invalidConnInstance);
            throw scce;
        }
        response.setStatus(201);
        return this.binder.getConnInstanceTO(connInstance);
    }

    @PreAuthorize(value="hasRole('CONNECTOR_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/update"})
    public ConnInstanceTO update(@RequestBody ConnInstanceTO connectorTO) throws SyncopeClientCompositeErrorException, NotFoundException {
        LOG.debug("Connector update called with configuration {}", (Object)connectorTO);
        ConnInstance connInstance = this.binder.updateConnInstance(connectorTO.getId(), connectorTO);
        try {
            connInstance = this.connInstanceDAO.save(connInstance);
            this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.update, AuditElements.Result.success, "Successfully update connector instance: " + connInstance.getDisplayName());
        }
        catch (Exception e) {
            this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.create, AuditElements.Result.failure, "Could not update connector instance: " + connectorTO.getDisplayName(), e);
            SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
            SyncopeClientException invalidConnInstance = new SyncopeClientException(SyncopeClientExceptionType.InvalidConnInstance);
            invalidConnInstance.addElement(e.getMessage());
            scce.addException(invalidConnInstance);
            throw scce;
        }
        return this.binder.getConnInstanceTO(connInstance);
    }

    @PreAuthorize(value="hasRole('CONNECTOR_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/delete/{connectorId}"})
    public ConnInstanceTO delete(@PathVariable(value="connectorId") Long connectorId) throws NotFoundException {
        ConnInstance connInstance = this.connInstanceDAO.find(connectorId);
        if (connInstance == null) {
            throw new NotFoundException("Connector '" + connectorId + "'");
        }
        if (!connInstance.getResources().isEmpty()) {
            SyncopeClientCompositeErrorException scce = new SyncopeClientCompositeErrorException(HttpStatus.BAD_REQUEST);
            SyncopeClientException invalidConnInstance = new SyncopeClientException(SyncopeClientExceptionType.ExistingResource);
            for (ExternalResource resource : connInstance.getResources()) {
                invalidConnInstance.addElement(resource.getName());
            }
            scce.addException(invalidConnInstance);
            throw scce;
        }
        ConnInstanceTO connToDelete = this.binder.getConnInstanceTO(connInstance);
        this.connInstanceDAO.delete(connectorId);
        this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.delete, AuditElements.Result.success, "Successfully deleted connector instance: " + connectorId);
        return connToDelete;
    }

    @PreAuthorize(value="hasRole('CONNECTOR_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/list"})
    @Transactional(readOnly=true)
    public List<ConnInstanceTO> list(@RequestParam(value="lang", required=false) String lang) {
        if (StringUtils.isBlank((String)lang)) {
            CurrentLocale.set((Locale)Locale.ENGLISH);
        } else {
            CurrentLocale.set((Locale)new Locale(lang));
        }
        List<ConnInstance> connInstances = this.connInstanceDAO.findAll();
        ArrayList<ConnInstanceTO> connInstanceTOs = new ArrayList<ConnInstanceTO>();
        for (ConnInstance connector : connInstances) {
            try {
                connInstanceTOs.add(this.binder.getConnInstanceTO(connector));
            }
            catch (NotFoundException e) {
                LOG.error("Connector '{}#{}' not found", (Object)connector.getBundleName(), (Object)connector.getVersion());
            }
        }
        this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.list, AuditElements.Result.success, "Successfully listed all connectors: " + connInstanceTOs.size());
        return connInstanceTOs;
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/read/{connectorId}"})
    @Transactional(readOnly=true)
    public ConnInstanceTO read(@PathVariable(value="connectorId") Long connectorId) throws NotFoundException {
        ConnInstance connInstance = this.connInstanceDAO.find(connectorId);
        if (connInstance == null) {
            throw new NotFoundException("Connector '" + connectorId + "'");
        }
        this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.read, AuditElements.Result.success, "Successfully read connector: " + connInstance.getDisplayName());
        return this.binder.getConnInstanceTO(connInstance);
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/bundle/list"})
    @Transactional(readOnly=true)
    public List<ConnBundleTO> getBundles(@RequestParam(value="lang", required=false) String lang) throws NotFoundException, MissingConfKeyException {
        if (StringUtils.isBlank((String)lang)) {
            CurrentLocale.set((Locale)Locale.ENGLISH);
        } else {
            CurrentLocale.set((Locale)new Locale(lang));
        }
        ConnectorInfoManager manager = this.bundleManager.getConnectorManager();
        List bundles = manager.getConnectorInfos();
        if (LOG.isDebugEnabled() && bundles != null) {
            LOG.debug("#Bundles: {}", (Object)bundles.size());
            for (ConnectorInfo bundle : bundles) {
                LOG.debug("Bundle: {}", (Object)bundle.getConnectorDisplayName());
            }
        }
        ArrayList<ConnBundleTO> connectorBundleTOs = new ArrayList<ConnBundleTO>();
        if (bundles != null) {
            for (ConnectorInfo bundle : bundles) {
                ConnBundleTO connectorBundleTO = new ConnBundleTO();
                connectorBundleTO.setDisplayName(bundle.getConnectorDisplayName());
                ConnectorKey key = bundle.getConnectorKey();
                LOG.debug("\nBundle name: {}\nBundle version: {}\nBundle class: {}", new Object[]{key.getBundleName(), key.getBundleVersion(), key.getConnectorName()});
                connectorBundleTO.setBundleName(key.getBundleName());
                connectorBundleTO.setConnectorName(key.getConnectorName());
                connectorBundleTO.setVersion(key.getBundleVersion());
                ConfigurationProperties properties = this.bundleManager.getConfigurationProperties(bundle);
                for (String propName : properties.getPropertyNames()) {
                    ConnConfPropSchema connConfPropSchema = new ConnConfPropSchema();
                    ConfigurationPropertyImpl configurationProperty = (ConfigurationPropertyImpl)properties.getProperty(propName);
                    connConfPropSchema.setName(configurationProperty.getName());
                    connConfPropSchema.setDisplayName(configurationProperty.getDisplayName(propName));
                    connConfPropSchema.setHelpMessage(configurationProperty.getHelpMessage(propName));
                    connConfPropSchema.setRequired(configurationProperty.isRequired());
                    connConfPropSchema.setType(configurationProperty.getType().getName());
                    connConfPropSchema.setOrder(configurationProperty.getOrder());
                    connConfPropSchema.setConfidential(configurationProperty.isConfidential());
                    connectorBundleTO.addProperty(connConfPropSchema);
                }
                LOG.debug("Bundle properties: {}", (Object)connectorBundleTO.getProperties());
                connectorBundleTOs.add(connectorBundleTO);
            }
        }
        this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.getBundles, AuditElements.Result.success, "Successfully listed all bundles: " + connectorBundleTOs.size());
        return connectorBundleTOs;
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    @RequestMapping(method={RequestMethod.POST}, value={"/schema/list"})
    @Transactional(readOnly=true)
    public List<String> getSchemaNames(HttpServletResponse response, @RequestBody ConnInstanceTO connectorTO, @RequestParam(required=false, value="showall", defaultValue="false") boolean showall) throws NotFoundException {
        ConnInstance connInstance = this.connInstanceDAO.find(connectorTO.getId());
        if (connInstance == null) {
            throw new NotFoundException("Connector '" + connectorTO.getId() + "'");
        }
        Set<ConnConfProperty> conf = this.mergeConnConfProperties(connectorTO.getConfiguration(), connInstance.getConfiguration());
        ArrayList<String> result = new ArrayList<String>(this.connLoader.createConnectorBean(connInstance, conf).getSchema(showall));
        Collections.sort(result);
        this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.getSchemaNames, AuditElements.Result.success, "Successfully listed all schema names (" + result.size() + ") for connector " + connInstance.getDisplayName());
        return result;
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/{connectorId}/configurationProperty/list"})
    @Transactional(readOnly=true)
    public List<ConnConfProperty> getConfigurationProperties(@PathVariable(value="connectorId") Long connectorId) throws NotFoundException {
        ConnInstance connInstance = this.connInstanceDAO.find(connectorId);
        if (connInstance == null) {
            throw new NotFoundException("Connector '" + connectorId + "'");
        }
        ArrayList<ConnConfProperty> result = new ArrayList<ConnConfProperty>(connInstance.getConfiguration());
        this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.getConfigurationProperties, AuditElements.Result.success, "Successfully listed all conf properties (" + result.size() + ") for connector " + connInstance.getDisplayName());
        return result;
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    @RequestMapping(method={RequestMethod.POST}, value={"/check"})
    @Transactional(readOnly=true)
    public ModelAndView check(HttpServletResponse response, @RequestBody ConnInstanceTO connectorTO) throws SyncopeClientCompositeErrorException, NotFoundException {
        boolean result;
        ConnectorFacadeProxy connector = new ConnectorFacadeProxy(this.binder.getConnInstance(connectorTO), this.bundleManager);
        try {
            connector.test();
            result = true;
            this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.check, AuditElements.Result.success, "Successfully checked connector: " + connectorTO);
        }
        catch (Exception ex) {
            this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.check, AuditElements.Result.failure, "Unsuccessful check for connector: " + connectorTO, ex);
            LOG.error("Test connection failure {}", (Throwable)ex);
            result = false;
        }
        return new ModelAndView().addObject((Object)result);
    }

    private Set<ConnConfProperty> mergeConnConfProperties(Set<ConnConfProperty> primary, Set<ConnConfProperty> secondary) {
        HashSet<ConnConfProperty> conf = new HashSet<ConnConfProperty>();
        HashSet<String> propertyNames = new HashSet<String>();
        for (ConnConfProperty prop : primary) {
            if (propertyNames.contains(prop.getSchema().getName())) continue;
            conf.add(prop);
            propertyNames.add(prop.getSchema().getName());
        }
        for (ConnConfProperty prop : secondary) {
            if (propertyNames.contains(prop.getSchema().getName())) continue;
            conf.add(prop);
            propertyNames.add(prop.getSchema().getName());
        }
        return conf;
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/{resourceName}/connectorBean"})
    @Transactional(readOnly=true)
    public ConnInstanceTO readConnectorBean(@PathVariable(value="resourceName") String resourceName) throws NotFoundException {
        ExternalResource resource = this.resourceDAO.find(resourceName);
        if (resource == null) {
            throw new NotFoundException("Resource '" + resourceName + "'");
        }
        ConnectorFacadeProxy connector = this.connLoader.getConnector(resource);
        this.auditManager.audit(AuditElements.Category.connector, (Enum<?>)AuditElements.ConnectorSubCategory.readConnectorBean, AuditElements.Result.success, "Successfully read connector for resource: " + resourceName);
        return this.binder.getConnInstanceTO(connector.getActiveConnInstance());
    }
}

