/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.syncope.client.to.ConfigurationTO;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.init.ImplementationClassNamesLoader;
import org.apache.syncope.core.persistence.beans.SyncopeConf;
import org.apache.syncope.core.persistence.dao.ConfDAO;
import org.apache.syncope.core.persistence.dao.MissingConfKeyException;
import org.apache.syncope.core.persistence.validation.attrvalue.Validator;
import org.apache.syncope.core.rest.controller.AbstractController;
import org.apache.syncope.core.rest.data.ConfigurationDataBinder;
import org.apache.syncope.core.util.ImportExport;
import org.apache.syncope.types.AuditElements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/configuration"})
public class ConfigurationController
extends AbstractController {
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private ConfigurationDataBinder configurationDataBinder;
    @Autowired
    private ImportExport importExport;
    @Autowired
    private ImplementationClassNamesLoader classNamesLoader;
    @Autowired
    private ResourcePatternResolver resResolver;

    @PreAuthorize(value="hasRole('CONFIGURATION_CREATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/create"})
    public ConfigurationTO create(HttpServletResponse response, @RequestBody ConfigurationTO configurationTO) {
        LOG.debug("Configuration create called with parameters {}", (Object)configurationTO);
        SyncopeConf conf = this.configurationDataBinder.createSyncopeConfiguration(configurationTO);
        conf = this.confDAO.save(conf);
        this.auditManager.audit(AuditElements.Category.configuration, (Enum<?>)AuditElements.ConfigurationSubCategory.create, AuditElements.Result.success, "Successfully created conf: " + conf.getKey());
        response.setStatus(201);
        return this.configurationDataBinder.getConfigurationTO(conf);
    }

    @PreAuthorize(value="hasRole('CONFIGURATION_DELETE')")
    @RequestMapping(method={RequestMethod.GET}, value={"/delete/{key}"})
    public ConfigurationTO delete(@PathVariable(value="key") String key) throws MissingConfKeyException {
        SyncopeConf conf = this.confDAO.find(key);
        ConfigurationTO confToDelete = this.configurationDataBinder.getConfigurationTO(conf);
        this.confDAO.delete(key);
        this.auditManager.audit(AuditElements.Category.configuration, (Enum<?>)AuditElements.ConfigurationSubCategory.delete, AuditElements.Result.success, "Successfully deleted conf: " + key);
        return confToDelete;
    }

    @PreAuthorize(value="hasRole('CONFIGURATION_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/list"})
    public List<ConfigurationTO> list(HttpServletRequest request) {
        List<SyncopeConf> configurations = this.confDAO.findAll();
        ArrayList<ConfigurationTO> configurationTOs = new ArrayList<ConfigurationTO>(configurations.size());
        for (SyncopeConf configuration : configurations) {
            configurationTOs.add(this.configurationDataBinder.getConfigurationTO(configuration));
        }
        this.auditManager.audit(AuditElements.Category.configuration, (Enum<?>)AuditElements.ConfigurationSubCategory.list, AuditElements.Result.success, "Successfully listed all confs: " + configurationTOs.size());
        return configurationTOs;
    }

    @PreAuthorize(value="hasRole('CONFIGURATION_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/read/{key}"})
    public ConfigurationTO read(HttpServletResponse response, @PathVariable(value="key") String key) throws MissingConfKeyException {
        ConfigurationTO result;
        try {
            SyncopeConf conf = this.confDAO.find(key);
            result = this.configurationDataBinder.getConfigurationTO(conf);
            this.auditManager.audit(AuditElements.Category.configuration, (Enum<?>)AuditElements.ConfigurationSubCategory.read, AuditElements.Result.success, "Successfully read conf: " + key);
        }
        catch (MissingConfKeyException e) {
            LOG.error("Could not find configuration key '" + key + "', returning null");
            result = new ConfigurationTO();
            result.setKey(key);
            this.auditManager.audit(AuditElements.Category.configuration, (Enum<?>)AuditElements.ConfigurationSubCategory.read, AuditElements.Result.failure, "Could not find conf: " + key);
        }
        return result;
    }

    @PreAuthorize(value="hasRole('CONFIGURATION_UPDATE')")
    @RequestMapping(method={RequestMethod.POST}, value={"/update"})
    public ConfigurationTO update(HttpServletResponse response, @RequestBody ConfigurationTO configurationTO) throws MissingConfKeyException {
        SyncopeConf conf = this.confDAO.find(configurationTO.getKey());
        conf.setValue(configurationTO.getValue());
        this.auditManager.audit(AuditElements.Category.configuration, (Enum<?>)AuditElements.ConfigurationSubCategory.update, AuditElements.Result.success, "Successfully updated conf: " + conf.getKey());
        return this.configurationDataBinder.getConfigurationTO(conf);
    }

    @PreAuthorize(value="hasRole('CONFIGURATION_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/validators"})
    public ModelAndView getValidators() {
        Set<String> validators = this.classNamesLoader.getClassNames(ImplementationClassNamesLoader.Type.VALIDATOR);
        this.auditManager.audit(AuditElements.Category.configuration, (Enum<?>)AuditElements.ConfigurationSubCategory.getValidators, AuditElements.Result.success, "Successfully listed all validators: " + validators.size());
        return new ModelAndView().addObject(validators);
    }

    @PreAuthorize(value="hasRole('CONFIGURATION_LIST')")
    @RequestMapping(method={RequestMethod.GET}, value={"/mailTemplates"})
    public ModelAndView getMailTemplates() {
        HashSet<String> htmlTemplates = new HashSet<String>();
        HashSet<String> textTemplates = new HashSet<String>();
        try {
            for (Resource resource : this.resResolver.getResources("classpath:/mailTemplates/*.vm")) {
                String template = resource.getURL().toExternalForm();
                if (template.endsWith(".html.vm")) {
                    htmlTemplates.add(template.substring(template.indexOf("mailTemplates/") + 14, template.indexOf(".html.vm")));
                    continue;
                }
                if (template.endsWith(".txt.vm")) {
                    textTemplates.add(template.substring(template.indexOf("mailTemplates/") + 14, template.indexOf(".txt.vm")));
                    continue;
                }
                LOG.warn("Unexpected template found: {}, ignoring...", (Object)template);
            }
        }
        catch (IOException e) {
            LOG.error("While searching for class implementing {}", (Object)Validator.class.getName(), (Object)e);
        }
        htmlTemplates.retainAll(textTemplates);
        this.auditManager.audit(AuditElements.Category.configuration, (Enum<?>)AuditElements.ConfigurationSubCategory.getMailTemplates, AuditElements.Result.success, "Successfully listed all mail templates: " + htmlTemplates.size());
        return new ModelAndView().addObject(htmlTemplates);
    }

    @PreAuthorize(value="hasRole('CONFIGURATION_READ')")
    @RequestMapping(method={RequestMethod.GET}, value={"/dbexport"})
    @Transactional(readOnly=true)
    public void dbExport(HttpServletResponse response) {
        response.setContentType("text/xml");
        response.setHeader("Content-Disposition", "attachment; filename=content.xml");
        try {
            this.importExport.export((OutputStream)response.getOutputStream());
            this.auditManager.audit(AuditElements.Category.configuration, (Enum<?>)AuditElements.ConfigurationSubCategory.dbExport, AuditElements.Result.success, "Successfully exported database content");
            LOG.debug("Database content successfully exported");
        }
        catch (Exception e) {
            this.auditManager.audit(AuditElements.Category.configuration, (Enum<?>)AuditElements.ConfigurationSubCategory.dbExport, AuditElements.Result.failure, "Could not export database content", e);
            LOG.error("While exporting database content", (Throwable)e);
        }
    }
}

