/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.syncope.core.audit.AuditManager;
import org.apache.syncope.core.persistence.beans.Entitlement;
import org.apache.syncope.core.persistence.dao.EntitlementDAO;
import org.apache.syncope.core.rest.controller.AbstractController;
import org.apache.syncope.core.util.EntitlementUtil;
import org.apache.syncope.types.AuditElements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/auth"})
public class AuthenticationController
extends AbstractController {
    @Autowired
    private AuditManager auditManager;
    @Autowired
    private EntitlementDAO entitlementDAO;

    @RequestMapping(method={RequestMethod.GET}, value={"/allentitlements"})
    public List<String> listEntitlements() {
        List<Entitlement> entitlements = this.entitlementDAO.findAll();
        ArrayList<String> result = new ArrayList<String>(entitlements.size());
        for (Entitlement entitlement : entitlements) {
            result.add(entitlement.getName());
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/entitlements"})
    public Set<String> getEntitlements() {
        Set<String> result = EntitlementUtil.getOwnedEntitlementNames();
        this.auditManager.audit(AuditElements.Category.authentication, (Enum<?>)AuditElements.AuthenticationSubCategory.getEntitlements, AuditElements.Result.success, "Owned entitlements: " + result.toString());
        return result;
    }
}

