/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.controller;

import org.apache.syncope.client.to.PropagationTaskTO;
import org.apache.syncope.client.to.SchedTaskTO;
import org.apache.syncope.client.to.SyncTaskTO;
import org.apache.syncope.client.to.TaskTO;
import org.apache.syncope.core.persistence.beans.NotificationTask;
import org.apache.syncope.core.persistence.beans.PropagationTask;
import org.apache.syncope.core.persistence.beans.SchedTask;
import org.apache.syncope.core.persistence.beans.SyncTask;
import org.apache.syncope.core.persistence.beans.Task;
import org.apache.syncope.core.util.AttributableUtil;
import org.apache.syncope.core.util.TaskUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public abstract class AbstractController {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractController.class);

    protected AttributableUtil getAttributableUtil(String kind) {
        AttributableUtil result = null;
        try {
            result = AttributableUtil.valueOf(kind.toUpperCase());
        }
        catch (Exception e) {
            LOG.error("Attributable not supported: " + kind);
            throw new TypeMismatchException((Object)kind, AttributableUtil.class, (Throwable)e);
        }
        return result;
    }

    protected TaskUtil getTaskUtil(String kind) {
        TaskUtil result = null;
        try {
            result = TaskUtil.valueOf(kind.toUpperCase());
        }
        catch (Exception e) {
            LOG.error("Task not supported: " + kind);
            throw new TypeMismatchException((Object)kind, TaskUtil.class, (Throwable)e);
        }
        return result;
    }

    protected TaskUtil getTaskUtil(Task task) {
        TaskUtil result;
        TaskUtil taskUtil = task instanceof PropagationTask ? TaskUtil.PROPAGATION : (task instanceof NotificationTask ? TaskUtil.NOTIFICATION : (task instanceof SyncTask ? TaskUtil.SYNC : (result = task instanceof SchedTask ? TaskUtil.SCHED : null)));
        if (result == null) {
            LOG.error("Task not supported: " + task.getClass().getName());
            throw new TypeMismatchException((Object)task.getClass().getName(), TaskUtil.class);
        }
        return result;
    }

    protected TaskUtil getTaskUtil(TaskTO taskTO) {
        TaskUtil result;
        TaskUtil taskUtil = taskTO instanceof PropagationTaskTO ? TaskUtil.PROPAGATION : (taskTO instanceof SyncTaskTO ? TaskUtil.SYNC : (result = taskTO instanceof SchedTaskTO ? TaskUtil.SCHED : null));
        if (result == null) {
            LOG.error("Task not supported: " + taskTO.getClass().getName());
            throw new TypeMismatchException((Object)taskTO.getClass().getName(), TaskUtil.class);
        }
        return result;
    }
}

