/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.report;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.client.report.UserReportletConf;
import org.apache.syncope.client.to.AbstractAttributableTO;
import org.apache.syncope.client.to.AttributeTO;
import org.apache.syncope.client.to.MembershipTO;
import org.apache.syncope.client.to.UserTO;
import org.apache.syncope.core.persistence.beans.membership.Membership;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.dao.EntitlementDAO;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.persistence.dao.UserSearchDAO;
import org.apache.syncope.core.report.AbstractReportlet;
import org.apache.syncope.core.report.ReportException;
import org.apache.syncope.core.report.ReportletConfClass;
import org.apache.syncope.core.rest.data.RoleDataBinder;
import org.apache.syncope.core.rest.data.UserDataBinder;
import org.apache.syncope.core.util.EntitlementUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@ReportletConfClass(value=UserReportletConf.class)
public class UserReportlet
extends AbstractReportlet<UserReportletConf> {
    private static final int PAGE_SIZE = 10;
    @Autowired
    private EntitlementDAO entitlementDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private UserSearchDAO searchDAO;
    @Autowired
    private UserDataBinder userDataBinder;
    @Autowired
    private RoleDataBinder roleDataBinder;

    private List<SyncopeUser> getPagedUsers(int page) {
        Set<Long> adminRoleIds = EntitlementUtil.getRoleIds(this.entitlementDAO.findAll());
        return ((UserReportletConf)this.conf).getMatchingCond() == null ? this.userDAO.findAll(adminRoleIds, page, 10) : this.searchDAO.search(adminRoleIds, ((UserReportletConf)this.conf).getMatchingCond(), page, 10);
    }

    private int count() {
        Set<Long> adminRoleIds = EntitlementUtil.getRoleIds(this.entitlementDAO.findAll());
        return ((UserReportletConf)this.conf).getMatchingCond() == null ? this.userDAO.count(adminRoleIds) : this.searchDAO.count(adminRoleIds, ((UserReportletConf)this.conf).getMatchingCond());
    }

    private void doExtractResources(ContentHandler handler, AbstractAttributableTO attributableTO) throws SAXException {
        if (attributableTO.getResources().isEmpty()) {
            LOG.debug("No resources found for {}[{}]", (Object)attributableTO.getClass().getSimpleName(), (Object)attributableTO.getId());
        } else {
            AttributesImpl atts = new AttributesImpl();
            handler.startElement("", "", "resources", null);
            for (String resourceName : attributableTO.getResources()) {
                atts.clear();
                atts.addAttribute("", "", "name", "xsd:string", resourceName);
                handler.startElement("", "", "resource", atts);
                handler.endElement("", "", "resource");
            }
            handler.endElement("", "", "resources");
        }
    }

    private void doExtractAttributes(ContentHandler handler, AbstractAttributableTO attributableTO, Collection<String> attrs, Collection<String> derAttrs, Collection<String> virAttrs) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (!attrs.isEmpty()) {
            Map attrMap = attributableTO.getAttributeMap();
            handler.startElement("", "", "attributes", null);
            for (String attrName : attrs) {
                atts.clear();
                atts.addAttribute("", "", "name", "xsd:string", attrName);
                handler.startElement("", "", "attribute", atts);
                if (attrMap.containsKey(attrName)) {
                    for (String value : ((AttributeTO)attrMap.get(attrName)).getValues()) {
                        handler.startElement("", "", "value", null);
                        handler.characters(value.toCharArray(), 0, value.length());
                        handler.endElement("", "", "value");
                    }
                } else {
                    LOG.debug("{} not found for {}[{}]", new Object[]{attrName, attributableTO.getClass().getSimpleName(), attributableTO.getId()});
                }
                handler.endElement("", "", "attribute");
            }
            handler.endElement("", "", "attributes");
        }
        if (!derAttrs.isEmpty()) {
            Map derAttrMap = attributableTO.getDerivedAttributeMap();
            handler.startElement("", "", "derivedAttributes", null);
            for (String attrName : derAttrs) {
                atts.clear();
                atts.addAttribute("", "", "name", "xsd:string", attrName);
                handler.startElement("", "", "derivedAttribute", atts);
                if (derAttrMap.containsKey(attrName)) {
                    for (String value : ((AttributeTO)derAttrMap.get(attrName)).getValues()) {
                        handler.startElement("", "", "value", null);
                        handler.characters(value.toCharArray(), 0, value.length());
                        handler.endElement("", "", "value");
                    }
                } else {
                    LOG.debug("{} not found for {}[{}]", new Object[]{attrName, attributableTO.getClass().getSimpleName(), attributableTO.getId()});
                }
                handler.endElement("", "", "derivedAttribute");
            }
            handler.endElement("", "", "derivedAttributes");
        }
        if (!virAttrs.isEmpty()) {
            Map virAttrMap = attributableTO.getVirtualAttributeMap();
            handler.startElement("", "", "virtualAttributes", null);
            for (String attrName : virAttrs) {
                atts.clear();
                atts.addAttribute("", "", "name", "xsd:string", attrName);
                handler.startElement("", "", "virtualAttribute", atts);
                if (virAttrMap.containsKey(attrName)) {
                    for (String value : ((AttributeTO)virAttrMap.get(attrName)).getValues()) {
                        handler.startElement("", "", "value", null);
                        handler.characters(value.toCharArray(), 0, value.length());
                        handler.endElement("", "", "value");
                    }
                } else {
                    LOG.debug("{} not found for {}[{}]", new Object[]{attrName, attributableTO.getClass().getSimpleName(), attributableTO.getId()});
                }
                handler.endElement("", "", "virtualAttribute");
            }
            handler.endElement("", "", "virtualAttributes");
        }
    }

    private void doExtract(ContentHandler handler, List<SyncopeUser> users) throws SAXException, ReportException {
        AttributesImpl atts = new AttributesImpl();
        for (SyncopeUser user : users) {
            atts.clear();
            for (UserReportletConf.Feature feature : ((UserReportletConf)this.conf).getFeatures()) {
                String type = null;
                String value = null;
                switch (feature) {
                    case id: {
                        type = "xsd:long";
                        value = String.valueOf(user.getId());
                        break;
                    }
                    case username: {
                        type = "xsd:string";
                        value = user.getUsername();
                        break;
                    }
                    case workflowId: {
                        type = "xsd:long";
                        value = String.valueOf(user.getWorkflowId());
                        break;
                    }
                    case status: {
                        type = "xsd:string";
                        value = user.getStatus();
                        break;
                    }
                    case creationDate: {
                        type = "xsd:dateTime";
                        value = user.getCreationDate() == null ? "" : ((SimpleDateFormat)DATE_FORMAT.get()).format(user.getCreationDate());
                        break;
                    }
                    case lastLoginDate: {
                        type = "xsd:dateTime";
                        value = user.getLastLoginDate() == null ? "" : ((SimpleDateFormat)DATE_FORMAT.get()).format(user.getLastLoginDate());
                        break;
                    }
                    case changePwdDate: {
                        type = "xsd:dateTime";
                        value = user.getChangePwdDate() == null ? "" : ((SimpleDateFormat)DATE_FORMAT.get()).format(user.getChangePwdDate());
                        break;
                    }
                    case passwordHistorySize: {
                        type = "xsd:integer";
                        value = String.valueOf(user.getPasswordHistory().size());
                        break;
                    }
                    case failedLoginCount: {
                        type = "xsd:integer";
                        value = String.valueOf(user.getFailedLogins());
                        break;
                    }
                }
                if (type == null || value == null) continue;
                atts.addAttribute("", "", feature.name(), type, value);
            }
            handler.startElement("", "", "user", atts);
            UserTO userTO = this.userDataBinder.getUserTO(user);
            this.doExtractAttributes(handler, (AbstractAttributableTO)userTO, ((UserReportletConf)this.conf).getAttrs(), ((UserReportletConf)this.conf).getDerAttrs(), ((UserReportletConf)this.conf).getVirAttrs());
            if (((UserReportletConf)this.conf).getFeatures().contains(UserReportletConf.Feature.memberships)) {
                handler.startElement("", "", "memberships", null);
                for (MembershipTO memb : userTO.getMemberships()) {
                    atts.clear();
                    atts.addAttribute("", "", "id", "xsd:long", String.valueOf(memb.getId()));
                    atts.addAttribute("", "", "roleId", "xsd:long", String.valueOf(memb.getRoleId()));
                    atts.addAttribute("", "", "roleName", "xsd:string", String.valueOf(memb.getRoleName()));
                    handler.startElement("", "", "membership", atts);
                    this.doExtractAttributes(handler, (AbstractAttributableTO)memb, memb.getAttributeMap().keySet(), memb.getDerivedAttributeMap().keySet(), memb.getVirtualAttributeMap().keySet());
                    if (((UserReportletConf)this.conf).getFeatures().contains(UserReportletConf.Feature.resources)) {
                        Membership actualMemb = user.getMembership(memb.getRoleId());
                        if (actualMemb == null) {
                            LOG.warn("Unexpected: cannot find membership for role {} for user {}", (Object)memb.getRoleId(), (Object)user);
                        } else {
                            this.doExtractResources(handler, (AbstractAttributableTO)this.roleDataBinder.getRoleTO(actualMemb.getSyncopeRole()));
                        }
                    }
                    handler.endElement("", "", "membership");
                }
                handler.endElement("", "", "memberships");
            }
            if (((UserReportletConf)this.conf).getFeatures().contains(UserReportletConf.Feature.resources)) {
                this.doExtractResources(handler, (AbstractAttributableTO)userTO);
            }
            handler.endElement("", "", "user");
        }
    }

    @Override
    protected void doExtract(ContentHandler handler) throws SAXException, ReportException {
        for (int i = 1; i <= this.count() / 10 + 1; ++i) {
            this.doExtract(handler, this.getPagedUsers(i));
        }
    }
}

