/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.report;

import java.text.SimpleDateFormat;
import org.apache.syncope.client.SyncopeConstants;
import org.apache.syncope.client.report.AbstractReportletConf;
import org.apache.syncope.core.report.ReportException;
import org.apache.syncope.core.report.Reportlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractReportlet<T extends AbstractReportletConf>
implements Reportlet<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractReportlet.class);
    protected static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(SyncopeConstants.DEFAULT_DATE_PATTERN);
        }
    };
    protected T conf;

    public T getConf() {
        return this.conf;
    }

    @Override
    public void setConf(T conf) {
        this.conf = conf;
    }

    protected abstract void doExtract(ContentHandler var1) throws SAXException, ReportException;

    @Override
    @Transactional(readOnly=true)
    public void extract(ContentHandler handler) throws SAXException, ReportException {
        if (this.conf == null) {
            throw new ReportException(new IllegalArgumentException("No configuration provided"));
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "name", "xsd:string", this.conf.getName());
        atts.addAttribute("", "", "class", "xsd:string", this.getClass().getName());
        handler.startElement("", "", "reportlet", atts);
        this.doExtract(handler);
        handler.endElement("", "", "reportlet");
    }
}

