/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.propagation;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.NotFoundException;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.apache.syncope.client.mod.AttributeMod;
import org.apache.syncope.client.to.AttributeTO;
import org.apache.syncope.core.init.ConnInstanceLoader;
import org.apache.syncope.core.persistence.beans.AbstractAttrValue;
import org.apache.syncope.core.persistence.beans.AbstractAttributable;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.PropagationTask;
import org.apache.syncope.core.persistence.beans.SchemaMapping;
import org.apache.syncope.core.persistence.beans.TaskExec;
import org.apache.syncope.core.persistence.beans.membership.Membership;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.dao.ResourceDAO;
import org.apache.syncope.core.persistence.dao.SchemaDAO;
import org.apache.syncope.core.persistence.dao.TaskDAO;
import org.apache.syncope.core.persistence.dao.UserDAO;
import org.apache.syncope.core.propagation.ConnectorFacadeProxy;
import org.apache.syncope.core.propagation.PropagationByResource;
import org.apache.syncope.core.propagation.PropagationException;
import org.apache.syncope.core.propagation.PropagationHandler;
import org.apache.syncope.core.rest.data.UserDataBinder;
import org.apache.syncope.core.util.AttributableUtil;
import org.apache.syncope.core.util.JexlUtil;
import org.apache.syncope.core.util.SchemaMappingUtil;
import org.apache.syncope.core.workflow.WorkflowResult;
import org.apache.syncope.types.AttributableType;
import org.apache.syncope.types.IntMappingType;
import org.apache.syncope.types.PropagationMode;
import org.apache.syncope.types.PropagationOperation;
import org.apache.syncope.types.PropagationTaskExecStatus;
import org.apache.syncope.types.SchemaType;
import org.apache.syncope.types.TraceLevel;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Transactional(rollbackFor={Throwable.class})
public class PropagationManager {
    protected static final Logger LOG = LoggerFactory.getLogger(PropagationManager.class);
    @Autowired
    private ConnInstanceLoader connLoader;
    @Autowired
    private UserDataBinder userDataBinder;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private ResourceDAO resourceDAO;
    @Autowired
    private SchemaDAO schemaDAO;
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private JexlUtil jexlUtil;

    private SyncopeUser getSyncopeUser(Long userId) throws NotFoundException {
        SyncopeUser user = this.userDAO.find(userId);
        if (user == null) {
            throw new NotFoundException("User " + userId);
        }
        return user;
    }

    public List<PropagationTask> getCreateTaskIds(WorkflowResult<Map.Entry<Long, Boolean>> wfResult, String password, List<AttributeTO> vAttrs) throws NotFoundException {
        return this.getCreateTaskIds(wfResult, password, vAttrs, null);
    }

    public List<PropagationTask> getCreateTaskIds(WorkflowResult<Map.Entry<Long, Boolean>> wfResult, String password, List<AttributeTO> vAttrs, Set<String> syncResourceNames) throws NotFoundException {
        PropagationByResource propByRes;
        SyncopeUser user = this.getSyncopeUser(wfResult.getResult().getKey());
        if (vAttrs != null && !vAttrs.isEmpty()) {
            this.userDataBinder.fillVirtual(user, vAttrs, AttributableUtil.getInstance(AttributableType.USER));
        }
        if ((propByRes = wfResult.getPropByRes()) == null || propByRes.isEmpty()) {
            return Collections.emptyList();
        }
        if (syncResourceNames != null) {
            propByRes.get(PropagationOperation.CREATE).removeAll(syncResourceNames);
        }
        return this.provision(user, password, wfResult.getResult().getValue(), false, propByRes);
    }

    public List<PropagationTask> getUpdateTaskIds(SyncopeUser user, Boolean enable, Set<String> syncResourceNames) throws NotFoundException {
        return this.getUpdateTaskIds(user, null, null, null, null, enable, syncResourceNames);
    }

    public List<PropagationTask> getUpdateTaskIds(WorkflowResult<Map.Entry<Long, Boolean>> wfResult) throws NotFoundException {
        return this.getUpdateTaskIds(wfResult, null, null, null, null);
    }

    public List<PropagationTask> getUpdateTaskIds(WorkflowResult<Map.Entry<Long, Boolean>> wfResult, String password, Set<String> vAttrsToBeRemoved, Set<AttributeMod> vAttrsToBeUpdated) throws NotFoundException {
        return this.getUpdateTaskIds(wfResult, password, vAttrsToBeRemoved, vAttrsToBeUpdated, null);
    }

    public List<PropagationTask> getUpdateTaskIds(WorkflowResult<Map.Entry<Long, Boolean>> wfResult, String password, Set<String> vAttrsToBeRemoved, Set<AttributeMod> vAttrsToBeUpdated, Set<String> syncResourceNames) throws NotFoundException {
        SyncopeUser user = this.getSyncopeUser(wfResult.getResult().getKey());
        return this.getUpdateTaskIds(user, wfResult.getPropByRes(), password, vAttrsToBeRemoved, vAttrsToBeUpdated, wfResult.getResult().getValue(), syncResourceNames);
    }

    private List<PropagationTask> getUpdateTaskIds(SyncopeUser user, PropagationByResource propByRes, String password, Set<String> vAttrsToBeRemoved, Set<AttributeMod> vAttrsToBeUpdated, Boolean enable, Set<String> syncResourceNames) throws NotFoundException {
        PropagationByResource localPropByRes = this.userDataBinder.fillVirtual(user, vAttrsToBeRemoved == null ? Collections.EMPTY_SET : vAttrsToBeRemoved, vAttrsToBeUpdated == null ? Collections.EMPTY_SET : vAttrsToBeUpdated, AttributableUtil.getInstance(AttributableType.USER));
        if (propByRes != null && !propByRes.isEmpty()) {
            localPropByRes.merge(propByRes);
        } else {
            localPropByRes.addAll(PropagationOperation.UPDATE, user.getResourceNames());
        }
        if (syncResourceNames != null) {
            localPropByRes.get(PropagationOperation.CREATE).removeAll(syncResourceNames);
            localPropByRes.get(PropagationOperation.UPDATE).removeAll(syncResourceNames);
            localPropByRes.get(PropagationOperation.DELETE).removeAll(syncResourceNames);
        }
        return this.provision(user, password, enable, false, localPropByRes);
    }

    public List<PropagationTask> getDeleteTaskIds(Long userId) throws NotFoundException {
        return this.getDeleteTaskIds(userId, null);
    }

    public List<PropagationTask> getDeleteTaskIds(Long userId, String syncResourceName) throws NotFoundException {
        SyncopeUser user = this.getSyncopeUser(userId);
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(PropagationOperation.DELETE, user.getResourceNames());
        if (syncResourceName != null) {
            propByRes.get(PropagationOperation.DELETE).remove(syncResourceName);
        }
        return this.provision(user, null, false, true, propByRes);
    }

    private Map.Entry<String, Attribute> prepareAttribute(SchemaMapping mapping, SyncopeUser user, String password) throws ClassNotFoundException {
        ArrayList<AbstractAttributable> attributables = new ArrayList<AbstractAttributable>();
        switch (mapping.getIntMappingType().getAttributableType()) {
            case USER: {
                attributables.addAll(Collections.singleton(user));
                break;
            }
            case ROLE: {
                List<Membership> memberships = user.getMemberships();
                for (Membership membership : memberships) {
                    attributables.add(membership.getSyncopeRole());
                }
                break;
            }
            case MEMBERSHIP: {
                attributables.addAll(user.getMemberships());
                break;
            }
        }
        Map.Entry<AbstractSchema, List<AbstractAttrValue>> entry = SchemaMappingUtil.getIntValues(mapping, attributables, password, this.schemaDAO);
        List<AbstractAttrValue> values = entry.getValue();
        AbstractSchema schema = entry.getKey();
        SchemaType schemaType = schema == null ? SchemaType.String : schema.getType();
        String extAttrName = SchemaMappingUtil.getExtAttrName(mapping);
        LOG.debug("Define mapping for: \n* ExtAttrName " + extAttrName + "\n* is accountId " + mapping.isAccountid() + "\n* is password " + (mapping.isPassword() || mapping.getIntMappingType().equals((Object)IntMappingType.Password)) + "\n* mandatory condition " + mapping.getMandatoryCondition() + "\n* Schema " + mapping.getIntAttrName() + "\n* IntMappingType " + mapping.getIntMappingType().toString() + "\n* ClassType " + schemaType.getClassName() + "\n* Values " + values);
        ArrayList<Object> objValues = new ArrayList<Object>();
        for (AbstractAttrValue value : values) {
            if (FrameworkUtil.isSupportedAttributeType(Class.forName(schemaType.getClassName()))) {
                objValues.add(value.getValue());
                continue;
            }
            objValues.add(value.getValueAsString());
        }
        DefaultMapEntry res = mapping.isAccountid() ? new DefaultMapEntry((Object)objValues.iterator().next().toString(), null) : (mapping.isPassword() ? new DefaultMapEntry(null, (Object)AttributeBuilder.buildPassword((char[])objValues.iterator().next().toString().toCharArray())) : (schema != null && schema.isMultivalue() ? new DefaultMapEntry(null, (Object)AttributeBuilder.build((String)extAttrName, objValues)) : new DefaultMapEntry(null, (Object)(objValues.isEmpty() ? AttributeBuilder.build((String)extAttrName) : AttributeBuilder.build((String)extAttrName, (Object[])new Object[]{objValues.iterator().next()})))));
        return res;
    }

    private Map.Entry<String, Set<Attribute>> prepareAttributes(SyncopeUser user, String password, Boolean enable, ExternalResource resource) {
        String evalAccountLink;
        LOG.debug("Preparing resource attributes for {} on resource {} with attributes {}", new Object[]{user, resource, user.getAttributes()});
        HashSet<Object> attributes = new HashSet<Object>();
        String accountId = null;
        for (SchemaMapping mapping : resource.getMappings()) {
            LOG.debug("Processing schema {}", (Object)SchemaMappingUtil.getIntAttrName(mapping));
            try {
                Map.Entry<String, Attribute> preparedAttribute = this.prepareAttribute(mapping, user, password);
                if (preparedAttribute.getKey() != null) {
                    accountId = preparedAttribute.getKey();
                }
                if (preparedAttribute.getValue() == null) continue;
                Attribute alreadyAdded = AttributeUtil.find((String)preparedAttribute.getValue().getName(), attributes);
                if (alreadyAdded == null) {
                    attributes.add(preparedAttribute.getValue());
                    continue;
                }
                attributes.remove(alreadyAdded);
                HashSet values = new HashSet(alreadyAdded.getValue());
                values.addAll(preparedAttribute.getValue().getValue());
                attributes.add(AttributeBuilder.build((String)preparedAttribute.getValue().getName(), values));
            }
            catch (Exception e) {
                LOG.debug("Attribute '{}' processing failed", (Object)SchemaMappingUtil.getIntAttrName(mapping), (Object)e);
            }
        }
        if (!StringUtils.hasText(accountId)) {
            LOG.error("Missing accountId for '{}': ", (Object)resource.getName());
        }
        if ((evalAccountLink = this.jexlUtil.evaluate(resource.getAccountLink(), user)).isEmpty()) {
            LOG.debug("Add AccountId [{}] as __NAME__", accountId);
            attributes.add(new Name(accountId));
        } else {
            LOG.debug("Add AccountLink [{}] as __NAME__", (Object)evalAccountLink);
            attributes.add(new Name(evalAccountLink));
            LOG.debug("AccountId will be used just as __UID__ attribute");
        }
        if (enable != null) {
            attributes.add(AttributeBuilder.buildEnabled((boolean)enable));
        }
        return new DefaultMapEntry((Object)accountId, attributes);
    }

    protected List<PropagationTask> provision(SyncopeUser user, String password, Boolean enable, boolean deleteOnResource, PropagationByResource propByRes) {
        LOG.debug("Provisioning with user {}:\n{}", (Object)user, (Object)propByRes);
        propByRes.purge();
        LOG.debug("After purge: {}", (Object)propByRes);
        ArrayList<PropagationTask> tasks = new ArrayList<PropagationTask>();
        for (PropagationOperation operation : PropagationOperation.values()) {
            ArrayList<ExternalResource> resourcesByPriority = new ArrayList<ExternalResource>();
            for (ExternalResource resource : this.resourceDAO.findAllByPriority()) {
                if (!propByRes.get(operation).contains(resource.getName())) continue;
                resourcesByPriority.add(resource);
            }
            for (ExternalResource resource : resourcesByPriority) {
                PropagationTask task = new PropagationTask();
                task.setResource(resource);
                if (!deleteOnResource) {
                    task.setSyncopeUser(user);
                }
                task.setPropagationOperation(operation);
                task.setPropagationMode(resource.getPropagationMode());
                task.setOldAccountId(propByRes.getOldAccountId(resource.getName()));
                Map.Entry<String, Set<Attribute>> preparedAttrs = this.prepareAttributes(user, password, enable, resource);
                task.setAccountId(preparedAttrs.getKey());
                task.setAttributes(preparedAttrs.getValue());
                tasks.add(task);
                LOG.debug("Execution started for {}", (Object)task);
            }
        }
        return tasks;
    }

    public void execute(List<PropagationTask> tasks) throws PropagationException {
        this.execute(tasks, null);
    }

    public void execute(List<PropagationTask> tasks, PropagationHandler handler) throws PropagationException {
        for (PropagationTask task : tasks) {
            PropagationTaskExecStatus execStatus;
            LOG.debug("Execution started for {}", (Object)task);
            TaskExec execution = this.execute(task, handler);
            LOG.debug("Execution finished for {}, {}", (Object)task, (Object)execution);
            try {
                execStatus = PropagationTaskExecStatus.valueOf((String)execution.getStatus());
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unexpected execution status found {}", (Object)execution.getStatus());
                execStatus = PropagationTaskExecStatus.FAILURE;
            }
            if (!task.getResource().isPropagationPrimary() || execStatus.isSuccessful()) continue;
            throw new PropagationException(task.getResource().getName(), execution.getMessage());
        }
    }

    private boolean hasToBeregistered(PropagationTask task, TaskExec execution) {
        boolean result;
        boolean failed = !PropagationTaskExecStatus.valueOf((String)execution.getStatus()).isSuccessful();
        switch (task.getPropagationOperation()) {
            case CREATE: {
                result = failed && task.getResource().getCreateTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getResource().getCreateTraceLevel() == TraceLevel.ALL;
                break;
            }
            case UPDATE: {
                result = failed && task.getResource().getUpdateTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getResource().getUpdateTraceLevel() == TraceLevel.ALL;
                break;
            }
            case DELETE: {
                result = failed && task.getResource().getDeleteTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getResource().getDeleteTraceLevel() == TraceLevel.ALL;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public TaskExec execute(PropagationTask task) {
        return this.execute(task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public TaskExec execute(PropagationTask task, PropagationHandler handler) {
        startDate = new Date();
        execution = new TaskExec();
        execution.setStatus(PropagationTaskExecStatus.CREATED.name());
        taskExecutionMessage = null;
        propagationAttempted = new HashSet<String>();
        before = null;
        after = null;
        try {
            connector = this.connLoader.getConnector(task.getResource());
            if (connector == null) {
                throw new NoSuchBeanDefinitionException(String.format("Connector instance bean for resource %s not found", new Object[]{task.getResource()}));
            }
            before = this.getRemoteObject(connector, task, false);
            try {
                switch (1.$SwitchMap$org$apache$syncope$types$PropagationOperation[task.getPropagationOperation().ordinal()]) {
                    case 1: 
                    case 2: {
                        attributes = new HashSet<Attribute>(task.getAttributes());
                        if (before == null) {
                            accountId = task.getAccountId();
                            name = (Name)AttributeUtil.find((String)Name.NAME, attributes);
                            if (StringUtils.hasText((String)accountId) && (name == null || !accountId.equals(name.getNameValue())) && (uid = (Uid)AttributeUtil.find((String)Uid.NAME, attributes)) == null) {
                                attributes.add(AttributeBuilder.build((String)Uid.NAME, Collections.singleton(accountId)));
                            }
                            connector.create(task.getPropagationMode(), ObjectClass.ACCOUNT, attributes, null, propagationAttempted);
                            break;
                        }
                        newName = (Name)AttributeUtil.find((String)Name.NAME, attributes);
                        PropagationManager.LOG.debug("Rename required with value {}", (Object)newName);
                        if (newName != null && newName.equals((Object)before.getName()) && !before.getUid().getUidValue().equals(newName.getNameValue())) {
                            PropagationManager.LOG.debug("Remote object name unchanged");
                            attributes.remove(newName);
                        }
                        PropagationManager.LOG.debug("Attributes to be replaced {}", attributes);
                        connector.update(task.getPropagationMode(), ObjectClass.ACCOUNT, before.getUid(), attributes, null, propagationAttempted);
                        break;
                    }
                    case 3: {
                        if (before == null) {
                            PropagationManager.LOG.debug("{} not found on external resource: ignoring delete", (Object)task.getAccountId());
                            break;
                        }
                        user = null;
                        if (task.getSyncopeUser() != null) {
                            try {
                                user = this.getSyncopeUser(task.getSyncopeUser().getId());
                            }
                            catch (NotFoundException e) {
                                PropagationManager.LOG.warn("Requesting to delete a non-existing user from {}", (Object)task.getResource().getName(), (Object)e);
                            }
                        }
                        if (user == null || !user.getResourceNames().contains(task.getResource().getName())) {
                            PropagationManager.LOG.debug("Perform deprovisioning on {}", (Object)task.getResource().getName());
                            connector.delete(task.getPropagationMode(), ObjectClass.ACCOUNT, before.getUid(), null, propagationAttempted);
                            break;
                        }
                        PropagationManager.LOG.debug("Update remote object on {}", (Object)task.getResource().getName());
                        connector.update(task.getPropagationMode(), ObjectClass.ACCOUNT, before.getUid(), task.getAttributes(), null, propagationAttempted);
                        break;
                    }
                }
                execution.setStatus(task.getPropagationMode() == PropagationMode.ONE_PHASE ? PropagationTaskExecStatus.SUCCESS.name() : PropagationTaskExecStatus.SUBMITTED.name());
                PropagationManager.LOG.debug("Successfully propagated to {}", (Object)task.getResource());
                after = this.getRemoteObject(connector, task, true);
            }
            catch (Exception e) {
                after = this.getRemoteObject(connector, task, false);
                throw e;
            }
        }
        catch (Exception e) {
            try {
                PropagationManager.LOG.error("Exception during provision on resource " + task.getResource().getName(), (Throwable)e);
                if (e instanceof ConnectorException && e.getCause() != null) {
                    taskExecutionMessage = e.getCause().getMessage();
                } else {
                    exceptionWriter = new StringWriter();
                    exceptionWriter.write(e.getMessage() + "\n\n");
                    e.printStackTrace(new PrintWriter(exceptionWriter));
                    taskExecutionMessage = exceptionWriter.toString();
                }
                try {
                    execution.setStatus(task.getPropagationMode() == PropagationMode.ONE_PHASE ? PropagationTaskExecStatus.FAILURE.name() : PropagationTaskExecStatus.UNSUBMITTED.name());
                }
                catch (Exception wft) {
                    PropagationManager.LOG.error("While executing KO action on {}", (Object)execution, (Object)wft);
                }
                propagationAttempted.add(task.getPropagationOperation().name().toLowerCase());
            }
            catch (Throwable var14_21) {
                PropagationManager.LOG.debug("Update execution for {}", (Object)task);
                execution.setStartDate(startDate);
                execution.setMessage(taskExecutionMessage);
                execution.setEndDate(new Date());
                if (this.hasToBeregistered(task, execution)) {
                    if (propagationAttempted.isEmpty()) {
                        PropagationManager.LOG.debug("No propagation attempted for {}", (Object)execution);
                    } else {
                        execution.setTask(task);
                        task.addExec(execution);
                        PropagationManager.LOG.debug("Execution finished: {}", (Object)execution);
                    }
                    this.taskDAO.save(task);
                    this.taskDAO.flush();
                }
                throw var14_21;
            }
            PropagationManager.LOG.debug("Update execution for {}", (Object)task);
            execution.setStartDate(startDate);
            execution.setMessage(taskExecutionMessage);
            execution.setEndDate(new Date());
            if (this.hasToBeregistered(task, execution)) {
                if (propagationAttempted.isEmpty()) {
                    PropagationManager.LOG.debug("No propagation attempted for {}", (Object)execution);
                } else {
                    execution.setTask(task);
                    task.addExec(execution);
                    PropagationManager.LOG.debug("Execution finished: {}", (Object)execution);
                }
                this.taskDAO.save(task);
                this.taskDAO.flush();
            } else {
                ** GOTO lbl128
            }
        }
        PropagationManager.LOG.debug("Update execution for {}", (Object)task);
        execution.setStartDate(startDate);
        execution.setMessage(taskExecutionMessage);
        execution.setEndDate(new Date());
        if (this.hasToBeregistered(task, execution)) {
            if (propagationAttempted.isEmpty()) {
                PropagationManager.LOG.debug("No propagation attempted for {}", (Object)execution);
            } else {
                execution.setTask(task);
                task.addExec(execution);
                PropagationManager.LOG.debug("Execution finished: {}", (Object)execution);
            }
            this.taskDAO.save(task);
            this.taskDAO.flush();
        }
        if (handler != null) {
            handler.handle(task.getResource().getName(), PropagationTaskExecStatus.valueOf((String)execution.getStatus()), before, after);
        }
        return execution;
    }

    private ConnectorObject getRemoteObject(ConnectorFacadeProxy connector, PropagationTask task, boolean latest) {
        try {
            return connector.getObject(task.getPropagationMode(), task.getPropagationOperation(), ObjectClass.ACCOUNT, new Uid(latest || task.getOldAccountId() == null ? task.getAccountId() : task.getOldAccountId()), connector.getOperationOptions(task.getResource()));
        }
        catch (RuntimeException ignore) {
            LOG.debug("Resolving username", (Throwable)ignore);
            return null;
        }
    }
}

