/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.propagation;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.types.PropagationOperation;

public class PropagationByResource
implements Serializable {
    private static final long serialVersionUID = -5699740428104336636L;
    private Set<String> toBeCreated = new HashSet<String>();
    private Set<String> toBeUpdated = new HashSet<String>();
    private Set<String> toBeDeleted = new HashSet<String>();
    private Map<String, String> oldAccountIds = new HashMap<String, String>();

    public final void purge() {
        this.toBeCreated.removeAll(this.toBeDeleted);
        this.toBeCreated.removeAll(this.toBeUpdated);
        this.toBeUpdated.removeAll(this.toBeDeleted);
    }

    public final boolean add(PropagationOperation type, String resourceName) {
        Set<String> set;
        switch (type) {
            case CREATE: {
                set = this.toBeCreated;
                break;
            }
            case UPDATE: {
                set = this.toBeUpdated;
                break;
            }
            default: {
                set = this.toBeDeleted;
            }
        }
        return set.add(resourceName);
    }

    public boolean addAll(PropagationOperation type, Set<String> resourceNames) {
        Set<String> set;
        switch (type) {
            case CREATE: {
                set = this.toBeCreated;
                break;
            }
            case UPDATE: {
                set = this.toBeUpdated;
                break;
            }
            default: {
                set = this.toBeDeleted;
            }
        }
        return set.addAll(resourceNames);
    }

    public final boolean remove(PropagationOperation type, String resourceName) {
        boolean result = false;
        switch (type) {
            case CREATE: {
                result = this.toBeCreated.remove(resourceName);
                break;
            }
            case UPDATE: {
                result = this.toBeUpdated.remove(resourceName);
                break;
            }
            case DELETE: {
                result = this.toBeDeleted.remove(resourceName);
                break;
            }
        }
        return result;
    }

    public final Set<String> get(PropagationOperation type) {
        Set<String> result = Collections.emptySet();
        switch (type) {
            case CREATE: {
                result = this.toBeCreated;
                break;
            }
            case UPDATE: {
                result = this.toBeUpdated;
                break;
            }
            case DELETE: {
                result = this.toBeDeleted;
                break;
            }
        }
        return result;
    }

    public final void set(PropagationOperation type, Set<String> resourceNames) {
        switch (type) {
            case CREATE: {
                this.toBeCreated.clear();
                this.toBeCreated.addAll(resourceNames);
                break;
            }
            case UPDATE: {
                this.toBeUpdated.clear();
                this.toBeUpdated.addAll(resourceNames);
                break;
            }
            case DELETE: {
                this.toBeDeleted.clear();
                this.toBeDeleted.addAll(resourceNames);
                break;
            }
        }
    }

    public final void merge(PropagationByResource propByRes) {
        this.toBeCreated.addAll(propByRes.get(PropagationOperation.CREATE));
        this.toBeUpdated.addAll(propByRes.get(PropagationOperation.UPDATE));
        this.toBeDeleted.addAll(propByRes.get(PropagationOperation.DELETE));
        this.oldAccountIds.putAll(propByRes.getOldAccountIds());
    }

    public final boolean isEmpty() {
        return this.toBeCreated.isEmpty() && this.toBeUpdated.isEmpty() && this.toBeDeleted.isEmpty() && this.oldAccountIds.isEmpty();
    }

    public Map<String, String> getOldAccountIds() {
        return this.oldAccountIds;
    }

    public String getOldAccountId(String resourceName) {
        return this.oldAccountIds.get(resourceName);
    }

    public void addOldAccountId(String resourceName, String oldAccountId) {
        if (resourceName != null && oldAccountId != null) {
            this.oldAccountIds.put(resourceName, oldAccountId);
        }
    }

    public String toString() {
        return "To be Created: " + this.toBeCreated + ";\n" + "To be Updated: " + this.toBeUpdated + ";\n" + "To be Deleted: " + this.toBeDeleted + ";\n" + "Old account Ids: " + this.oldAccountIds;
    }
}

