/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.propagation;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.NotFoundException;
import org.apache.syncope.core.persistence.beans.ConnInstance;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.SchemaMapping;
import org.apache.syncope.core.persistence.dao.MissingConfKeyException;
import org.apache.syncope.core.util.ConnBundleManager;
import org.apache.syncope.core.util.SchemaMappingUtil;
import org.apache.syncope.types.ConnConfProperty;
import org.apache.syncope.types.ConnectorCapability;
import org.apache.syncope.types.PropagationMode;
import org.apache.syncope.types.PropagationOperation;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConnectorFacade;
import org.identityconnectors.framework.api.ConnectorFacadeFactory;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ConnectorFacadeProxy {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorFacadeProxy.class);
    private final ConnectorFacade connector;
    private final ConnInstance activeConnInstance;

    public ConnectorFacadeProxy(ConnInstance connInstance, ConnBundleManager connBundleManager) throws NotFoundException {
        ConnectorInfo info;
        this.activeConnInstance = connInstance;
        ConnectorKey key = new ConnectorKey(connInstance.getBundleName(), connInstance.getVersion(), connInstance.getConnectorName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("\nBundle name: " + key.getBundleName() + "\nBundle version: " + key.getBundleVersion() + "\nBundle class: " + key.getConnectorName());
        }
        try {
            info = connBundleManager.getConnectorManager().findConnectorInfo(key);
            if (info == null) {
                throw new NotFoundException("Connector Info for key " + key);
            }
        }
        catch (MissingConfKeyException e) {
            throw new NotFoundException("Connector Info for key " + key, (Exception)e);
        }
        APIConfiguration apiConfig = info.createDefaultAPIConfiguration();
        if (apiConfig == null) {
            throw new NotFoundException("Default API configuration");
        }
        ConfigurationProperties properties = apiConfig.getConfigurationProperties();
        if (properties == null) {
            throw new NotFoundException("Configuration properties");
        }
        if (LOG.isDebugEnabled()) {
            for (String propName : properties.getPropertyNames()) {
                LOG.debug("\nProperty Name: {}\nProperty Type: {}", (Object)properties.getProperty(propName).getName(), (Object)properties.getProperty(propName).getType());
            }
        }
        for (ConnConfProperty property : connInstance.getConfiguration()) {
            Object propertyValue = this.getPropertyValue(property);
            if (propertyValue == null) continue;
            properties.setPropertyValue(property.getSchema().getName(), propertyValue);
        }
        this.connector = ConnectorFacadeFactory.getInstance().newInstance(apiConfig);
        if (this.connector == null) {
            throw new NotFoundException("Connector");
        }
        this.connector.validate();
    }

    public Uid create(PropagationMode propagationMode, ObjectClass objectClass, Set<Attribute> attrs, OperationOptions options, Set<String> propagationAttempted) {
        Uid result = null;
        if (propagationMode == PropagationMode.ONE_PHASE ? this.activeConnInstance.getCapabilities().contains(ConnectorCapability.ONE_PHASE_CREATE) : this.activeConnInstance.getCapabilities().contains(ConnectorCapability.TWO_PHASES_CREATE)) {
            propagationAttempted.add("create");
            result = this.connector.create(objectClass, attrs, options);
        } else {
            LOG.info("Create was attempted, although the connector only has these capabilities: {}. No action.", this.activeConnInstance.getCapabilities());
        }
        return result;
    }

    public Uid update(PropagationMode propagationMode, ObjectClass objectClass, Uid uid, Set<Attribute> attrs, OperationOptions options, Set<String> propagationAttempted) {
        Uid result = null;
        if (propagationMode == PropagationMode.ONE_PHASE ? this.activeConnInstance.getCapabilities().contains(ConnectorCapability.ONE_PHASE_UPDATE) : this.activeConnInstance.getCapabilities().contains(ConnectorCapability.TWO_PHASES_UPDATE)) {
            propagationAttempted.add("update");
            result = this.connector.update(objectClass, uid, attrs, options);
        } else {
            LOG.info("Update for {} was attempted, although the connector only has these capabilities: {}. No action.", (Object)uid.getUidValue(), this.activeConnInstance.getCapabilities());
        }
        return result;
    }

    public void delete(PropagationMode propagationMode, ObjectClass objectClass, Uid uid, OperationOptions options, Set<String> propagationAttempted) {
        if (propagationMode == PropagationMode.ONE_PHASE ? this.activeConnInstance.getCapabilities().contains(ConnectorCapability.ONE_PHASE_DELETE) : this.activeConnInstance.getCapabilities().contains(ConnectorCapability.TWO_PHASES_DELETE)) {
            propagationAttempted.add("delete");
            this.connector.delete(objectClass, uid, options);
        } else {
            LOG.info("Delete for {} was attempted, although the connector only has these capabilities: {}. No action.", (Object)uid.getUidValue(), this.activeConnInstance.getCapabilities());
        }
    }

    public void sync(SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        if (this.activeConnInstance.getCapabilities().contains(ConnectorCapability.SYNC)) {
            this.connector.sync(ObjectClass.ACCOUNT, token, handler, options);
        } else {
            LOG.info("Sync was attempted, although the connector only has these capabilities: {}. No action.", this.activeConnInstance.getCapabilities());
        }
    }

    public SyncToken getLatestSyncToken() {
        SyncToken result = null;
        if (this.activeConnInstance.getCapabilities().contains(ConnectorCapability.SYNC)) {
            result = this.connector.getLatestSyncToken(ObjectClass.ACCOUNT);
        } else {
            LOG.info("getLatestSyncToken was attempted, although the connector only has these capabilities: {}. No action.", this.activeConnInstance.getCapabilities());
        }
        return result;
    }

    public ConnectorObject getObject(ObjectClass objectClass, Uid uid, OperationOptions options) {
        return this.getObject(null, null, objectClass, uid, options);
    }

    public ConnectorObject getObject(PropagationMode propagationMode, PropagationOperation operationType, ObjectClass objectClass, Uid uid, OperationOptions options) {
        ConnectorObject result;
        block8: {
            block6: {
                block7: {
                    result = null;
                    if (!this.activeConnInstance.getCapabilities().contains(ConnectorCapability.SEARCH)) break block6;
                    if (operationType != null) break block7;
                    result = this.connector.getObject(objectClass, uid, options);
                    break block8;
                }
                switch (operationType) {
                    case CREATE: {
                        if (propagationMode == null || (propagationMode == PropagationMode.ONE_PHASE ? this.activeConnInstance.getCapabilities().contains(ConnectorCapability.ONE_PHASE_CREATE) : this.activeConnInstance.getCapabilities().contains(ConnectorCapability.TWO_PHASES_CREATE))) {
                            result = this.connector.getObject(objectClass, uid, options);
                            break;
                        }
                        break block8;
                    }
                    case UPDATE: {
                        if (propagationMode == null || (propagationMode == PropagationMode.ONE_PHASE ? this.activeConnInstance.getCapabilities().contains(ConnectorCapability.ONE_PHASE_UPDATE) : this.activeConnInstance.getCapabilities().contains(ConnectorCapability.TWO_PHASES_UPDATE))) {
                            result = this.connector.getObject(objectClass, uid, options);
                            break;
                        }
                        break block8;
                    }
                    default: {
                        result = this.connector.getObject(objectClass, uid, options);
                        break;
                    }
                }
                break block8;
            }
            LOG.info("Search was attempted, although the connector only has these capabilities: {}. No action.", this.activeConnInstance.getCapabilities());
        }
        return result;
    }

    public void getAllObjects(ObjectClass objectClass, final SyncResultsHandler handler, OperationOptions options) {
        if (this.activeConnInstance.getCapabilities().contains(ConnectorCapability.SEARCH)) {
            this.connector.search(objectClass, null, new ResultsHandler(){

                public boolean handle(ConnectorObject obj) {
                    SyncDeltaBuilder bld = new SyncDeltaBuilder();
                    bld.setObject(obj);
                    bld.setUid(obj.getUid());
                    bld.setDeltaType(SyncDeltaType.CREATE_OR_UPDATE);
                    bld.setToken(new SyncToken((Object)""));
                    return handler.handle(bld.build());
                }
            }, options);
        } else {
            LOG.info("Search was attempted, although the connector only has these capabilities: {}. No action.", this.activeConnInstance.getCapabilities());
        }
    }

    public Attribute getObjectAttribute(ObjectClass objectClass, Uid uid, OperationOptions options, String attributeName) {
        Attribute attribute = null;
        try {
            ConnectorObject object = this.connector.getObject(objectClass, uid, options);
            attribute = object.getAttributeByName(attributeName);
        }
        catch (NullPointerException e) {
            LOG.debug("Object for '{}' not found", (Object)uid.getUidValue());
        }
        return attribute;
    }

    public Set<Attribute> getObjectAttributes(ObjectClass objectClass, Uid uid, OperationOptions options) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        try {
            ConnectorObject object = this.connector.getObject(objectClass, uid, options);
            for (String attribute : options.getAttributesToGet()) {
                attributes.add(object.getAttributeByName(attribute));
            }
        }
        catch (NullPointerException e) {
            LOG.debug("Object for '{}' not found", (Object)uid.getUidValue());
        }
        return attributes;
    }

    public Set<String> getSchema(boolean showall) {
        HashSet<String> resourceSchemaNames = new HashSet<String>();
        Schema schema = this.connector.schema();
        try {
            for (ObjectClassInfo info : schema.getObjectClassInfo()) {
                for (AttributeInfo attrInfo : info.getAttributeInfo()) {
                    if (!showall && (Name.NAME.equals(attrInfo.getName()) || OperationalAttributes.PASSWORD_NAME.equals(attrInfo.getName()) || OperationalAttributes.ENABLE_NAME.equals(attrInfo.getName()))) continue;
                    resourceSchemaNames.add(attrInfo.getName());
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Unsupported operation {}", (Throwable)e);
        }
        return resourceSchemaNames;
    }

    public void validate() {
        this.connector.validate();
    }

    public void test() {
        this.connector.test();
    }

    public String toString() {
        return "ConnectorFacadeProxy{connector=" + this.connector + "capabitilies=" + this.activeConnInstance.getCapabilities() + '}';
    }

    public ConnInstance getActiveConnInstance() {
        return this.activeConnInstance;
    }

    public OperationOptions getOperationOptions(ExternalResource resource) {
        OperationOptionsBuilder oob = new OperationOptionsBuilder();
        HashSet<String> attributesToGet = new HashSet<String>(Arrays.asList(Name.NAME, Uid.NAME, OperationalAttributes.ENABLE_NAME));
        for (SchemaMapping mapping : resource.getMappings()) {
            String extAttrName = SchemaMappingUtil.getExtAttrName(mapping);
            if (!StringUtils.hasText((String)extAttrName)) continue;
            attributesToGet.add(extAttrName);
        }
        oob.setAttributesToGet(attributesToGet);
        return oob.build();
    }

    private Object getPropertyValue(ConnConfProperty property) {
        Object value = null;
        List values = property.getValues();
        if (values != null && !values.isEmpty()) {
            try {
                Class propertySchemaClass = ClassUtils.forName((String)property.getSchema().getType(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                value = GuardedString.class.equals((Object)propertySchemaClass) ? new GuardedString(values.get(0).toString().toCharArray()) : (GuardedByteArray.class.equals((Object)propertySchemaClass) ? new GuardedByteArray((byte[])values.get(0)) : (Character.class.equals((Object)propertySchemaClass) || Character.TYPE.equals(propertySchemaClass) ? (values.get(0) != null && !values.get(0).toString().isEmpty() ? Character.valueOf(values.get(0).toString().charAt(0)) : null) : (Integer.class.equals((Object)propertySchemaClass) || Integer.TYPE.equals(propertySchemaClass) ? Integer.valueOf(Integer.parseInt(values.get(0).toString())) : (Long.class.equals((Object)propertySchemaClass) || Long.TYPE.equals(propertySchemaClass) ? Long.valueOf(Long.parseLong(values.get(0).toString())) : (Float.class.equals((Object)propertySchemaClass) || Float.TYPE.equals(propertySchemaClass) ? Float.valueOf(Float.parseFloat(values.get(0).toString())) : (Double.class.equals((Object)propertySchemaClass) || Double.TYPE.equals(propertySchemaClass) ? Double.valueOf(Double.parseDouble(values.get(0).toString())) : (Boolean.class.equals((Object)propertySchemaClass) || Boolean.TYPE.equals(propertySchemaClass) ? Boolean.valueOf(Boolean.parseBoolean(values.get(0).toString())) : (URI.class.equals((Object)propertySchemaClass) ? URI.create(values.get(0).toString()) : (File.class.equals((Object)propertySchemaClass) ? new File(values.get(0).toString()) : (String[].class.equals((Object)propertySchemaClass) ? values.toArray(new String[0]) : values.get(0).toString()))))))))));
            }
            catch (Exception e) {
                LOG.error("Invalid ConnConfProperty specified: {}", (Object)property, (Object)e);
            }
        }
        return value;
    }
}

