/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.policy;

import java.util.List;
import org.apache.syncope.core.persistence.beans.AbstractAttr;
import org.apache.syncope.core.persistence.beans.AbstractAttributable;
import org.apache.syncope.core.persistence.beans.Policy;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.types.AbstractPolicySpec;
import org.apache.syncope.types.AccountPolicySpec;
import org.apache.syncope.types.PasswordPolicySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class PolicyEvaluator {
    protected static final Logger LOG = LoggerFactory.getLogger(PolicyEvaluator.class);

    public <T extends AbstractPolicySpec> T evaluate(Policy policy, AbstractAttributable attributable) {
        AccountPolicySpec result = null;
        if (policy != null) {
            switch (policy.getType()) {
                case PASSWORD: 
                case GLOBAL_PASSWORD: {
                    PasswordPolicySpec pspec = (PasswordPolicySpec)policy.getSpecification();
                    PasswordPolicySpec passwordPolicy = new PasswordPolicySpec();
                    BeanUtils.copyProperties((Object)pspec, (Object)passwordPolicy, (String[])new String[]{"schemasNotPermitted"});
                    for (String schema : pspec.getSchemasNotPermitted()) {
                        List<String> values;
                        Object attribute = attributable.getAttribute(schema);
                        if (attribute == null || (values = ((AbstractAttr)attribute).getValuesAsStrings()) == null || values.isEmpty()) continue;
                        passwordPolicy.getWordsNotPermitted().add(values.get(0));
                    }
                    if (!(attributable instanceof SyncopeUser)) {
                        LOG.error("Cannot check previous passwords. attributable is not a user object: " + attributable.getClass().toString());
                        result = passwordPolicy;
                        break;
                    }
                    SyncopeUser user = (SyncopeUser)attributable;
                    String password = user.getPassword();
                    List<String> passwordHistory = user.getPasswordHistory();
                    if (user.verifyPasswordHistory(user.getClearPassword(), pspec.getHistoryLength())) {
                        passwordPolicy.getWordsNotPermitted().add(user.getClearPassword());
                    } else {
                        if (pspec.getHistoryLength() > 0 && password != null) {
                            passwordHistory.add(password);
                        }
                        if (pspec.getHistoryLength() < passwordHistory.size()) {
                            for (int i = 0; i < passwordHistory.size() - pspec.getHistoryLength(); ++i) {
                                passwordHistory.remove(i);
                            }
                        }
                    }
                    result = passwordPolicy;
                    break;
                }
                case ACCOUNT: 
                case GLOBAL_ACCOUNT: {
                    AccountPolicySpec spec = (AccountPolicySpec)policy.getSpecification();
                    AccountPolicySpec accountPolicy = new AccountPolicySpec();
                    BeanUtils.copyProperties((Object)spec, (Object)accountPolicy, (String[])new String[]{"schemasNotPermitted"});
                    for (String schema : spec.getSchemasNotPermitted()) {
                        List<String> values;
                        Object attribute = attributable.getAttribute(schema);
                        if (attribute == null || (values = ((AbstractAttr)attribute).getValuesAsStrings()) == null || values.isEmpty()) continue;
                        accountPolicy.getWordsNotPermitted().add(values.get(0));
                    }
                    result = accountPolicy;
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return (T)result;
    }
}

