/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.policy;

import java.util.regex.Pattern;
import org.apache.syncope.core.policy.PasswordPolicyException;
import org.apache.syncope.core.policy.PolicyEnforceException;
import org.apache.syncope.core.policy.PolicyEnforcer;
import org.apache.syncope.types.PasswordPolicySpec;
import org.apache.syncope.types.PolicyType;
import org.springframework.stereotype.Component;

@Component
public class PasswordPolicyEnforcer
extends PolicyEnforcer<PasswordPolicySpec, String> {
    private static final Pattern DIGIT = Pattern.compile(".*\\d+.*");
    private static final Pattern ALPHA_LOWERCASE = Pattern.compile(".*[a-z]+.*");
    private static final Pattern ALPHA_UPPERCASE = Pattern.compile(".*[A-Z]+.*");
    private static final Pattern FIRSTDIGIT = Pattern.compile("\\d.*");
    private static final Pattern LASTDIGIT = Pattern.compile(".*\\d");
    private static final Pattern ALPHANUMERIC = Pattern.compile(".*\\w.*");
    private static final Pattern FIRSTALPHANUMERIC = Pattern.compile("\\w.*");
    private static final Pattern LASTALPHANUMERIC = Pattern.compile(".*\\w");
    private static final Pattern NONALPHANUMERIC = Pattern.compile(".*\\W.*");
    private static final Pattern FIRSTNONALPHANUMERIC = Pattern.compile("\\W.*");
    private static final Pattern LASTNONALPHANUMERIC = Pattern.compile(".*\\W");

    @Override
    public void enforce(PasswordPolicySpec policy, PolicyType type, String password) throws PasswordPolicyException, PolicyEnforceException {
        if (password == null) {
            throw new PolicyEnforceException("Invalid password");
        }
        if (policy == null) {
            throw new PolicyEnforceException("Invalid policy");
        }
        if (policy.getMinLength() > 0 && policy.getMinLength() > password.length()) {
            throw new PasswordPolicyException("Password too short");
        }
        if (policy.getMaxLength() > 0 && policy.getMaxLength() < password.length()) {
            throw new PasswordPolicyException("Password too long");
        }
        for (String word : policy.getWordsNotPermitted()) {
            if (!password.contains(word)) continue;
            throw new PasswordPolicyException("Used word(s) not permitted");
        }
        if (policy.isDigitRequired() && !this.checkForDigit(password)) {
            throw new PasswordPolicyException("Password must contain digit(s)");
        }
        if (policy.isLowercaseRequired() && !this.checkForLowercase(password)) {
            throw new PasswordPolicyException("Password must contain lowercase alphabetic character(s)");
        }
        if (policy.isUppercaseRequired() && !this.checkForUppercase(password)) {
            throw new PasswordPolicyException("Password must contain uppercase alphabetic character(s)");
        }
        for (String prefix : policy.getPrefixesNotPermitted()) {
            if (!password.startsWith(prefix)) continue;
            throw new PasswordPolicyException("Prefix not permitted");
        }
        for (String suffix : policy.getSuffixesNotPermitted()) {
            if (!password.endsWith(suffix)) continue;
            throw new PasswordPolicyException("Suffix not permitted");
        }
        if (policy.isMustStartWithDigit() && !this.checkForFirstDigit(password)) {
            throw new PasswordPolicyException("Password must start with a digit");
        }
        if (policy.isMustntStartWithDigit() && this.checkForFirstDigit(password)) {
            throw new PasswordPolicyException("Password mustn't start with a digit");
        }
        if (policy.isMustEndWithDigit() && !this.checkForLastDigit(password)) {
            throw new PasswordPolicyException("Password must end with a digit");
        }
        if (policy.isMustntEndWithDigit() && this.checkForLastDigit(password)) {
            throw new PasswordPolicyException("Password mustn't end with a digit");
        }
        if (policy.isAlphanumericRequired() && !this.checkForAlphanumeric(password)) {
            throw new PasswordPolicyException("Password must contain alphanumeric character(s)");
        }
        if (policy.isNonAlphanumericRequired() && !this.checkForNonAlphanumeric(password)) {
            throw new PasswordPolicyException("Password must contain non-alphanumeric character(s)");
        }
        if (policy.isMustStartWithAlpha() && !this.checkForFirstAlphanumeric(password)) {
            throw new PasswordPolicyException("Password must start with an alphanumeric character");
        }
        if (policy.isMustntStartWithAlpha() && this.checkForFirstAlphanumeric(password)) {
            throw new PasswordPolicyException("Password mustn't start with an alphanumeric character");
        }
        if (policy.isMustEndWithAlpha() && !this.checkForLastAlphanumeric(password)) {
            throw new PasswordPolicyException("Password must end with an alphanumeric character");
        }
        if (policy.isMustntEndWithAlpha() && this.checkForLastAlphanumeric(password)) {
            throw new PasswordPolicyException("Password mustn't end with an alphanumeric character");
        }
        if (policy.isMustStartWithNonAlpha() && !this.checkForFirstNonAlphanumeric(password)) {
            throw new PasswordPolicyException("Password must start with a non-alphanumeric character");
        }
        if (policy.isMustntStartWithNonAlpha() && this.checkForFirstNonAlphanumeric(password)) {
            throw new PasswordPolicyException("Password mustn't start with a non-alphanumeric character");
        }
        if (policy.isMustEndWithNonAlpha() && !this.checkForLastNonAlphanumeric(password)) {
            throw new PasswordPolicyException("Password must end with a non-alphanumeric character");
        }
        if (policy.isMustntEndWithNonAlpha() && this.checkForLastNonAlphanumeric(password)) {
            throw new PasswordPolicyException("Password mustn't end with a non-alphanumeric character");
        }
    }

    private boolean checkForDigit(String str) {
        return DIGIT.matcher(str).matches();
    }

    private boolean checkForLowercase(String str) {
        return ALPHA_LOWERCASE.matcher(str).matches();
    }

    private boolean checkForUppercase(String str) {
        return ALPHA_UPPERCASE.matcher(str).matches();
    }

    private boolean checkForFirstDigit(String str) {
        return FIRSTDIGIT.matcher(str).matches();
    }

    private boolean checkForLastDigit(String str) {
        return LASTDIGIT.matcher(str).matches();
    }

    private boolean checkForAlphanumeric(String str) {
        return ALPHANUMERIC.matcher(str).matches();
    }

    private boolean checkForFirstAlphanumeric(String str) {
        return FIRSTALPHANUMERIC.matcher(str).matches();
    }

    private boolean checkForLastAlphanumeric(String str) {
        return LASTALPHANUMERIC.matcher(str).matches();
    }

    private boolean checkForNonAlphanumeric(String str) {
        return NONALPHANUMERIC.matcher(str).matches();
    }

    private boolean checkForFirstNonAlphanumeric(String str) {
        return FIRSTNONALPHANUMERIC.matcher(str).matches();
    }

    private boolean checkForLastNonAlphanumeric(String str) {
        return LASTNONALPHANUMERIC.matcher(str).matches();
    }
}

