/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.policy;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.apache.syncope.client.to.UserTO;
import org.apache.syncope.core.persistence.beans.PropagationTask;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.policy.AccountPolicyException;
import org.apache.syncope.core.policy.PolicyEnforceException;
import org.apache.syncope.core.policy.PolicyEnforcer;
import org.apache.syncope.core.propagation.PropagationManager;
import org.apache.syncope.core.rest.data.UserDataBinder;
import org.apache.syncope.core.workflow.UserWorkflowAdapter;
import org.apache.syncope.core.workflow.WorkflowResult;
import org.apache.syncope.types.AccountPolicySpec;
import org.apache.syncope.types.PolicyType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountPolicyEnforcer
extends PolicyEnforcer<AccountPolicySpec, SyncopeUser> {
    @Autowired
    private UserWorkflowAdapter wfAdapter;
    @Autowired
    private PropagationManager propagationManager;
    @Autowired
    private UserDataBinder userDataBinder;
    private static final Pattern PATTERN = Pattern.compile("[a-zA-Z0-9-_@. ]+");
    private static final Pattern LCPATTERN = Pattern.compile("[a-z0-9-_@. ]+");
    private static final Pattern UCPATTERN = Pattern.compile("[A-Z0-9-_@. ]+");

    @Override
    public void enforce(AccountPolicySpec policy, PolicyType type, SyncopeUser user) throws AccountPolicyException, PolicyEnforceException {
        if (user.getUsername() == null) {
            throw new PolicyEnforceException("Invalid account");
        }
        if (policy == null) {
            throw new PolicyEnforceException("Invalid policy");
        }
        if (policy.getMinLength() > 0 && policy.getMinLength() > user.getUsername().length()) {
            throw new AccountPolicyException("Username too short");
        }
        if (policy.getMaxLength() > 0 && policy.getMaxLength() < user.getUsername().length()) {
            throw new AccountPolicyException("Username too long");
        }
        for (String word : policy.getWordsNotPermitted()) {
            if (!user.getUsername().contains(word)) continue;
            throw new AccountPolicyException("Used word(s) not permitted");
        }
        if (policy.isAllLowerCase() && !LCPATTERN.matcher(user.getUsername()).matches() || policy.isAllUpperCase() && !UCPATTERN.matcher(user.getUsername()).matches() || !PATTERN.matcher(user.getUsername()).matches()) {
            throw new AccountPolicyException("Invalid username syntax");
        }
        for (String prefix : policy.getPrefixesNotPermitted()) {
            if (!user.getUsername().startsWith(prefix)) continue;
            throw new AccountPolicyException("Prefix not permitted");
        }
        for (String suffix : policy.getSuffixesNotPermitted()) {
            if (!user.getUsername().endsWith(suffix)) continue;
            throw new AccountPolicyException("Suffix not permitted");
        }
        if (user.getFailedLogins() != null && policy.getPermittedLoginRetries() > 0 && user.getFailedLogins() > policy.getPermittedLoginRetries() && !user.getSuspended().booleanValue()) {
            try {
                LOG.debug("User {}:{} is over to max failed logins", (Object)user.getId(), (Object)user.getUsername());
                user.setFailedLogins(user.getFailedLogins() - 1);
                WorkflowResult<Long> updated = this.wfAdapter.suspend(user);
                if (policy.isPropagateSuspension()) {
                    List<PropagationTask> tasks = this.propagationManager.getUpdateTaskIds(new WorkflowResult<DefaultMapEntry>(new DefaultMapEntry((Object)updated.getResult(), (Object)Boolean.FALSE), updated.getPropByRes(), updated.getPerformedTasks()));
                    this.propagationManager.execute(tasks);
                }
                if (LOG.isDebugEnabled()) {
                    UserTO savedTO = this.userDataBinder.getUserTO(updated.getResult());
                    LOG.debug("About to return suspended user\n{}", (Object)savedTO);
                }
            }
            catch (Exception e) {
                LOG.error("Error during user suspension", (Throwable)e);
            }
        }
    }
}

