/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import java.util.Arrays;
import java.util.List;
import javax.persistence.Transient;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.core.persistence.beans.user.UDerSchema;
import org.apache.syncope.core.persistence.beans.user.USchema;
import org.apache.syncope.core.persistence.beans.user.UVirSchema;
import org.apache.syncope.core.persistence.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.validation.entity.USchemaCheck;
import org.apache.syncope.types.EntityViolationType;

public class USchemaValidator
extends AbstractValidator
implements ConstraintValidator<USchemaCheck, Object> {
    @Transient
    private static List<String> PERMITTED_USCHEMA_NAMES = Arrays.asList("failedLogins", "username", "password", "lastLoginDate", "creationDate", "changePwdDate");

    public void initialize(USchemaCheck constraintAnnotation) {
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        EntityViolationType violation = null;
        try {
            if (object != null) {
                String schemaName;
                if (object instanceof USchema) {
                    schemaName = ((USchema)object).getName();
                    violation = EntityViolationType.InvalidUSchema;
                } else if (object instanceof UDerSchema) {
                    schemaName = ((UDerSchema)object).getName();
                    violation = EntityViolationType.InvalidUDerSchema;
                } else if (object instanceof UVirSchema) {
                    schemaName = ((UVirSchema)object).getName();
                    violation = EntityViolationType.InvalidUVirSchema;
                } else {
                    schemaName = null;
                }
                if (PERMITTED_USCHEMA_NAMES.contains(schemaName)) {
                    throw new Exception("Schema name not permitted");
                }
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("Error saving schema", (Throwable)e);
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(violation.toString()).addNode(object.toString()).addConstraintViolation();
            return false;
        }
    }
}

