/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.core.persistence.beans.AccountPolicy;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.PasswordPolicy;
import org.apache.syncope.core.persistence.beans.role.SyncopeRole;
import org.apache.syncope.core.persistence.beans.user.SyncopeUser;
import org.apache.syncope.core.persistence.dao.PolicyDAO;
import org.apache.syncope.core.persistence.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.validation.entity.SyncopeUserCheck;
import org.apache.syncope.core.policy.AccountPolicyEnforcer;
import org.apache.syncope.core.policy.PasswordPolicyEnforcer;
import org.apache.syncope.core.policy.PolicyEvaluator;
import org.apache.syncope.types.AccountPolicySpec;
import org.apache.syncope.types.EntityViolationType;
import org.apache.syncope.types.PasswordPolicySpec;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncopeUserValidator
extends AbstractValidator
implements ConstraintValidator<SyncopeUserCheck, SyncopeUser> {
    @Autowired
    private PolicyDAO policyDAO;
    @Autowired
    private PolicyEvaluator evaluator;
    @Autowired
    private PasswordPolicyEnforcer ppEnforcer;
    @Autowired
    private AccountPolicyEnforcer apEnforcer;

    public void initialize(SyncopeUserCheck constraintAnnotation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(SyncopeUser object, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        LOG.debug("Password Policy enforcement");
        try {
            for (PasswordPolicy passwordPolicy : this.getPasswordPolicies(object)) {
                String password = object.getClearPassword();
                if (password == null) continue;
                PasswordPolicySpec passwordPolicy2 = (PasswordPolicySpec)this.evaluator.evaluate(passwordPolicy, object);
                this.ppEnforcer.enforce(passwordPolicy2, passwordPolicy.getType(), password);
            }
        }
        catch (Exception e) {
            LOG.debug("Invalid password");
            context.buildConstraintViolationWithTemplate(e.getMessage()).addNode(EntityViolationType.InvalidPassword.toString()).addConstraintViolation();
            boolean bl = false;
            return bl;
        }
        finally {
            object.removeClearPassword();
        }
        LOG.debug("Account Policy enforcement");
        try {
            for (AccountPolicy accountPolicy : this.getAccountPolicies(object)) {
                AccountPolicySpec accountPolicy2 = (AccountPolicySpec)this.evaluator.evaluate(accountPolicy, object);
                this.apEnforcer.enforce(accountPolicy2, accountPolicy.getType(), object);
            }
        }
        catch (Exception e) {
            LOG.debug("Invalid username");
            context.buildConstraintViolationWithTemplate(e.getMessage()).addNode(EntityViolationType.InvalidUsername.toString()).addConstraintViolation();
            return false;
        }
        return true;
    }

    private List<PasswordPolicy> getPasswordPolicies(SyncopeUser user) {
        ArrayList<PasswordPolicy> policies = new ArrayList<PasswordPolicy>();
        PasswordPolicy policy = this.policyDAO.getGlobalPasswordPolicy();
        if (policy != null) {
            policies.add(policy);
        }
        for (ExternalResource resource : user.getResources()) {
            policy = resource.getPasswordPolicy();
            if (policy == null) continue;
            policies.add(policy);
        }
        for (SyncopeRole role : user.getRoles()) {
            policy = role.getPasswordPolicy();
            if (policy == null) continue;
            policies.add(policy);
        }
        return policies;
    }

    private List<AccountPolicy> getAccountPolicies(SyncopeUser user) {
        ArrayList<AccountPolicy> policies = new ArrayList<AccountPolicy>();
        AccountPolicy policy = this.policyDAO.getGlobalAccountPolicy();
        if (policy != null) {
            policies.add(policy);
        }
        for (ExternalResource resource : user.getResources()) {
            policy = resource.getAccountPolicy();
            if (policy == null) continue;
            policies.add(policy);
        }
        for (SyncopeRole role : user.getRoles()) {
            policy = role.getAccountPolicy();
            if (policy == null) continue;
            policies.add(policy);
        }
        return policies;
    }
}

