/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.StringUtils;
import org.apache.syncope.core.persistence.beans.SyncTask;
import org.apache.syncope.core.persistence.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.validation.entity.SchedTaskValidator;
import org.apache.syncope.core.persistence.validation.entity.SyncTaskCheck;
import org.apache.syncope.core.scheduling.SyncJobActions;
import org.apache.syncope.types.EntityViolationType;

public class SyncTaskValidator
extends AbstractValidator
implements ConstraintValidator<SyncTaskCheck, SyncTask> {
    private final SchedTaskValidator schedV = new SchedTaskValidator();

    public void initialize(SyncTaskCheck constraintAnnotation) {
    }

    public boolean isValid(SyncTask object, ConstraintValidatorContext context) {
        boolean isValid;
        if (object == null) {
            isValid = true;
        } else {
            isValid = this.schedV.isValid(object, context);
            if (isValid) {
                boolean bl = isValid = object.getResource() != null;
                if (!isValid) {
                    LOG.error("Resource is null");
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate(EntityViolationType.InvalidSyncTask.toString()).addNode(object + ".resource is NULL").addConstraintViolation();
                }
                if (StringUtils.isNotBlank((String)object.getJobActionsClassName())) {
                    Class<?> syncJobActionsClass = null;
                    boolean isAssignable = false;
                    try {
                        syncJobActionsClass = Class.forName(object.getJobActionsClassName());
                        isAssignable = SyncJobActions.class.isAssignableFrom(syncJobActionsClass);
                    }
                    catch (Exception e) {
                        LOG.error("Invalid SyncJobActions specified", (Throwable)e);
                        isValid = false;
                    }
                    if (syncJobActionsClass == null || !isAssignable) {
                        isValid = false;
                        context.disableDefaultConstraintViolation();
                        context.buildConstraintViolationWithTemplate(EntityViolationType.InvalidSyncTask.toString()).addNode(object + ".syncJobActionsClassName is not valid").addConstraintViolation();
                    }
                }
            }
        }
        return isValid;
    }
}

