/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.validation.entity.SchemaCheck;
import org.apache.syncope.types.EntityViolationType;
import org.apache.syncope.types.SchemaType;

public class SchemaValidator
extends AbstractValidator
implements ConstraintValidator<SchemaCheck, AbstractSchema> {
    public void initialize(SchemaCheck constraintAnnotation) {
    }

    public boolean isValid(AbstractSchema object, ConstraintValidatorContext context) {
        boolean isValid = false;
        EntityViolationType violation = null;
        try {
            if (object == null) {
                isValid = true;
            } else {
                boolean bl = isValid = object.getType() == null || !object.getType().equals((Object)SchemaType.Enum) || object.getEnumerationValues() != null;
                if (!isValid) {
                    violation = EntityViolationType.InvalidSchemaTypeSpecification;
                    throw new Exception(object + " miss enumeration values");
                }
                boolean bl2 = object.isMultivalue() ? !object.isUniqueConstraint() : (isValid = true);
                if (!isValid) {
                    violation = EntityViolationType.MultivalueAndUniqueConstraint;
                    throw new Exception(object + " cannot be multivalue and have " + "unique constraint at the same time");
                }
            }
            return isValid;
        }
        catch (Exception e) {
            LOG.error("Error saving schema", (Throwable)e);
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(violation.toString()).addNode(object.toString()).addConstraintViolation();
            return false;
        }
    }
}

