/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.StringUtils;
import org.apache.syncope.core.persistence.beans.SchemaMapping;
import org.apache.syncope.core.persistence.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.validation.entity.SchemaMappingCheck;
import org.apache.syncope.core.util.SchemaMappingUtil;
import org.apache.syncope.types.EntityViolationType;
import org.apache.syncope.types.IntMappingType;

public class SchemaMappingValidator
extends AbstractValidator
implements ConstraintValidator<SchemaMappingCheck, SchemaMapping> {
    public void initialize(SchemaMappingCheck constraintAnnotation) {
    }

    public boolean isValid(SchemaMapping mapping, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (StringUtils.isBlank((String)SchemaMappingUtil.getExtAttrName(mapping))) {
            context.buildConstraintViolationWithTemplate("Missing external attribute name").addNode(EntityViolationType.InvalidSchemaMapping.toString()).addConstraintViolation();
            return false;
        }
        if (StringUtils.isBlank((String)SchemaMappingUtil.getIntAttrName(mapping))) {
            context.buildConstraintViolationWithTemplate("Missing internal attribute name").addNode(EntityViolationType.InvalidSchemaMapping.toString()).addConstraintViolation();
            return false;
        }
        if (mapping.isAccountid() && (IntMappingType.UserVirtualSchema == mapping.getIntMappingType() || IntMappingType.RoleVirtualSchema == mapping.getIntMappingType() || IntMappingType.MembershipVirtualSchema == mapping.getIntMappingType() || IntMappingType.Password == mapping.getIntMappingType())) {
            context.buildConstraintViolationWithTemplate("Virtual attribute as accountId is not permitted").addNode(EntityViolationType.InvalidSchemaMapping.toString()).addConstraintViolation();
            return false;
        }
        if (mapping.isAccountid() && (IntMappingType.Password == mapping.getIntMappingType() || mapping.isPassword())) {
            context.buildConstraintViolationWithTemplate("Password as accountId is not permitted").addNode(EntityViolationType.InvalidSchemaMapping.toString()).addConstraintViolation();
            return false;
        }
        return true;
    }
}

