/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import java.text.ParseException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.core.persistence.beans.SchedTask;
import org.apache.syncope.core.persistence.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.validation.entity.SchedTaskCheck;
import org.apache.syncope.core.scheduling.AbstractTaskJob;
import org.apache.syncope.types.EntityViolationType;
import org.quartz.CronExpression;

public class SchedTaskValidator
extends AbstractValidator
implements ConstraintValidator<SchedTaskCheck, SchedTask> {
    public void initialize(SchedTaskCheck constraintAnnotation) {
    }

    public boolean isValid(SchedTask object, ConstraintValidatorContext context) {
        boolean isValid = true;
        Class<?> jobClass = null;
        try {
            jobClass = Class.forName(object.getJobClassName());
            isValid = AbstractTaskJob.class.isAssignableFrom(jobClass);
        }
        catch (Exception e) {
            LOG.error("Invalid Job class specified", (Throwable)e);
            isValid = false;
        }
        if (jobClass == null || !isValid) {
            isValid = false;
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(EntityViolationType.InvalidSchedTask.toString()).addNode(object + ".jobClassName is not valid").addConstraintViolation();
        }
        if (isValid && object.getCronExpression() != null) {
            try {
                new CronExpression(object.getCronExpression());
            }
            catch (ParseException e) {
                LOG.error("Invalid cron expression '" + object.getCronExpression() + "'", (Throwable)e);
                isValid = false;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(EntityViolationType.InvalidSchedTask.toString()).addNode(object + ".cronExpression==" + object.getCronExpression()).addConstraintViolation();
            }
        }
        return isValid;
    }
}

