/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import java.text.ParseException;
import java.util.HashSet;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.client.report.ReportletConf;
import org.apache.syncope.core.persistence.beans.Report;
import org.apache.syncope.core.persistence.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.validation.entity.ReportCheck;
import org.apache.syncope.types.EntityViolationType;
import org.quartz.CronExpression;

public class ReportValidator
extends AbstractValidator
implements ConstraintValidator<ReportCheck, Report> {
    public void initialize(ReportCheck constraintAnnotation) {
    }

    public boolean isValid(Report object, ConstraintValidatorContext context) {
        boolean isValid = true;
        if (object.getCronExpression() != null) {
            try {
                new CronExpression(object.getCronExpression());
            }
            catch (ParseException e) {
                LOG.error("Invalid cron expression '" + object.getCronExpression() + "'", (Throwable)e);
                isValid = false;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(EntityViolationType.InvalidReport.name()).addNode(object + ".cronExpression==" + object.getCronExpression()).addConstraintViolation();
            }
        }
        HashSet<String> reportletNames = new HashSet<String>();
        for (ReportletConf conf : object.getReportletConfs()) {
            reportletNames.add(conf.getName());
        }
        if (reportletNames.size() != object.getReportletConfs().size()) {
            LOG.error("Reportlet name must be unique");
            isValid = false;
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(EntityViolationType.InvalidReport.name()).addNode(object + ".reportletConfs with duplicate names").addConstraintViolation();
        }
        return isValid;
    }
}

