/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.core.persistence.beans.PropagationTask;
import org.apache.syncope.core.persistence.beans.TaskExec;
import org.apache.syncope.core.persistence.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.validation.entity.PropagationTaskCheck;
import org.apache.syncope.types.EntityViolationType;
import org.apache.syncope.types.PropagationTaskExecStatus;

public class PropagationTaskValidator
extends AbstractValidator
implements ConstraintValidator<PropagationTaskCheck, PropagationTask> {
    public void initialize(PropagationTaskCheck constraintAnnotation) {
    }

    public boolean isValid(PropagationTask object, ConstraintValidatorContext context) {
        boolean isValid;
        if (object == null) {
            isValid = true;
        } else {
            boolean bl = isValid = object.getPropagationMode() != null && object.getPropagationOperation() != null && !object.getAttributes().isEmpty() && object.getResource() != null;
            if (isValid) {
                List<TaskExec> executions = object.getExecs();
                for (TaskExec execution : executions) {
                    try {
                        PropagationTaskExecStatus.valueOf((String)execution.getStatus());
                    }
                    catch (IllegalArgumentException e) {
                        LOG.error("Invalid execution status '" + execution.getStatus() + "'", (Throwable)e);
                        isValid = false;
                    }
                }
            }
            if (!isValid) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(EntityViolationType.InvalidPropagationTask.toString()).addConstraintViolation();
            }
        }
        return isValid;
    }
}

