/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.core.persistence.beans.AccountPolicy;
import org.apache.syncope.core.persistence.beans.PasswordPolicy;
import org.apache.syncope.core.persistence.beans.Policy;
import org.apache.syncope.core.persistence.beans.SyncPolicy;
import org.apache.syncope.core.persistence.dao.PolicyDAO;
import org.apache.syncope.core.persistence.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.validation.entity.PolicyCheck;
import org.apache.syncope.types.AccountPolicySpec;
import org.apache.syncope.types.EntityViolationType;
import org.apache.syncope.types.PasswordPolicySpec;
import org.apache.syncope.types.SyncPolicySpec;
import org.springframework.beans.factory.annotation.Autowired;

public class PolicyValidator
extends AbstractValidator
implements ConstraintValidator<PolicyCheck, Policy> {
    @Autowired
    private PolicyDAO policyDAO;

    public void initialize(PolicyCheck constraintAnnotation) {
    }

    public boolean isValid(Policy object, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (object.getSpecification() != null && (object instanceof PasswordPolicy && !(object.getSpecification() instanceof PasswordPolicySpec) || object instanceof AccountPolicy && !(object.getSpecification() instanceof AccountPolicySpec) || object instanceof SyncPolicy && !(object.getSpecification() instanceof SyncPolicySpec))) {
            context.buildConstraintViolationWithTemplate("Invalid policy specification").addNode(EntityViolationType.valueOf((String)("Invalid" + object.getClass().getSimpleName())).name()).addConstraintViolation();
            return false;
        }
        switch (object.getType()) {
            case GLOBAL_PASSWORD: {
                PasswordPolicy passwordPolicy = this.policyDAO.getGlobalPasswordPolicy();
                if (passwordPolicy == null || passwordPolicy.getId().equals(object.getId())) break;
                context.buildConstraintViolationWithTemplate("Password policy already exists").addNode(EntityViolationType.InvalidPasswordPolicy.name()).addConstraintViolation();
                return false;
            }
            case GLOBAL_ACCOUNT: {
                AccountPolicy accountPolicy = this.policyDAO.getGlobalAccountPolicy();
                if (accountPolicy == null || accountPolicy.getId().equals(object.getId())) break;
                context.buildConstraintViolationWithTemplate("Global Account policy already exists").addNode(EntityViolationType.InvalidAccountPolicy.name()).addConstraintViolation();
                return false;
            }
            case GLOBAL_SYNC: {
                SyncPolicy syncPolicy = this.policyDAO.getGlobalSyncPolicy();
                if (syncPolicy == null || syncPolicy.getId().equals(object.getId())) break;
                context.buildConstraintViolationWithTemplate("Global Sync policy already exists").addNode(EntityViolationType.InvalidSyncPolicy.name()).addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

