/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.core.persistence.beans.Notification;
import org.apache.syncope.core.persistence.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.validation.entity.NotificationCheck;
import org.apache.syncope.types.EntityViolationType;

public class NotificationValidator
extends AbstractValidator
implements ConstraintValidator<NotificationCheck, Notification> {
    public void initialize(NotificationCheck constraintAnnotation) {
    }

    public boolean isValid(Notification value, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (value.getEvents().isEmpty()) {
            isValid = false;
            context.buildConstraintViolationWithTemplate("No events").addNode(EntityViolationType.InvalidNotification.toString()).addNode("events").addConstraintViolation();
        }
        if (!value.getAbout().checkValidity()) {
            isValid = false;
            context.buildConstraintViolationWithTemplate("Invalid about search condition").addNode(EntityViolationType.InvalidNotification.toString()).addNode("about").addConstraintViolation();
        }
        if (value.getRecipients() != null && !value.getRecipients().checkValidity() && !value.isSelfAsRecipient()) {
            isValid = false;
            context.buildConstraintViolationWithTemplate("Invalid recipients search condition").addNode(EntityViolationType.InvalidNotification.toString()).addNode("recipients").addConstraintViolation();
        }
        return isValid;
    }
}

