/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import org.apache.syncope.types.EntityViolationType;

public class InvalidEntityException
extends ValidationException {
    private static final long serialVersionUID = 3249297275444409691L;
    private String entityClassSimpleName;
    private final Map<Class, Set<EntityViolationType>> violations;

    public InvalidEntityException(String entityClassSimpleName, Set<ConstraintViolation<Object>> violations) {
        this.entityClassSimpleName = entityClassSimpleName;
        this.violations = new HashMap<Class, Set<EntityViolationType>>();
        for (ConstraintViolation<Object> violation : violations) {
            EntityViolationType entityViolationType;
            try {
                entityViolationType = EntityViolationType.valueOf((String)violation.getMessageTemplate());
            }
            catch (IllegalArgumentException e) {
                entityViolationType = EntityViolationType.Standard;
                entityViolationType.setMessageTemplate(violation.getPropertyPath() + ": " + violation.getMessage());
            }
            if (!this.violations.containsKey(violation.getLeafBean().getClass())) {
                this.violations.put(violation.getLeafBean().getClass(), EnumSet.noneOf(EntityViolationType.class));
            }
            this.violations.get(violation.getLeafBean().getClass()).add(entityViolationType);
        }
    }

    public final boolean hasViolation(EntityViolationType type) {
        boolean found = false;
        for (Class entity : this.violations.keySet()) {
            if (!this.violations.get(entity).contains(type)) continue;
            found = true;
        }
        return found;
    }

    public String getEntityClassSimpleName() {
        return this.entityClassSimpleName;
    }

    public final Map<Class, Set<EntityViolationType>> getViolations() {
        return this.violations;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        for (Class entity : this.violations.keySet()) {
            sb.append(entity.getSimpleName()).append(" ").append(this.violations.get(entity).toString()).append(", ");
        }
        sb.delete(sb.lastIndexOf(", "), sb.length());
        return sb.toString();
    }
}

