/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.core.persistence.beans.ExternalResource;
import org.apache.syncope.core.persistence.beans.SchemaMapping;
import org.apache.syncope.core.persistence.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.validation.entity.ExternalResourceCheck;
import org.apache.syncope.types.EntityViolationType;

public class ExternalResourceValidator
extends AbstractValidator
implements ConstraintValidator<ExternalResourceCheck, ExternalResource> {
    public void initialize(ExternalResourceCheck constraintAnnotation) {
    }

    public boolean isValid(ExternalResource object, ConstraintValidatorContext context) {
        boolean isValid;
        if (object == null) {
            isValid = true;
        } else {
            int accountIds = 0;
            for (SchemaMapping mapping : object.getMappings()) {
                if (!mapping.isAccountid()) continue;
                ++accountIds;
            }
            boolean bl = isValid = accountIds == 1;
            if (!isValid) {
                LOG.error("Mappings for " + object + " have 0 or >1 account ids");
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(EntityViolationType.InvalidAccountIdCount.toString()).addNode(object + ".accountIds.size==" + accountIds).addConstraintViolation();
            }
        }
        return isValid;
    }
}

