/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import java.util.Set;
import javax.validation.Validator;
import org.apache.syncope.core.persistence.validation.entity.InvalidEntityException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class EntityValidationInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(EntityValidationInterceptor.class);
    @Autowired
    private Validator validator;

    @Around(value="execution(* org.apache.syncope.core.persistence.dao..*.save(..))")
    public final Object save(ProceedingJoinPoint pjp) throws Throwable {
        Set violations = this.validator.validate(pjp.getArgs()[0], new Class[0]);
        if (!violations.isEmpty()) {
            LOG.error("Bean validation errors found: {}", (Object)violations);
            throw new InvalidEntityException(pjp.getArgs()[0].getClass().getSimpleName(), violations);
        }
        return pjp.proceed();
    }
}

