/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.core.persistence.beans.Entitlement;
import org.apache.syncope.core.persistence.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.validation.entity.EntitlementCheck;
import org.apache.syncope.types.EntityViolationType;

public class EntitlementValidator
extends AbstractValidator
implements ConstraintValidator<EntitlementCheck, Entitlement> {
    private static final Pattern ROLE_ENTITLEMENT_NAME_PATTERN = Pattern.compile("^ROLE_([\\d])+");

    public void initialize(EntitlementCheck constraintAnnotation) {
    }

    public boolean isValid(Entitlement object, ConstraintValidatorContext context) {
        boolean isValid = false;
        if (object == null) {
            isValid = true;
        } else {
            if (object.getName() == null) {
                isValid = false;
            } else {
                Matcher matcher = ROLE_ENTITLEMENT_NAME_PATTERN.matcher(object.getName());
                boolean bl = isValid = !matcher.matches();
            }
            if (!isValid) {
                LOG.error(object + " cannot have name " + "starting by ROLE_");
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(EntityViolationType.InvalidEntitlementName.toString()).addNode(object.toString()).addConstraintViolation();
            }
        }
        return isValid;
    }
}

