/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.core.persistence.beans.AbstractAttr;
import org.apache.syncope.core.persistence.beans.AbstractAttrUniqueValue;
import org.apache.syncope.core.persistence.beans.AbstractAttrValue;
import org.apache.syncope.core.persistence.beans.AbstractBaseBean;
import org.apache.syncope.core.persistence.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.validation.entity.AttrValueCheck;
import org.apache.syncope.types.EntityViolationType;

public class AttrValueValidator
extends AbstractValidator
implements ConstraintValidator<AttrValueCheck, AbstractAttrValue> {
    public void initialize(AttrValueCheck constraintAnnotation) {
    }

    public boolean isValid(AbstractAttrValue object, ConstraintValidatorContext context) {
        boolean isValid;
        if (object == null) {
            isValid = true;
        } else {
            Object attrSchema;
            Object uniqueValueSchema;
            int nonNullVales = 0;
            if (object.getBooleanValue() != null) {
                ++nonNullVales;
            }
            if (object.getDateValue() != null) {
                ++nonNullVales;
            }
            if (object.getDoubleValue() != null) {
                ++nonNullVales;
            }
            if (object.getLongValue() != null) {
                ++nonNullVales;
            }
            if (object.getStringValue() != null) {
                ++nonNullVales;
            }
            boolean bl = isValid = nonNullVales == 1;
            if (!isValid) {
                LOG.error("More than one non-null value for " + object);
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(EntityViolationType.MoreThanOneNonNull.toString()).addNode(object.toString().replaceAll("\\n", " ")).addConstraintViolation();
            } else if (object instanceof AbstractAttrUniqueValue && !(isValid = ((AbstractBaseBean)(uniqueValueSchema = ((AbstractAttrUniqueValue)object).getSchema())).equals(attrSchema = ((AbstractAttr)object.getAttribute()).getSchema()))) {
                LOG.error("Unique value schema for " + object.getClass().getSimpleName() + "[" + object.getId() + "]" + " is " + uniqueValueSchema + ", while owning " + "attribute schema is " + attrSchema);
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(EntityViolationType.valueOf((String)("Invalid" + attrSchema.getClass().getSimpleName())).toString()).addNode(object.getClass().getSimpleName() + "[" + object.getId() + "].schema=" + uniqueValueSchema + " != " + attrSchema).addConstraintViolation();
            }
        }
        return isValid;
    }
}

