/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.entity;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.core.persistence.beans.AbstractAttr;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.validation.entity.AttrCheck;
import org.apache.syncope.types.EntityViolationType;

public class AttrValidator
extends AbstractValidator
implements ConstraintValidator<AttrCheck, AbstractAttr> {
    public void initialize(AttrCheck constraintAnnotation) {
    }

    public boolean isValid(AbstractAttr object, ConstraintValidatorContext context) {
        boolean isValid;
        if (object == null) {
            isValid = true;
        } else {
            if (((AbstractSchema)object.getSchema()).isUniqueConstraint()) {
                isValid = object.getValues().isEmpty() && object.getUniqueValue() != null;
            } else {
                boolean bl = isValid = !object.getValues().isEmpty() && object.getUniqueValue() == null;
                if (!((AbstractSchema)object.getSchema()).isMultivalue()) {
                    isValid &= object.getValues().size() == 1;
                }
            }
            if (!isValid) {
                LOG.error("Invalid values for attribute " + object + ": " + "schema=" + ((AbstractSchema)object.getSchema()).getName() + ", " + "values={}", object.getValuesAsStrings());
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(EntityViolationType.InvalidValueList.toString()).addNode(object + "(" + ((AbstractSchema)object.getSchema()).getName() + ")" + "{" + object.getValuesAsStrings() + "}").addConstraintViolation();
            }
        }
        return isValid;
    }
}

