/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.attrvalue;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.syncope.core.persistence.beans.AbstractAttrValue;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.validation.attrvalue.AbstractValidator;
import org.apache.syncope.core.persistence.validation.attrvalue.InvalidAttrValueException;

public class EmailAddressValidator
extends AbstractValidator {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[\\w\\-]([\\.\\w])+[\\w]+@([\\w\\-]+\\.)+[A-Z]{2,4}$", 2);

    public EmailAddressValidator(AbstractSchema schema) {
        super(schema);
    }

    protected void doValidate(AbstractAttrValue attributeValue) throws InvalidAttrValueException {
        Matcher matcher = EMAIL_PATTERN.matcher((CharSequence)attributeValue.getValue());
        if (!matcher.matches()) {
            throw new InvalidAttrValueException(attributeValue);
        }
    }
}

