/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.attrvalue;

import org.apache.syncope.core.persistence.beans.AbstractAttrValue;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.validation.attrvalue.AbstractValidator;
import org.apache.syncope.core.persistence.validation.attrvalue.InvalidAttrValueException;
import org.apache.syncope.types.SchemaType;

public class BasicValidator
extends AbstractValidator {
    private static final long serialVersionUID = -2606728447694223607L;

    public BasicValidator(AbstractSchema schema) {
        super(schema);
    }

    protected void doValidate(AbstractAttrValue attributeValue) throws InvalidAttrValueException {
        if (SchemaType.Enum.equals((Object)this.schema.getType())) {
            String[] enumeration = this.schema.getEnumerationValues().split(AbstractSchema.enumValuesSeparator);
            String value = attributeValue.getStringValue();
            Boolean found = Boolean.FALSE;
            for (int i = 0; i < enumeration.length && !found.booleanValue(); ++i) {
                if (!enumeration[i].trim().equals(value)) continue;
                found = Boolean.TRUE;
            }
            if (!found.booleanValue()) {
                throw new InvalidAttrValueException(attributeValue);
            }
        }
    }
}

