/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.validation.attrvalue;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.apache.syncope.client.SyncopeConstants;
import org.apache.syncope.core.persistence.beans.AbstractAttrValue;
import org.apache.syncope.core.persistence.beans.AbstractSchema;
import org.apache.syncope.core.persistence.validation.attrvalue.InvalidAttrValueException;
import org.apache.syncope.core.persistence.validation.attrvalue.ParsingValidationException;
import org.apache.syncope.core.persistence.validation.attrvalue.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValidator
implements Validator,
Serializable {
    private static final long serialVersionUID = -5439345166669502493L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractValidator.class);
    protected final AbstractSchema schema;

    public AbstractValidator(AbstractSchema schema) {
        this.schema = schema;
    }

    @Override
    public <T extends AbstractAttrValue> void validate(String value, T attributeValue) throws ParsingValidationException, InvalidAttrValueException {
        this.parseValue(value, attributeValue);
        this.doValidate(attributeValue);
    }

    private <T extends AbstractAttrValue> void parseValue(String value, T attributeValue) throws ParsingValidationException {
        Exception exception = null;
        switch (this.schema.getType()) {
            case String: 
            case Enum: {
                attributeValue.setStringValue(value);
                break;
            }
            case Boolean: {
                attributeValue.setBooleanValue(Boolean.parseBoolean(value));
                break;
            }
            case Long: {
                try {
                    if (this.schema.getFormatter() == null) {
                        attributeValue.setLongValue(Long.valueOf(value));
                        break;
                    }
                    attributeValue.setLongValue(((DecimalFormat)this.schema.getFormatter()).parse(value).longValue());
                }
                catch (Exception pe) {
                    exception = pe;
                }
                break;
            }
            case Double: {
                try {
                    if (this.schema.getFormatter() == null) {
                        attributeValue.setDoubleValue(Double.valueOf(value));
                        break;
                    }
                    attributeValue.setDoubleValue(((DecimalFormat)this.schema.getFormatter()).parse(value).doubleValue());
                }
                catch (Exception pe) {
                    exception = pe;
                }
                break;
            }
            case Date: {
                try {
                    if (this.schema.getFormatter() == null) {
                        attributeValue.setDateValue(DateUtils.parseDate((String)value, (String[])SyncopeConstants.DATE_PATTERNS));
                        break;
                    }
                    attributeValue.setDateValue(new Date(((DateFormat)this.schema.getFormatter()).parse(value).getTime()));
                }
                catch (Exception pe) {
                    exception = pe;
                }
                break;
            }
        }
        if (exception != null) {
            throw new ParsingValidationException("While trying to parse '" + value + "'", exception);
        }
    }

    protected abstract <T extends AbstractAttrValue> void doValidate(T var1) throws InvalidAttrValueException;
}

