/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.openjpa;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.lib.meta.ClassArgParser;
import org.apache.openjpa.lib.meta.ClasspathMetaDataIterator;
import org.apache.openjpa.lib.meta.FileMetaDataIterator;
import org.apache.openjpa.lib.meta.JarFileURLMetaDataIterator;
import org.apache.openjpa.lib.meta.MetaDataIterator;
import org.apache.openjpa.lib.meta.ResourceMetaDataIterator;
import org.apache.openjpa.lib.meta.URLMetaDataIterator;
import org.apache.openjpa.lib.meta.ZipFileMetaDataIterator;
import org.apache.openjpa.lib.meta.ZipStreamMetaDataIterator;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.PersistenceMetaDataFactory;
import org.apache.openjpa.persistence.jdbc.PersistenceMappingFactory;

public class JBossPersistenceMappingFactory
extends PersistenceMappingFactory {
    private static final Localizer _loc = Localizer.forPackage(PersistenceMetaDataFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(MetaDataIterator mitr, ClassArgParser cparser, Set names, boolean mapNames, Object debugContext) throws IOException {
        Map map;
        try {
            map = cparser.mapTypeNames(mitr);
        }
        finally {
            mitr.close();
        }
        for (Map.Entry entry : map.entrySet()) {
            if (mapNames) {
                this.mapPersistentTypeNames(entry.getKey(), (String[])entry.getValue());
            }
            List<String> newNames = Arrays.asList((String[])entry.getValue());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)_loc.get("scan-found-names", newNames, debugContext));
            }
            names.addAll(newNames);
        }
    }

    protected Set<String> parsePersistentTypeNames(ClassLoader loader) throws IOException {
        List<String> newNames;
        String[] clss;
        ClassArgParser cparser = this.newClassArgParser();
        HashSet<String> names = new HashSet<String>();
        if (this.files != null) {
            for (File file : this.files) {
                if (((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isDirectoryAction((File)file))).booleanValue()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)_loc.get("scanning-directory", (Object)file));
                    }
                    this.scan((MetaDataIterator)new FileMetaDataIterator(file, this.newMetaDataFilter()), cparser, names, true, file);
                    continue;
                }
                if (file.getName().endsWith(".jar")) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)_loc.get("scanning-jar", (Object)file));
                    }
                    try {
                        ZipFile zFile = (ZipFile)AccessController.doPrivileged(J2DoPrivHelper.newZipFileAction((File)file));
                        this.scan((MetaDataIterator)new ZipFileMetaDataIterator(zFile, this.newMetaDataFilter()), cparser, names, true, file);
                        continue;
                    }
                    catch (PrivilegedActionException pae) {
                        throw (IOException)pae.getException();
                    }
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)_loc.get("scanning-file", (Object)file));
                }
                clss = cparser.parseTypeNames((MetaDataIterator)new FileMetaDataIterator(file));
                newNames = Arrays.asList(clss);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)_loc.get("scan-found-names", newNames, (Object)file));
                }
                names.addAll(newNames);
                File f = (File)AccessController.doPrivileged(J2DoPrivHelper.getAbsoluteFileAction((File)file));
                try {
                    this.mapPersistentTypeNames(AccessController.doPrivileged(J2DoPrivHelper.toURLAction((File)f)), clss);
                }
                catch (PrivilegedActionException pae) {
                    throw (FileNotFoundException)pae.getException();
                }
            }
        }
        if (this.urls != null) {
            for (URL url : this.urls) {
                if ("file".equals(url.getProtocol())) {
                    File file = (File)AccessController.doPrivileged(J2DoPrivHelper.getAbsoluteFileAction((File)new File(url.getFile())));
                    if (this.files != null && this.files.contains(file)) continue;
                    if (((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isDirectoryAction((File)file))).booleanValue()) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)_loc.get("scanning-directory", (Object)file));
                        }
                        this.scan((MetaDataIterator)new FileMetaDataIterator(file, this.newMetaDataFilter()), cparser, names, true, file);
                        continue;
                    }
                }
                if ("vfs".equals(url.getProtocol())) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)_loc.get("scanning-vfs-url", (Object)url));
                    }
                    URLConnection conn = url.openConnection();
                    Object vfsContent = conn.getContent();
                    try {
                        Class<?> virtualFileClass = Class.forName("org.jboss.vfs.VirtualFile");
                        Method getPhysicalFile = virtualFileClass.getDeclaredMethod("getPhysicalFile", new Class[0]);
                        File file = (File)getPhysicalFile.invoke(vfsContent, new Object[0]);
                        this.scan((MetaDataIterator)new FileMetaDataIterator(file, this.newMetaDataFilter()), cparser, names, true, file);
                    }
                    catch (Exception e) {
                        this.log.error((Object)_loc.get("while-scanning-vfs-url", (Object)url), (Throwable)e);
                    }
                    continue;
                }
                if ("jar".equals(url.getProtocol())) {
                    if (url.getPath().endsWith("!/")) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)_loc.get("scanning-jar-url", (Object)url));
                        }
                        this.scan((MetaDataIterator)new ZipFileMetaDataIterator(url, this.newMetaDataFilter()), cparser, names, true, url);
                        continue;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)_loc.get("scanning-jar-url", (Object)url));
                    }
                    this.scan((MetaDataIterator)new JarFileURLMetaDataIterator(url, this.newMetaDataFilter()), cparser, names, true, url);
                    continue;
                }
                if (url.getPath().endsWith(".jar")) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)_loc.get("scanning-jar-at-url", (Object)url));
                    }
                    try {
                        InputStream is = (InputStream)AccessController.doPrivileged(J2DoPrivHelper.openStreamAction((URL)url));
                        this.scan((MetaDataIterator)new ZipStreamMetaDataIterator(new ZipInputStream(is), this.newMetaDataFilter()), cparser, names, true, url);
                        continue;
                    }
                    catch (PrivilegedActionException pae) {
                        throw (IOException)pae.getException();
                    }
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)_loc.get("scanning-url", (Object)url));
                }
                clss = cparser.parseTypeNames((MetaDataIterator)new URLMetaDataIterator(url));
                newNames = Arrays.asList(clss);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)_loc.get("scan-found-names", newNames, (Object)url));
                }
                names.addAll(newNames);
                this.mapPersistentTypeNames(url, clss);
            }
        }
        if (this.rsrcs != null) {
            for (String rsrc : this.rsrcs) {
                String puUrlString;
                URL url;
                if (rsrc.endsWith(".jar")) {
                    url = (URL)AccessController.doPrivileged(J2DoPrivHelper.getResourceAction((ClassLoader)loader, (String)rsrc));
                    if (url == null) continue;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)_loc.get("scanning-jar-stream-url", (Object)url));
                    }
                    try {
                        InputStream is = (InputStream)AccessController.doPrivileged(J2DoPrivHelper.openStreamAction((URL)url));
                        this.scan((MetaDataIterator)new ZipStreamMetaDataIterator(new ZipInputStream(is), this.newMetaDataFilter()), cparser, names, true, url);
                        continue;
                    }
                    catch (PrivilegedActionException pae) {
                        throw (IOException)pae.getException();
                    }
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)_loc.get("scanning-resource", (Object)rsrc));
                }
                ResourceMetaDataIterator mitr = new ResourceMetaDataIterator(rsrc, loader);
                OpenJPAConfiguration conf = this.repos.getConfiguration();
                Map peMap = null;
                if (conf instanceof OpenJPAConfigurationImpl) {
                    peMap = ((OpenJPAConfigurationImpl)conf).getPersistenceEnvironment();
                }
                URL puUrl = peMap == null ? null : (URL)peMap.get("PersistenceUnitRootUrl");
                List mappingFileNames = peMap == null ? null : (List)peMap.get("MappingFileNames");
                List jars = peMap == null ? null : (List)peMap.get("JarFiles");
                String string = puUrlString = puUrl == null ? null : puUrl.toString();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)_loc.get("pu-root-url", (Object)puUrlString));
                }
                ArrayList<URL> mitrUrls = new ArrayList<URL>(3);
                while (mitr.hasNext()) {
                    url = (URL)mitr.next();
                    String urlString = url.toString();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)_loc.get("resource-url", (Object)urlString));
                    }
                    if (peMap != null) {
                        if (puUrlString != null && JBossPersistenceMappingFactory.decode((String)urlString).indexOf(JBossPersistenceMappingFactory.decode((String)puUrlString)) != -1) {
                            mitrUrls.add(url);
                        }
                        if (mappingFileNames != null && !mappingFileNames.isEmpty()) {
                            for (String mappingFileName : mappingFileNames) {
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace((Object)_loc.get("mapping-file-name", (Object)mappingFileName));
                                }
                                if (urlString.indexOf(mappingFileName) == -1) continue;
                                mitrUrls.add(url);
                            }
                        }
                        if (jars == null || jars.isEmpty()) continue;
                        for (URL jarUrl : jars) {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace((Object)_loc.get("jar-file-url", (Object)jarUrl));
                            }
                            if (urlString.indexOf(jarUrl.toString()) == -1) continue;
                            mitrUrls.add(url);
                        }
                        continue;
                    }
                    mitrUrls.add(url);
                }
                mitr.close();
                Iterator i$ = mitrUrls.iterator();
                while (i$.hasNext()) {
                    URL obj;
                    url = obj = (URL)i$.next();
                    clss = cparser.parseTypeNames((MetaDataIterator)new URLMetaDataIterator(url));
                    List<String> newNames2 = Arrays.asList(clss);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)_loc.get("scan-found-names", newNames2, (Object)rsrc));
                    }
                    names.addAll(newNames2);
                    this.mapPersistentTypeNames(url, clss);
                }
            }
        }
        if (this.cpath != null) {
            String[] dirs = this.cpath.toArray(new String[this.cpath.size()]);
            this.scan((MetaDataIterator)new ClasspathMetaDataIterator(dirs, this.newMetaDataFilter()), cparser, names, true, dirs);
        }
        if (this.types != null) {
            names.addAll(this.types);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)_loc.get("parse-found-names", names));
        }
        return names;
    }
}

